/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.ClientNotInRoutingTableException;
import com.tridium.ccn.ClientSameAddressAsJaceException;
import com.tridium.ccn.TunnelUdp2CcnRequest;
import com.tridium.ccn.UDPAck02Util;
import com.tridium.ccn.UDPAck06Util;
import com.tridium.ccn.UDPMessageProcessor;
import com.tridium.ccn.UDPNack15Util;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPTable20Util;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

class UDPUnsolicitedReceiveProcesser
extends UDPMessageProcessor {
    private int messageType;
    private boolean processMsg = false;
    private boolean respondPlain06 = false;
    private boolean respond02 = false;
    private boolean passThru = false;
    private boolean messageSupported = false;
    private static final int ALARM_MESSAGE = 1000000;
    private static final int LOCAL_DEFAULT_ADDRESS_MESSAGE = 1000001;
    private static final int LOCAL_ADDRESS_MESSAGE = 1000002;
    private static final int CCN_MESSAGE = 1000003;
    private static final int BROADCAST = 1000004;
    private static final int MULTICAST = 1000005;

    private void sendMockTable20Block02() {
        DatagramPacket rsp = UDPTable20Util.createTable20MockBlock02Packet(this);
        this.sendPacket(rsp);
    }

    private void ifNecessaryThenSendAck02() {
        this.debugf("ifNecessaryThenSendAck02 - entered method - respond02=" + this.respond02);
        if (this.respond02) {
            this.sendPacket(UDPAck02Util.createUdpAck02Packet(this));
        }
    }

    private void ifNecessaryThenSendPlainAck06() {
        this.debugf("ifNecessaryThenSendPlainAck06 - entered method - respondPlain06=" + this.respondPlain06);
        if (this.respondPlain06) {
            this.sendPacket(UDPAck06Util.createUdpPlainAck06Packet(this));
        }
    }

    private void sendUnsupportedNack15() {
        this.debugf("entered method sendUnsupportedNack15");
        this.sendPacket(UDPNack15Util.createUnsupportedNack15Packet(this));
    }

    private void processReceive() {
        this.debugf("Entered method processReceive");
        this.getMessageType();
        if (this.processMsg) {
            if (this.messageSupported) {
                this.debugf("processReceive - message is supported");
                this.furtherProcessReceive();
            } else {
                this.debugf("Received unsupported message via UDP/IP. Summary of Message ID follows.\n" + this.getIdSummary());
                this.sendUnsupportedNack15();
            }
        }
    }

    private void processLocalAddressMessage() {
        switch (this.iCmd) {
            case 11: {
                this.debugf("processLocalAddressMessage - they want to read a table block");
                break;
            }
            case 12: {
                if (this.isWriteToRoutingTable()) {
                    if (this.iTunnelHelper.ccnNetwork.getElemAddress() == this.iSourceAddr) {
                        throw new ClientSameAddressAsJaceException(this.iSourceAddr);
                    }
                    throw new UDPRoutingTableEntry(this);
                }
                this.debugf("processLocalAddressMessage - they want to write to one of my table's blocks, but not the routing table!");
                StringWriter debugStringWriter = new StringWriter();
                this.debugf("this is what they told me: " + debugStringWriter.toString());
                break;
            }
            default: {
                this.debugf("processLocalAddressMessage - they issued command " + this.iCmd + ", but I don't know what that means!");
            }
        }
    }

    private boolean isWriteToRoutingTable() {
        return new String(this.iPacket.getData(), 12, 8).equals("ROUTETAB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void furtherProcessReceive() {
        this.debugf("Entered method furtherProcessReceive.");
        this.ifNecessaryThenSendAck02();
        try {
            switch (this.messageType) {
                case 1000001: {
                    this.debugf("furtherProcessReceive - received message type LOCAL_DEFAULT_ADDRESS_MESSAGE");
                    this.sendMockTable20Block02();
                    return;
                }
                case 1000002: {
                    this.debugf("furtherProcessReceive - they want to talk to me!");
                    this.processLocalAddressMessage();
                    return;
                }
                case 1000003: {
                    this.debugf("Routing UPD message to CCN");
                    this.routeUdpToCcn();
                    return;
                }
                default: {
                    this.debugf("Server confused and unable to make any sense of the following message:\n" + this.getIdSummary());
                    return;
                }
            }
        }
        finally {
            this.ifNecessaryThenSendPlainAck06();
        }
    }

    public UDPUnsolicitedReceiveProcesser(DatagramPacket lPacket, CcnTunnelBack lTunnelBack, BCcnTunnelHelper lTunnelHelper, int lMyAddr, int lMyBus, boolean lDebug) {
        super(lPacket, lTunnelBack, lTunnelHelper, lMyAddr, lMyBus, false);
        this.processReceive();
    }

    public UDPUnsolicitedReceiveProcesser(DatagramPacket lPacket, DatagramSocket lSocket, BCcnTunnelHelper lTunnelHelper, int lMyAddr, int lMyBus, boolean lDebug) {
        super(lPacket, lSocket, lTunnelHelper, lMyAddr, lMyBus, false);
        this.processReceive();
    }

    private void getMessageType() {
        if (this.iDestAddr >= 241 && this.iDestAddr <= 254) {
            this.messageType = this.iDestBus == this.iDestAddr ? 1000004 : 1000005;
        } else if (this.iDestAddr == 255 && this.iDestBus == 0) {
            this.messageType = 1000000;
            this.passThru = true;
            this.respondPlain06 = true;
        } else if (this.iDestBus == 0 && this.iDestAddr == 0) {
            if (this.iCmd == 11) {
                this.messageType = 1000001;
                this.processMsg = true;
                this.messageSupported = true;
            }
        } else if (this.iDestBus == this.iMyBus && this.iDestAddr == this.iMyAddr) {
            this.messageType = 1000002;
            this.processMsg = !this.isWriteToRoutingTable() || UDPRoutingTableEntry.getDeviceType(this.iPacket.getData()) == 2;
            this.respondPlain06 = true;
            this.messageSupported = true;
        } else if (this.iCmd != 2) {
            if (this.iTunnelHelper.getRoutingTable().get(this.iSourceAddr) == null) {
                throw new ClientNotInRoutingTableException(this.iSourceAddr);
            }
            this.messageType = 1000003;
            this.respond02 = true;
            this.processMsg = true;
            this.messageSupported = true;
        }
    }

    private void routeUdpToCcn() {
        this.iTunnelHelper.getCcnAsyncReq().submitRequest(new TunnelUdp2CcnRequest(this, this.iTunnelHelper.getCcnTunnelBack()));
    }
}

