/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.UDPMessageProcessor;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.baja.sys.Clock;

class UDPRoutingTableEntry
extends RuntimeException {
    public int iCcnAddress;
    public int iUdpPort;
    public int iDeviceType;
    public int iAction;
    public int[] iUdpAddress = new int[4];
    public long iLastUpdateTicks;
    public static final int IP_ADDR_FIRST_LOC = 20;
    public static final int IP_ADDR_LAST_LOC = 23;
    public static final int PORT_HI_LOC = 24;
    public static final int PORT_LO_LOC = 25;
    public static final int CCN_ADDR_LOC = 26;
    public static final int DEV_TYPE_LOC = 27;
    public static final int ACTION_LOC = 28;
    public static final int ACTION_ADD_1 = 0;
    public static final int ACTION_ADD_2 = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_CHANGE = 3;
    public static final int DEFAULT_UDP_IP_PORT = 0;
    public static final int DEVICE_TYPE_COMFORT_WORKS = 2;
    public static final int DEVICE_TYPE_GATEWAY = 3;
    public static final int[] DEFAULT_UNUSED_IP_ADDR = new int[]{0, 0, 0, 0};

    public UDPRoutingTableEntry(UDPMessageProcessor ump) {
        this(ump.iPacket.getData());
    }

    public UDPRoutingTableEntry(DatagramPacket p) {
        this(p.getData());
    }

    public UDPRoutingTableEntry(int[] lUdpAddress, int lCcnBusAddress, int lUdpPort, int lDeviceType) {
        for (int i = 0; i < 4; ++i) {
            this.iUdpAddress[i] = lUdpAddress[i];
        }
        this.iCcnAddress = lCcnBusAddress;
        this.iUdpPort = lUdpPort;
        this.iDeviceType = lDeviceType;
        this.iAction = 1;
        this.iLastUpdateTicks = Clock.ticks();
    }

    public UDPRoutingTableEntry(byte[] udpPacketData) {
        this.parseUdpIpAddress(udpPacketData);
        this.parseUdpPort(udpPacketData);
        this.parseCcnAddress(udpPacketData);
        this.parseDeviceType(udpPacketData);
        this.parseAction(udpPacketData);
        this.iLastUpdateTicks = Clock.ticks();
    }

    @Override
    public String toString() {
        return "IP=" + this.iUdpAddress[0] + "." + this.iUdpAddress[1] + "." + this.iUdpAddress[2] + "." + this.iUdpAddress[3] + " Port=" + this.iUdpPort;
    }

    public boolean isActionDelete() {
        return this.iAction == 2;
    }

    public boolean isActionAdd() {
        return this.iAction == 0 || this.iAction == 1;
    }

    public boolean isActionChange() {
        return this.iAction == 3;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        String sIpAddr = "" + this.iUdpAddress[0] + "." + this.iUdpAddress[1] + "." + this.iUdpAddress[2] + "." + this.iUdpAddress[3];
        return InetAddress.getByName(sIpAddr);
    }

    public static void addBlankEntryTo(ByteArrayOutputStream b) {
        b.write(DEFAULT_UNUSED_IP_ADDR[0]);
        b.write(DEFAULT_UNUSED_IP_ADDR[1]);
        b.write(DEFAULT_UNUSED_IP_ADDR[2]);
        b.write(DEFAULT_UNUSED_IP_ADDR[3]);
        b.write(0);
        b.write(0);
    }

    public void addEntryTo(ByteArrayOutputStream b) {
        b.write(this.iUdpAddress[0]);
        b.write(this.iUdpAddress[1]);
        b.write(this.iUdpAddress[2]);
        b.write(this.iUdpAddress[3]);
        b.write((this.iUdpPort & 0xFF00) >> 8 & 0xFF);
        b.write((this.iUdpPort & 0xFF) >> 0 & 0xFF);
    }

    private void parseUdpIpAddress(byte[] packetData) {
        this.iUdpAddress = new int[4];
        int i = 20;
        int j = 0;
        while (i <= 23) {
            this.iUdpAddress[j] = packetData[i] & 0xFF;
            ++i;
            ++j;
        }
    }

    private void parseUdpPort(byte[] packetData) {
        this.iUdpPort = (packetData[24] & 0xFF) << 8 | (packetData[25] & 0xFF) << 0;
    }

    private void parseCcnAddress(byte[] packetData) {
        this.iCcnAddress = packetData[26] & 0xFF;
    }

    public static int getDeviceType(byte[] packetData) {
        return packetData[27] & 0xFF;
    }

    private void parseDeviceType(byte[] packetData) {
        this.iDeviceType = UDPRoutingTableEntry.getDeviceType(packetData);
    }

    private void parseAction(byte[] packetData) {
        this.iAction = packetData[28] & 0xFF;
    }

    public int hashCode() {
        return this.iCcnAddress;
    }

    public boolean equals(Object o) {
        if (o instanceof UDPRoutingTableEntry) {
            UDPRoutingTableEntry rte = (UDPRoutingTableEntry)o;
            if (rte.iCcnAddress == this.iCcnAddress && rte.iUdpPort == this.iUdpPort) {
                for (int i = 0; i < 4; ++i) {
                    if (this.iUdpAddress[i] == rte.iUdpAddress[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

