/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.UDPRoutingTableEntry;
import java.io.ByteArrayOutputStream;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.log.Log;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Clock;

class CcnUdpRoutingTable
extends IntHashMap {
    private volatile boolean updatedButNotTransmitted = false;
    public static final String ROUTING_TABLE_NAME = "ROUTETAB";
    private static final int FIFTEEN_MINUTES = 900000;
    Log tunnelLog = Log.getLog((String)"CCNTunnelLog");

    public CcnUdpRoutingTable(BCcnNetwork ccnNetwork) {
        super(12);
    }

    public synchronized boolean isUpdatedButNotTransmitted() {
        return this.updatedButNotTransmitted;
    }

    public synchronized void resetUpdatedButNotTransmitted() {
        this.updatedButNotTransmitted = false;
    }

    public synchronized void purgeStaleEntries() {
        UDPRoutingTableEntry rte = null;
        IntHashMap.Iterator e = super.iterator();
        while (e.hasNext()) {
            rte = (UDPRoutingTableEntry)e.next();
            if (rte.iDeviceType == 3 || Clock.ticks() - rte.iLastUpdateTicks <= 900000L) continue;
            this.tunnelLog.trace("Removing stale entry, " + rte + ". It has been " + (Clock.ticks() - rte.iLastUpdateTicks) + " ms since its last update.");
            this.removeEntry(rte);
        }
    }

    private synchronized void removeEntry(UDPRoutingTableEntry rte) {
        super.remove(rte.hashCode());
        this.generateAlarm(false, rte.toString());
        this.updatedButNotTransmitted = true;
        ((Object)((Object)this)).notifyAll();
    }

    private synchronized void addEntry(UDPRoutingTableEntry rte) {
        super.put(rte.hashCode(), (Object)rte);
        this.generateAlarm(true, rte.toString());
        this.updatedButNotTransmitted = true;
        ((Object)((Object)this)).notifyAll();
    }

    private void generateAlarm(boolean userLoggedOn, String clientInfo) {
        BAlarmState fromState = userLoggedOn ? BAlarmState.normal : BAlarmState.offnormal;
        BAlarmState toState = userLoggedOn ? BAlarmState.offnormal : BAlarmState.normal;
        String alarmText = "Tunnel Client (" + clientInfo + ") Logged " + (userLoggedOn ? "into" : "out of") + " Routing Table.";
    }

    public synchronized void giveEntry(UDPRoutingTableEntry rte) {
        if (rte.isActionAdd() || rte.isActionChange()) {
            this.addEntry(rte);
        } else if (rte.isActionDelete()) {
            this.removeEntry(rte);
        }
    }

    private byte[] getCcnRoutingTableUdpPacketData(int udpPacketIdentifier, int ccnElementAddr) {
        ByteArrayOutputStream rtUdpPacketHelper = new ByteArrayOutputStream();
        this.addRoutingTableHeaderToPacket(rtUdpPacketHelper, udpPacketIdentifier, ccnElementAddr);
        this.addTableNameToPacket(rtUdpPacketHelper);
        this.addRoutingTableToPacket(rtUdpPacketHelper);
        return rtUdpPacketHelper.toByteArray();
    }

    private void addRoutingTableHeaderToPacket(ByteArrayOutputStream out, int udpPacketIdentifier, int ccnElementAddr) {
        out.write(udpPacketIdentifier);
        out.write(241);
        out.write(0);
        out.write(ccnElementAddr);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(12);
        out.write(0);
        out.write(0);
        out.write(255);
    }

    private void addRoutingTableToPacket(ByteArrayOutputStream out) {
        byte[] routingTable = this.getCcnRoutingTable();
        out.write(routingTable, 0, routingTable.length);
    }

    private void addTableNameToPacket(ByteArrayOutputStream out) {
        byte[] tableNameBytes = ROUTING_TABLE_NAME.getBytes();
        out.write(tableNameBytes, 0, tableNameBytes.length);
    }

    public void sendToAll(CcnTunnelBack lTunnelBack, int udpPacketId, int ccnElementAddr) {
        UDPRoutingTableEntry rte = null;
        byte[] routingTableData = this.getCcnRoutingTableUdpPacketData(udpPacketId, ccnElementAddr);
        IntHashMap.Iterator e = super.iterator();
        while (e.hasNext()) {
            rte = (UDPRoutingTableEntry)e.next();
            if (rte.iCcnAddress == ccnElementAddr) continue;
            try {
                lTunnelBack.putQueue(new DatagramPacket(routingTableData, routingTableData.length, rte.getInetAddress(), rte.iUdpPort));
            }
            catch (UnknownHostException uhe) {
                this.tunnelLog.trace("Unable to send routing table to element " + rte.iCcnAddress + "(unknown I.P. host)");
                System.out.println(uhe);
            }
        }
    }

    public byte[] getCcnRoutingTable() {
        ByteArrayOutputStream blocks3Through8 = new ByteArrayOutputStream();
        ByteArrayOutputStream block9 = new ByteArrayOutputStream();
        block9.write(0);
        for (int i = 1; i <= 239; ++i) {
            UDPRoutingTableEntry rte = (UDPRoutingTableEntry)this.get(i);
            if (rte == null) {
                UDPRoutingTableEntry.addBlankEntryTo(blocks3Through8);
                block9.write(0);
                continue;
            }
            rte.addEntryTo(blocks3Through8);
            block9.write(rte.iDeviceType);
        }
        UDPRoutingTableEntry.addBlankEntryTo(blocks3Through8);
        ByteArrayOutputStream entireTable = new ByteArrayOutputStream();
        entireTable.write(blocks3Through8.toByteArray(), 0, blocks3Through8.size());
        entireTable.write(block9.toByteArray(), 0, block9.size());
        return entireTable.toByteArray();
    }
}

