/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oauth2.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.tridium.oauth2.OAuth2AuthorizationException;
import com.tridium.oauth2.OAuth2AuthorizationRequest;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class OAuth2JWTBearerGrantRequest
extends OAuth2AuthorizationRequest {
    private final X509Certificate clientCertificate;
    private final PrivateKey clientCertificatePrivateKey;

    public OAuth2JWTBearerGrantRequest(OAuth2AuthorizationServerMetadata authServerMetadata, String clientId, X509Certificate clientCertificate, PrivateKey clientCertificatePrivateKey, String[] scope) {
        super(authServerMetadata, clientId, scope);
        if (clientCertificate == null || clientCertificatePrivateKey == null) {
            throw new IllegalArgumentException("Client Certificate and Private Key must not be null");
        }
        this.clientCertificate = clientCertificate;
        this.clientCertificatePrivateKey = clientCertificatePrivateKey;
    }

    @Override
    protected HTTPRequest toHTTPRequest() {
        HashMap<String, Object> otherClaims = new HashMap<String, Object>();
        otherClaims.put("scope", this.scope != null ? String.join((CharSequence)" ", this.scope) : null);
        JWTAssertionDetails claimSet = new JWTAssertionDetails(new Issuer(this.clientId), new Subject(this.clientId), Collections.singletonList(new Audience(this.authServerMetadata.getTokenEndpoint())), new Date(new Date().getTime() + 300000L), null, new Date(), new JWTID(), otherClaims);
        SignedJWT jwtSecuredAuthorizationRequest = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).build(), claimSet.toJWTClaimsSet());
        try {
            jwtSecuredAuthorizationRequest.sign(new RSASSASigner(this.clientCertificatePrivateKey));
        }
        catch (JOSEException e) {
            throw new OAuth2AuthorizationException("An error occurred while signing JWS!");
        }
        TokenRequest tokenRequest = new TokenRequest(this.authServerMetadata.getTokenEndpoint(), new JWTBearerGrant(jwtSecuredAuthorizationRequest));
        return tokenRequest.toHTTPRequest();
    }
}

