/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.oauth2;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.tridium.json.JSONObject;
import com.tridium.oauth2.OAuth2AuthorizationException;
import com.tridium.oauth2.OAuth2AuthorizationResponse;
import com.tridium.oauth2.OAuth2AuthorizationServerMetadata;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OAuth2AuthorizationRequest {
    private static final Logger logger = Logger.getLogger("oauth2");
    protected final OAuth2AuthorizationServerMetadata authServerMetadata;
    protected final String clientId;
    protected final String[] scope;

    protected OAuth2AuthorizationRequest(OAuth2AuthorizationServerMetadata authServerMetadata, String clientId, String[] scope) {
        if (authServerMetadata == null) {
            throw new IllegalArgumentException("Authorization Server Metadata must not be null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new IllegalArgumentException("ClientId must not be null or empty");
        }
        if (scope != null && scope.length > 0 && Arrays.stream(scope).anyMatch(s -> s == null || "".equals(s))) {
            throw new IllegalArgumentException("Scope must not contain null or empty strings");
        }
        this.authServerMetadata = authServerMetadata;
        this.clientId = clientId;
        this.scope = scope != null && scope.length == 0 ? null : scope;
    }

    public OAuth2AuthorizationResponse send() throws OAuth2AuthorizationException {
        OAuth2AuthorizationResponse authResponse;
        try {
            HTTPResponse httpResponse;
            TokenResponse tokenResponse;
            HTTPRequest tokenRequest = this.toHTTPRequest();
            if (!this.authServerMetadata.getTokenEndpoint().equals(tokenRequest.getURI())) {
                throw new OAuth2AuthorizationException("Illegal Token Endpoint URL - Token Endpoint must match the URL specified in the Authorization Server Metadata.");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Token request query: " + tokenRequest.getQuery());
            }
            if (!(tokenResponse = TokenResponse.parse(httpResponse = tokenRequest.send())).indicatesSuccess()) {
                ErrorObject error = tokenResponse.toErrorResponse().getErrorObject();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Response from the Authorization Server indicates an error occurred (Error: %s, Error Description: %s)", error != null ? error.getCode() : Integer.valueOf(httpResponse.getStatusCode()), error != null ? error.getDescription() : httpResponse.getStatusMessage()));
                }
                authResponse = new OAuth2AuthorizationResponse(OAuth2AuthorizationResponse.Result.FAIL, error != null ? new JSONObject(error.toJSONObject().toString()) : new JSONObject());
            } else {
                AccessTokenResponse accessTokenResponse = tokenResponse.toSuccessResponse();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("Token response received with the following attributes: %s", accessTokenResponse.toJSONObject().keySet()));
                }
                authResponse = new OAuth2AuthorizationResponse(OAuth2AuthorizationResponse.Result.SUCCESS, new JSONObject(accessTokenResponse.toJSONObject().toString()));
            }
        }
        catch (ParseException | IOException | IllegalStateException e) {
            throw new OAuth2AuthorizationException("An exception occurred while performing authorization", e);
        }
        return authResponse;
    }

    protected abstract HTTPRequest toHTTPRequest();

    public OAuth2AuthorizationServerMetadata getAuthServerMetadata() {
        return this.authServerMetadata;
    }

    public String[] getRequestedScope() {
        return this.scope;
    }
}

