/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.points;

import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.integration.points.BVisitorPublishProxyExt;
import com.tridiumx.integration.service.BVisitorIntegrationService;
import com.tridiumx.integration.utils.IntegrationUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=11), @NiagaraProperty(name="publishPoint", type="BOrd", defaultValue="BOrd.NULL")})
public class BVisitorSubscribeProxyExt
extends BAbstractProxyExt {
    public static final Property enabled = BVisitorSubscribeProxyExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BVisitorSubscribeProxyExt.newProperty((int)11, (BValue)BStatus.ok, null);
    public static final Property faultCause = BVisitorSubscribeProxyExt.newProperty((int)11, (String)"", null);
    public static final Property publishPoint = BVisitorSubscribeProxyExt.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BVisitorSubscribeProxyExt.class);
    private static Logger LOGGER = IntegrationUtils.LOGGER;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BOrd getPublishPoint() {
        return (BOrd)this.get(publishPoint);
    }

    public void setPublishPoint(BOrd v) {
        this.set(publishPoint, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue out, Context cx) {
        if (!IntegrationUtils.isLicensed()) {
            return;
        }
        if (!BEnterpriseSecurityService.isWorkstation()) {
            LOGGER.log(Level.WARNING, "Visitor Integration Service starts on supervisor only.");
            return;
        }
        if (!((BVisitorIntegrationService)Sys.getService((Type)BVisitorIntegrationService.TYPE)).getEnabled()) {
            LOGGER.log(Level.WARNING, "Incoming requests but service is disabled.");
            return;
        }
        super.onExecute(out, cx);
        if (this.getEnabled()) {
            BControlPoint parentPoint = this.getParentPoint();
            if (parentPoint instanceof BStringWritable) {
                if (!this.getPublishPoint().isNull()) {
                    BObject publishPoint = this.getPublishPoint().get();
                    if (publishPoint instanceof BStringPoint) {
                        String mqttInSlotValue = out.getValueValue().toString();
                        JSONObject mqttJson = this.convertToJson(mqttInSlotValue);
                        if (mqttJson != null) {
                            JSONObject response = IntegrationUtils.initIntegration(mqttJson);
                            if (!response.isEmpty()) {
                                BVisitorPublishProxyExt proxyExt = (BVisitorPublishProxyExt)((BStringPoint)publishPoint).getProxyExt();
                                BStatusString statusString = new BStatusString(response.toString());
                                proxyExt.saveValue((BStatusValue)statusString);
                            }
                            this.updateStatusAndFaultCause("", BStatus.ok);
                        } else {
                            this.updateStatusAndFaultCause("Input to proxy extension is not a JSON.", BStatus.fault);
                        }
                    } else {
                        this.updateStatusAndFaultCause("Publish Point type should be a StringPoint.", BStatus.fault);
                    }
                } else {
                    this.updateStatusAndFaultCause("Publish Point should have a Non-Null Ord.", BStatus.fault);
                }
            } else {
                this.updateStatusAndFaultCause("Parent Point type has to be a StringWritable.", BStatus.fault);
            }
        }
    }

    private void updateStatusAndFaultCause(String faultCause, BStatus status) {
        this.setFaultCause(faultCause);
        this.setStatus(status);
        if (!faultCause.isEmpty()) {
            LOGGER.log(Level.WARNING, faultCause);
        }
    }

    private JSONObject convertToJson(String jsonStr) {
        try {
            return new JSONObject(jsonStr);
        }
        catch (JSONException ex) {
            return null;
        }
    }
}

