/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.model;

import com.tridiumx.integration.model.BVisitorEnum;
import com.tridiumx.integration.model.BVisitorTable;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="visitorType", type="BVisitorEnum", defaultValue="BVisitorEnum.DEFAULT"), @NiagaraProperty(name="accessRights", type="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT"), @NiagaraProperty(name="wiegandFormat", type="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT"), @NiagaraProperty(name="facilityCode", type="BInteger", defaultValue="BInteger.DEFAULT")})
public class BVisitorInput
extends BComponent {
    public static final Property visitorType = BVisitorInput.newProperty((int)0, (BValue)BVisitorEnum.DEFAULT, null);
    public static final Property accessRights = BVisitorInput.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property wiegandFormat = BVisitorInput.newProperty((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Property facilityCode = BVisitorInput.newProperty((int)0, (int)((BInteger)BInteger.DEFAULT.as(BInteger.class)).getInt(), null);
    public static final Type TYPE = Sys.loadType(BVisitorInput.class);

    public BVisitorEnum getVisitorType() {
        return (BVisitorEnum)this.get(visitorType);
    }

    public void setVisitorType(BVisitorEnum v) {
        this.set(visitorType, (BValue)v, null);
    }

    public BDynamicEnum getAccessRights() {
        return (BDynamicEnum)this.get(accessRights);
    }

    public void setAccessRights(BDynamicEnum v) {
        this.set(accessRights, (BValue)v, null);
    }

    public BDynamicEnum getWiegandFormat() {
        return (BDynamicEnum)this.get(wiegandFormat);
    }

    public void setWiegandFormat(BDynamicEnum v) {
        this.set(wiegandFormat, (BValue)v, null);
    }

    public int getFacilityCode() {
        return this.getInt(facilityCode);
    }

    public void setFacilityCode(int v) {
        this.setInt(facilityCode, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLoad(BVisitorTable visitorTable) {
        try {
            this.doLoadAccessRights(visitorTable.getAccessRights());
            this.doLoadWiegandFormat(visitorTable.getWiegandFormat());
        }
        catch (Exception e) {
            visitorTable.remove(this.getName());
        }
    }

    public void doLoadAccessRights(BDynamicEnum accessRightsFE) throws Exception {
        int newActiveOrdinal;
        String currentActiveTag;
        BEnumRange newRange = accessRightsFE.getRange();
        if (newRange.isTag(currentActiveTag = this.getAccessRights().getTag())) {
            newActiveOrdinal = newRange.tagToOrdinal(currentActiveTag);
        } else if (this.getAccessRights().equals((Object)BDynamicEnum.DEFAULT)) {
            newActiveOrdinal = 0;
        } else {
            throw new Exception();
        }
        this.setAccessRights(BDynamicEnum.make((int)newActiveOrdinal, (BEnumRange)newRange));
    }

    public void doLoadWiegandFormat(BDynamicEnum wiegandFormatFE) throws Exception {
        int newActiveOrdinal;
        String currentActiveTag;
        BEnumRange newRange = wiegandFormatFE.getRange();
        if (newRange.isTag(currentActiveTag = this.getWiegandFormat().getTag())) {
            newActiveOrdinal = newRange.tagToOrdinal(currentActiveTag);
        } else if (this.getWiegandFormat().equals((Object)BDynamicEnum.DEFAULT)) {
            newActiveOrdinal = 0;
        } else {
            throw new Exception();
        }
        this.setWiegandFormat(BDynamicEnum.make((int)newActiveOrdinal, (BEnumRange)newRange));
    }

    public void validateAndLoad(BVisitorTable visitorTable) throws Exception {
        if (visitorTable != null) {
            visitorTable.checkAccessRightAndWeigandFormat();
            this.doLoad(visitorTable);
        }
    }
}

