/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.model;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BDynamicEnumFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridiumx.integration.model.BVisitorEnum;
import com.tridiumx.integration.model.BVisitorInput;
import com.tridiumx.integration.model.BVisitorTable;
import com.tridiumx.integration.model.BVisitorTableFE;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="wiegandFormatModified")})
public class BVisitorDialog
extends BDialog {
    public static final Action okButtonPressed = BVisitorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BVisitorDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action wiegandFormatModified = BVisitorDialog.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BVisitorDialog.class);
    private String title;
    private BGridPane inputPane;
    private BDynamicEnum maxFacilityCode;
    private BVisitorInput row;
    private BVisitorInput newRow;
    private static final Lexicon lex = Lexicon.make(BVisitorDialog.class);
    public static final String TITLE_EDIT = lex.get("visitorDialog.title.edit");
    public static final String TITLE_NEW = lex.get("visitorDialog.title.new");
    private BButton okButton;
    private BButton cancelButton;
    private static int MAX_DIALOG_WIDTH = 750;
    private static final int MAX_DIALOG_HEIGHT = 750;
    private BWbFieldEditor visitorTypeEditor;
    private BWbFieldEditor accessRightsEditor;
    private BWbFieldEditor wiegandFormatEditor;
    private BWbFieldEditor facilityCodeEditor;
    private BComponentTable visitorInputTable;

    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void wiegandFormatModified() {
        this.invoke(wiegandFormatModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BVisitorDialog(BComponentTable table, BVisitorTable visitorTable) throws Exception {
        super((BWidget)table, TITLE_NEW, true);
        BVisitorInput visitorInput = new BVisitorInput();
        visitorInput.validateAndLoad(visitorTable);
        this.title = TITLE_NEW;
        this.prepDialog(table, visitorTable, visitorInput);
    }

    public BVisitorDialog(BComponentTable table, BVisitorTable visitorTable, BVisitorInput input) {
        super((BWidget)table, TITLE_EDIT, true);
        this.title = TITLE_EDIT;
        this.prepDialog(table, visitorTable, input);
    }

    private void prepDialog(BComponentTable table, BVisitorTable visitorTable, BVisitorInput visitorInput) {
        this.row = visitorInput;
        this.visitorInputTable = table;
        this.maxFacilityCode = visitorTable.getMaxFacilityCode();
        this.inputPane = new BGridPane(2);
        this.setContent(this.buildDialog());
        this.setBoundsCenteredOnOwner();
        this.repaint();
    }

    private BWidget buildDialog() {
        this.makeInputPane();
        BScrollPane inputScrollPane = new BScrollPane((BWidget)this.inputPane);
        BTabbedPane tabbedPane = new BTabbedPane();
        tabbedPane.addPane("Properties", (BWidget)new BBorderPane((BWidget)inputScrollPane, BBorder.inset, BInsets.make((double)0.0, (double)5.0, (double)5.0, (double)5.0)));
        tabbedPane.setShowSingleTab(false);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)tabbedPane);
        BScrollPane scrollPane = new BScrollPane((BWidget)pane);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)new BBorderPane((BWidget)scrollPane));
        BGridPane actions = this.getActionPane();
        content.setBottom((BWidget)new BBorderPane((BWidget)actions, 0.0, 10.0, 10.0, 10.0));
        return content;
    }

    private BGridPane getActionPane() {
        BGridPane actions = new BGridPane();
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        this.okButton = new BButton("Ok");
        actions.add(null, (BValue)this.okButton);
        this.cancelButton = new BButton("Cancel");
        actions.add(null, (BValue)this.cancelButton);
        this.linkTo("linkOkButton", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkCancelButton", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return actions;
    }

    private void makeInputPane() {
        this.addVisitorTypeRow();
        this.addAccessRightsRow();
        this.addWiegandFormatRow();
        this.addFacilityCodeRow();
    }

    private void addVisitorTypeRow() {
        this.visitorTypeEditor = BFrozenEnumFE.makeFor((BObject)this.row.getVisitorType());
        this.visitorTypeEditor.loadValue((BObject)this.row.getVisitorType());
        LabelUtil.addLabelWidgetPair((BPane)this.inputPane, (String)"Visitor Type", (BWidget)this.visitorTypeEditor);
    }

    private void addAccessRightsRow() {
        this.accessRightsEditor = BDynamicEnumFE.makeFor((BObject)this.row.getAccessRights());
        this.accessRightsEditor.loadValue((BObject)this.row.getAccessRights());
        LabelUtil.addLabelWidgetPair((BPane)this.inputPane, (String)"Access Rights", (BWidget)this.accessRightsEditor);
    }

    private void addWiegandFormatRow() {
        this.wiegandFormatEditor = BDynamicEnumFE.makeFor((BObject)this.row.getWiegandFormat());
        this.wiegandFormatEditor.loadValue((BObject)this.row.getWiegandFormat());
        this.linkTo("wiegandFormatMod", (BComponent)this.wiegandFormatEditor, (Slot)BDynamicEnumFE.setModified, (Slot)wiegandFormatModified);
        LabelUtil.addLabelWidgetPair((BPane)this.inputPane, (String)"Wiegand Format", (BWidget)this.wiegandFormatEditor);
    }

    private void addFacilityCodeRow() {
        this.facilityCodeEditor = BIntegerFE.makeFor((BObject)BInteger.make((int)this.row.getFacilityCode()));
        int wiegandFormatOrdinal = ((BDynamicEnum)this.wiegandFormatEditor.getCurrentValue()).getOrdinal();
        String maxFacilityCodeTag = SlotPath.unescape((String)this.maxFacilityCode.getRange().getTag(wiegandFormatOrdinal)).split(" FC:")[1];
        BFacets facets = BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.parseInt(maxFacilityCodeTag)));
        this.facilityCodeEditor.loadValue((BObject)BInteger.make((int)this.row.getFacilityCode()), (Context)new BasicContext((Context)facets));
        LabelUtil.addLabelWidgetPair((BPane)this.inputPane, (String)"Facility Code", (BWidget)this.facilityCodeEditor);
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double pw = this.getPreferredWidth() + 20.0;
        double ph = this.getPreferredHeight() + 20.0;
        IRectGeom screen = UiEnv.get().getScreenBounds((BWidget)this);
        double sw = screen.width() - 50.0;
        double sh = screen.height() - 50.0;
        if (pw > sw) {
            pw = sw;
        }
        if (ph > sh) {
            ph = sh;
        }
        if (pw > (double)MAX_DIALOG_WIDTH) {
            pw = MAX_DIALOG_WIDTH;
        }
        if (ph > 750.0) {
            ph = 750.0;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doOkButtonPressed(BWidgetEvent event) {
        try {
            if (this.title.equals(TITLE_EDIT)) {
                this.editRow();
            } else if (this.title.equals(TITLE_NEW)) {
                this.addNewRow();
            }
        }
        catch (Exception e) {
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.close();
        }
    }

    private void editRow() throws Exception {
        this.getRowModel();
        BVisitorTableFE.Model model = (BVisitorTableFE.Model)this.visitorInputTable.getModel();
        model.editRow(this.row, this.newRow);
    }

    private void addNewRow() throws Exception {
        this.getRowModel();
        BVisitorTableFE.Model model = (BVisitorTableFE.Model)this.visitorInputTable.getModel();
        model.newRow(this.newRow);
    }

    private void getRowModel() throws Exception {
        this.newRow = new BVisitorInput();
        this.newRow.setVisitorType((BVisitorEnum)this.visitorTypeEditor.saveValue());
        this.newRow.setAccessRights((BDynamicEnum)this.accessRightsEditor.saveValue());
        this.newRow.setWiegandFormat((BDynamicEnum)this.wiegandFormatEditor.saveValue());
        this.newRow.setFacilityCode(((BInteger)this.facilityCodeEditor.saveValue()).getInt());
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doWiegandFormatModified() throws Exception {
        this.wiegandFormatEditor.saveValue();
        int wiegandFormatOrdinal = ((BDynamicEnum)this.wiegandFormatEditor.getCurrentValue()).getOrdinal();
        String maxFacilityCodeTag = SlotPath.unescape((String)this.maxFacilityCode.getRange().getTag(wiegandFormatOrdinal)).split(" FC:")[1];
        BFacets facets = BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.parseInt(maxFacilityCodeTag)));
        this.facilityCodeEditor.loadValue((BObject)BInteger.DEFAULT, (Context)new BasicContext((Context)facets));
    }
}

