/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth;

import com.tridium.clientCertAuth.BClientCertAuthScheme;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperty(name="certificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", facets={@Facet(value="BFacets.make(\"warningText\", \"%lexicon(clientCertAuth:CertificateEditor.warningText)%\")")})
public class BClientCertAuthenticator
extends BAbstractAuthenticator {
    @Generated
    public static final Property certificate = BClientCertAuthenticator.newProperty((int)0, (BValue)BX509Certificate.DEFAULT, (BFacets)BFacets.make((String)"warningText", (String)"%lexicon(clientCertAuth:CertificateEditor.warningText)%"));
    @Generated
    public static final Type TYPE = Sys.loadType(BClientCertAuthenticator.class);

    @Generated
    public BX509Certificate getCertificate() {
        return (BX509Certificate)this.get(certificate);
    }

    @Generated
    public void setCertificate(BX509Certificate v) {
        this.set(certificate, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void validate(X509Certificate certificate) throws CertificateException {
        X509Certificate userCert = this.getCertificate().getX509Certificate();
        if (userCert == null || !userCert.equals(certificate)) {
            throw new CertificateException("certificates don't match");
        }
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.getAuthenticationScheme().ifPresent(BClientCertAuthScheme::trustAnchorsUpdated);
        }
    }

    public void stopped() throws Exception {
        this.getAuthenticationScheme().ifPresent(BClientCertAuthScheme::trustAnchorsUpdated);
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (Sys.isStationStarted() && this.isRunning() && property == certificate) {
            this.getAuthenticationScheme().ifPresent(BClientCertAuthScheme::trustAnchorsUpdated);
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.getAuthenticationScheme().ifPresent(BClientCertAuthScheme::trustAnchorsUpdated);
    }

    private Optional<BClientCertAuthScheme> getAuthenticationScheme() {
        BAuthenticationScheme authScheme;
        BComplex parent = this.getParent();
        if (parent != null && parent.getType().is(BUser.TYPE) && (authScheme = ((BUser)parent).getAuthenticationScheme()) instanceof BClientCertAuthScheme) {
            return Optional.of((BClientCertAuthScheme)authScheme);
        }
        return Optional.empty();
    }
}

