/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.clientCertAuth;

import com.tridium.authn.BAuthenticationSchemeFolder;
import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.clientCertAuth.BClientCertAuthenticator;
import com.tridium.clientCertAuth.ClientCertLoginModule;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.TrustAnchorProvider;
import java.security.AccessController;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationScheme"})})
public final class BClientCertAuthScheme
extends BSSOAuthenticationScheme
implements TrustAnchorProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BClientCertAuthScheme.class);
    public static final int GET_CLIENT_CERTIFICATE = 0;
    public static final String SCHEME_NAME = "clientcert";
    private Configuration configuration = null;
    private String trustAnchorProviderId = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public synchronized Configuration getLoginConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(ClientCertLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
        }
        return this.configuration;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BClientCertAuthenticator();
    }

    public String getLoginRedirectURL() {
        return "/clientCertAuth/clientCertAuth";
    }

    public boolean supportsRemoteUsers() {
        return false;
    }

    public Set<TrustAnchor> getTrustAnchors() {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        Optional service = Sys.findService((Type)BUserService.TYPE);
        service.ifPresent(userService -> {
            for (BUser user : ((BUserService)userService).getUsers()) {
                X509Certificate certificate;
                if (!user.getAuthenticationScheme().equals((Object)this) || (certificate = ((BClientCertAuthenticator)user.getAuthenticator()).getCertificate().getX509Certificate()) == null) continue;
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
        });
        return trustAnchors;
    }

    protected void trustAnchorsUpdated() {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().trustAnchorsUpdated(this.trustAnchorProviderId);
            return null;
        });
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BAuthenticationSchemeFolder.TYPE);
    }

    public void started() throws Exception {
        super.started();
        AccessController.doPrivileged(() -> {
            this.trustAnchorProviderId = CoreCryptoManager.get().registerTrustAnchorProvider((TrustAnchorProvider)this);
            return null;
        });
    }

    public void stopped() throws Exception {
        AccessController.doPrivileged(() -> {
            CoreCryptoManager.get().unregisterTrustAnchorProvider(this.trustAnchorProviderId);
            return null;
        });
        super.stopped();
    }
}

