/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.proofOfConcept.tools;

import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=8), @NiagaraProperty(name="console", type="boolean", defaultValue="false"), @NiagaraProperty(name="inputAPrefix", type="BString", defaultValue="<- ", flags=4), @NiagaraProperty(name="inputBPrefix", type="BString", defaultValue="-> ", flags=4), @NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.make(\"jsonToolkit\", \"messageLog\"), BStringTrendRecord.TYPE.getTypeSpec(), BCapacity.makeByRecordCount(50))", flags=64)})
@NiagaraActions(value={@NiagaraAction(name="inputA", parameterType="BString", defaultValue="BString.DEFAULT", flags=2056), @NiagaraAction(name="inputB", parameterType="BString", defaultValue="BString.DEFAULT", flags=2056), @NiagaraAction(name="clear", flags=2048), @NiagaraAction(name="setup", flags=2052)})
public class BTwinnedMessageLogger
extends BComponent {
    @Generated
    public static final Property enabled = BTwinnedMessageLogger.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Property console = BTwinnedMessageLogger.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property inputAPrefix = BTwinnedMessageLogger.newProperty((int)4, (String)"<- ", null);
    @Generated
    public static final Property inputBPrefix = BTwinnedMessageLogger.newProperty((int)4, (String)"-> ", null);
    @Generated
    public static final Property historyConfig = BTwinnedMessageLogger.newProperty((int)64, (BValue)new BHistoryConfig(BHistoryId.make((String)"jsonToolkit", (String)"messageLog"), BStringTrendRecord.TYPE.getTypeSpec(), BCapacity.makeByRecordCount((int)50)), null);
    @Generated
    public static final Action inputA = BTwinnedMessageLogger.newAction((int)2056, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action inputB = BTwinnedMessageLogger.newAction((int)2056, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action clear = BTwinnedMessageLogger.newAction((int)2048, null);
    @Generated
    public static final Action setup = BTwinnedMessageLogger.newAction((int)2052, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTwinnedMessageLogger.class);
    private boolean stopping;
    private HistoryThread historyThread;
    private final TreeMap<Long, List<BString>> entryQueue = new TreeMap();
    private static final Logger log = BJsonSchemaService.childLogger(TYPE.getTypeName());

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getConsole() {
        return this.getBoolean(console);
    }

    @Generated
    public void setConsole(boolean v) {
        this.setBoolean(console, v, null);
    }

    @Generated
    public String getInputAPrefix() {
        return this.getString(inputAPrefix);
    }

    @Generated
    public void setInputAPrefix(String v) {
        this.setString(inputAPrefix, v, null);
    }

    @Generated
    public String getInputBPrefix() {
        return this.getString(inputBPrefix);
    }

    @Generated
    public void setInputBPrefix(String v) {
        this.setString(inputBPrefix, v, null);
    }

    @Generated
    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    @Generated
    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    @Generated
    public void inputA(BString parameter) {
        this.invoke(inputA, (BValue)parameter, null);
    }

    @Generated
    public void inputB(BString parameter) {
        this.invoke(inputB, (BValue)parameter, null);
    }

    @Generated
    public void clear() {
        this.invoke(clear, null, null);
    }

    @Generated
    public void setup() {
        this.invoke(setup, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doSetup() {
        BHistoryConfig config = this.getHistoryConfig();
        config.setTimeZone(BTimeZone.getLocal());
        try (HistoryDatabaseConnection conn = BTwinnedMessageLogger.getDb().getDbConnection(null);){
            if (conn.getHistory(this.getHistoryConfig().getId()) == null) {
                conn.createHistory(this.getHistoryConfig());
            } else {
                conn.reconfigureHistory(this.getHistoryConfig());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Setting up history", e);
        }
        log.info("The history is now created, added into the database");
        this.historyThread = new HistoryThread();
        this.historyThread.setName("tml-history");
        this.historyThread.start();
    }

    public void started() {
        if (!this.isRunning()) {
            return;
        }
        this.setup();
    }

    public void stopped() throws Exception {
        if (this.historyThread != null) {
            this.historyThread.interrupt();
        }
        this.stopping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClear() {
        try (HistoryDatabaseConnection conn = BTwinnedMessageLogger.getDb().getDbConnection(null);){
            BHistoryId mine = this.getHistoryConfig().getId();
            BIHistory h = conn.getHistory(mine);
            if (h != null) {
                conn.clearAllRecords(mine);
            }
            TreeMap<Long, List<BString>> treeMap = this.entryQueue;
            synchronized (treeMap) {
                this.entryQueue.clear();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Clearing history", e);
        }
    }

    public void doInputA(BString in) {
        this.enqueueEntry(BString.make((String)String.format("%s%s", this.getInputAPrefix(), in)));
    }

    public void doInputB(BString in) {
        this.enqueueEntry(BString.make((String)String.format("%s%s", this.getInputBPrefix(), in)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueEntry(BString input) {
        if (this.isRunning() && this.getEnabled()) {
            long time = System.currentTimeMillis();
            TreeMap<Long, List<BString>> treeMap = this.entryQueue;
            synchronized (treeMap) {
                if (this.entryQueue.containsKey(time)) {
                    this.entryQueue.get(time).add(input);
                } else {
                    ArrayList<BString> entries = new ArrayList<BString>();
                    entries.add(input);
                    this.entryQueue.put(time, entries);
                }
                this.entryQueue.notify();
            }
        }
        if (this.getConsole()) {
            log.info(input.getString());
        }
    }

    private static BHistoryDatabase getDb() {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        return service.getDatabase();
    }

    public BIcon getIcon() {
        return BIcon.std((String)"script.png");
    }

    class HistoryThread
    extends Thread {
        HistoryThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TreeMap treeMap = BTwinnedMessageLogger.this.entryQueue;
                synchronized (treeMap) {
                    try {
                        BTwinnedMessageLogger.this.entryQueue.wait(100L);
                        if (!BTwinnedMessageLogger.this.entryQueue.isEmpty()) {
                            long entryTime = (Long)BTwinnedMessageLogger.this.entryQueue.firstKey();
                            List entries = (List)BTwinnedMessageLogger.this.entryQueue.get(entryTime);
                            entries.forEach(entry -> this.historyLogIt(entryTime, entry.getString()));
                            BTwinnedMessageLogger.this.entryQueue.remove(entryTime);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!BTwinnedMessageLogger.this.stopping) {
                            log.severe(e.getMessage());
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }

        private void historyLogIt(long entryTime, String in) {
            if (!BTwinnedMessageLogger.this.getEnabled()) {
                return;
            }
            try (HistorySpaceConnection conn = BTwinnedMessageLogger.getDb().getConnection(null);){
                BIHistory history = conn.getHistory(BTwinnedMessageLogger.this.getHistoryConfig().getId());
                BStringTrendRecord newRecord = new BStringTrendRecord();
                newRecord.set(BAbsTime.make((long)entryTime), in, BStatus.ok);
                conn.append(history, (BIHistoryRecordSet)newRecord);
                log.info("Appended " + newRecord.toString());
            }
            catch (HistoryException he) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.SEVERE, "Connecting to history", he);
                }
                log.log(Level.SEVERE, he.getLocalizedMessage());
            }
        }
    }
}

