/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundSlotsContainer;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.array.BJsonSchemaArray;
import com.tridiumx.jsonToolkit.outbound.schema.array.BJsonSchemaBoundArray;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameCasing;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSource;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaNameSpacing;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.config.BSlotSelectionType;
import com.tridiumx.jsonToolkit.outbound.schema.object.BJsonSchemaBoundObject;
import com.tridiumx.jsonToolkit.outbound.schema.object.BJsonSchemaObject;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaBooleanProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaBoundCsvProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaBoundProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaCountProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaCurrentTimeProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaFacetList;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaFacetProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaNumericProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaStringProperty;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaTagList;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaTagProperty;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaBoundQueryResult;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaConfigException;
import com.tridiumx.jsonToolkit.util.BListOf;
import java.util.Arrays;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public class JsonSchemaBuilder {
    private static final String ROOT_NAME = "root";
    private BJsonSchemaMember currentMember;
    private BJsonSchemaMember currentParent;
    private final BJsonSchema schema;

    public JsonSchemaBuilder() {
        this(false);
    }

    private JsonSchemaBuilder(boolean relativeSchema) {
        this.schema = relativeSchema ? new BRelativeJsonSchema() : new BJsonSchema();
        this.currentMember = this.schema;
        this.currentParent = this.schema;
    }

    public static JsonSchemaBuilder relativeSchema() {
        return new JsonSchemaBuilder(true);
    }

    public JsonSchemaBuilder enabled(boolean enabled) {
        this.schema.setEnabled(enabled);
        return this;
    }

    public JsonSchemaBuilder withUpdateStrategy(BJsonSchemaUpdateStrategy updateStrategy) {
        this.schema.getConfig().getTuningPolicy().setUpdateStrategy(updateStrategy);
        return this;
    }

    public JsonSchemaBuilder withNamingStrategy(BJsonSchemaNameCasing casing, BJsonSchemaNameSpacing spacing) {
        this.schema.getConfig().setNameCasingRule(casing);
        this.schema.getConfig().setNameSpacingRule(spacing);
        return this;
    }

    public JsonSchemaBuilder withQueryInterval(BRelTime interval) {
        this.schema.getQueries().setQueryInterval(interval);
        return this;
    }

    public JsonSchemaBuilder withRootObject() {
        this.addChild(ROOT_NAME, new BJsonSchemaObject());
        this.stepDown();
        return this;
    }

    public JsonSchemaBuilder withRootArray() {
        this.addChild(ROOT_NAME, new BJsonSchemaArray());
        this.stepDown();
        return this;
    }

    public JsonSchemaBuilder withBoundObject(String name, BOrd bindTarget) {
        this.addBoundChild(name, new BJsonSchemaBoundObject(), bindTarget);
        return this;
    }

    public JsonSchemaBuilder withBoundProperty(String name, BOrd bindTarget) {
        this.addBoundChild(name, new BJsonSchemaBoundProperty(), bindTarget);
        return this;
    }

    public JsonSchemaBuilder withBoundArray(String name, BOrd bindTarget) {
        this.addBoundChild(name, new BJsonSchemaBoundArray(), bindTarget);
        return this;
    }

    public JsonSchemaBuilder withBoundCsvProperty(String name, BOrd bindTarget) {
        this.addBoundChild(name, new BJsonSchemaBoundCsvProperty(), bindTarget);
        return this;
    }

    public JsonSchemaBuilder withNameSource(BJsonSchemaNameSource nameSource) {
        if (this.currentMember instanceof BJsonSchemaBoundMember) {
            ((BJsonSchemaBoundMember)this.currentMember).setJsonNameSource(nameSource);
        }
        return this;
    }

    public JsonSchemaBuilder withSlotSelection(BSlotSelectionType type) {
        if (this.currentMember instanceof BJsonSchemaBoundSlotsContainer) {
            ((BJsonSchemaBoundSlotsContainer)this.currentMember).setSlotsToInclude(type);
        }
        return this;
    }

    public JsonSchemaBuilder withSlots(Property[] selectedSlots) {
        if (this.currentMember instanceof BJsonSchemaBoundSlotsContainer) {
            BJsonSchemaBoundSlotsContainer container = (BJsonSchemaBoundSlotsContainer)this.currentMember.as(BJsonSchemaBoundSlotsContainer.class);
            container.setSlotsToInclude(BSlotSelectionType.selectedSlots);
            BListOf list = new BListOf(BString.TYPE);
            Arrays.stream(selectedSlots).forEach(property -> list.add((BValue)BString.make((String)property.getName())));
            container.setSlotList(list);
        }
        return this;
    }

    public JsonSchemaBuilder withFixedObject(String name) {
        this.addChild(name, new BJsonSchemaObject());
        return this;
    }

    public JsonSchemaBuilder withFixedArray(String name) {
        this.addChild(name, new BJsonSchemaArray());
        return this;
    }

    public JsonSchemaBuilder withFixedStringProperty(String name, String value) {
        this.addChild(name, BJsonSchemaStringProperty.make(value));
        return this;
    }

    public JsonSchemaBuilder withFixedNumericProperty(String name, BNumber value) {
        this.addChild(name, BJsonSchemaNumericProperty.make(value));
        return this;
    }

    public JsonSchemaBuilder withFixedBooleanProperty(String name, Boolean value) {
        this.addChild(name, BJsonSchemaBooleanProperty.make(value));
        return this;
    }

    public JsonSchemaBuilder withQuery(String name, String queryString) {
        this.schema.getQueries().add(SlotPath.escape((String)name), (BValue)BJsonSchemaQuery.make(queryString));
        return this;
    }

    public JsonSchemaBuilder withBoundQueryResult(String name, String queryName, BTypeSpec styleType) {
        this.addChild(name, BJsonSchemaBoundQueryResult.make(queryName, styleType));
        return this;
    }

    public JsonSchemaBuilder withBaseQuery(String queryString, boolean publishOnStart) {
        return this.withBaseQuery(queryString, publishOnStart, BRelTime.makeHours((int)24));
    }

    public JsonSchemaBuilder withBaseQuery(String queryString, boolean publishOnStart, BRelTime publishInterval) {
        if (!this.schema.getType().is(BRelativeJsonSchema.TYPE)) {
            throw new JsonSchemaConfigException("Cannot add base queries to a schema unless it is a relative schema");
        }
        ((BRelativeJsonSchema)this.schema.as(BRelativeJsonSchema.class)).getBaseQuery().setBaseQuery(BOrd.make((String)queryString));
        ((BRelativeJsonSchema)this.schema.as(BRelativeJsonSchema.class)).getBaseQuery().setPublishInterval(publishInterval);
        this.schema.getConfig().getTuningPolicy().setWriteOnStart(publishOnStart);
        return this;
    }

    public JsonSchemaBuilder withCountProperty(String name) {
        this.addChild(name, new BJsonSchemaCountProperty());
        return this;
    }

    public JsonSchemaBuilder withCurrentTimeProperty(String name) {
        this.addChild(name, new BJsonSchemaCurrentTimeProperty());
        return this;
    }

    public JsonSchemaBuilder withFacetProperty(String name) {
        this.addChild(name, new BJsonSchemaFacetProperty());
        return this;
    }

    public JsonSchemaBuilder withTagProperty(String name) {
        this.addChild(name, new BJsonSchemaTagProperty());
        return this;
    }

    public JsonSchemaBuilder withFacetList(String name) {
        this.addChild(name, new BJsonSchemaFacetList());
        return this;
    }

    public JsonSchemaBuilder withTagList(String name) {
        this.addChild(name, new BJsonSchemaTagList());
        return this;
    }

    public JsonSchemaBuilder stepDown() {
        this.currentParent = this.currentMember;
        return this;
    }

    public JsonSchemaBuilder stepUp() {
        this.currentParent = this.currentParent instanceof BJsonSchema ? this.currentParent : (BJsonSchemaMember)this.currentParent.getParent();
        return this;
    }

    private void addBoundChild(String name, BJsonSchemaBoundMember member, BOrd bindTarget) {
        if (bindTarget == null) {
            throw new BajaRuntimeException(String.format("Cannot bind %s to null", name));
        }
        member.setBinding(bindTarget);
        this.addChild(name, member);
    }

    private void addChild(String name, BJsonSchemaMember member) {
        if (this.currentMember.getType().is(BJsonSchema.TYPE) && member.getType().is(BJsonSchemaProperty.TYPE)) {
            throw new BajaRuntimeException(String.format("Cannot nest type [%s] at the top level of a schema, properties must be inside arrays/objects", name));
        }
        this.currentParent.add(SlotPath.escape((String)name), (BValue)member);
        this.currentMember = member;
    }

    public BJsonSchema build() {
        return this.schema;
    }
}

