/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.relative;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SchemaBoundMemberSubscriber;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.Subscription;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.SubscriptionFactory;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.naming.OrdTarget;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Subscriber;

public class SubscriptionTable {
    private final Map<String, Set<BComplex>> baseMap = new HashMap<String, Set<BComplex>>();
    private final Map<String, SchemaBoundMemberSubscriber> subscribers = new HashMap<String, SchemaBoundMemberSubscriber>();
    private final BRelativeJsonSchema schema;
    private final Object mutex = new Object();

    SubscriptionTable(BRelativeJsonSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BJsonSchemaBoundMember member, OrdTarget ordTarget, BComplex base) {
        Object object = this.mutex;
        synchronized (object) {
            BValue target = (BValue)ordTarget.get();
            BComponent subscriptionTarget = SubscriptionFactory.getSubscriptionTarget(ordTarget, member);
            String slotPath = target.isSimple() ? JsonSchemaUtil.getSlotPath((BObject)subscriptionTarget) : JsonSchemaUtil.getSlotPath((BObject)target);
            boolean setupSubscription = !this.baseMap.containsKey(slotPath);
            this.baseMap.putIfAbsent(slotPath, new HashSet());
            this.baseMap.get(slotPath).add(base);
            if (setupSubscription) {
                String memberKey = member.getHandleOrd().toString(null);
                SchemaBoundMemberSubscriber subscriber = this.subscribers.computeIfAbsent(memberKey, k -> this.createSubscriber(member, ordTarget));
                subscriber.subscribeTo(subscriptionTarget);
            }
        }
    }

    private SchemaBoundMemberSubscriber createSubscriber(BJsonSchemaBoundMember member, OrdTarget ordTarget) {
        Subscription subscription = SubscriptionFactory.makeSubscription(member, ordTarget);
        return new SchemaBoundMemberSubscriber(member, subscription, event -> {
            if (event.getId() == 13 || event.getId() == 20) {
                this.unregisterAndUnsubscribe(event.getSourceComponent());
                return;
            }
            BValue liveBindingValue = subscription.getLiveBindingValue(member, event);
            if (liveBindingValue != null) {
                String componentSlotPath;
                String string = componentSlotPath = liveBindingValue.isSimple() ? JsonSchemaUtil.getSlotPath((BObject)event.getSourceComponent()) : JsonSchemaUtil.getSlotPath((BObject)liveBindingValue);
                if (this.baseMap.containsKey(componentSlotPath)) {
                    Set<BComplex> baseItems = this.baseMap.get(componentSlotPath);
                    baseItems.forEach(baseItem -> {
                        if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
                            BJsonSchemaService.log.fine(String.format("Json schema [%s] submitting base for generation [%s]", this.schema.getName(), baseItem));
                        }
                        this.schema.enqueueBase((BComplex)baseItem);
                    });
                } else {
                    BJsonSchemaService.log.warning(String.format("Json schema [%s] ComponentEvent received for item not in baseMap.", this.schema.getName()));
                    this.unregisterAndUnsubscribe(event.getSourceComponent());
                }
            } else if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
                BJsonSchemaService.log.fine(String.format("Json schema [%s] did not find live value for event [%s]", this.schema.getName(), event));
            }
        });
    }

    public void unsubscribe(BJsonSchemaBoundMember binding) {
        String memberKey = binding.getHandleOrd().toString(null);
        SchemaBoundMemberSubscriber subscriber = this.subscribers.get(memberKey);
        if (subscriber != null) {
            subscriber.unsubscribeAll();
            this.subscribers.remove(memberKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAndUnsubscribe(BComponent subscribedComponent) {
        String subscribedComponentPath = JsonSchemaUtil.getSlotPath((BObject)subscribedComponent);
        Object object = this.mutex;
        synchronized (object) {
            if (this.baseMap.containsKey(subscribedComponentPath)) {
                if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
                    BJsonSchemaService.log.info(String.format("Json Schema [%s] Removing from subscription baseMap: [%s]", this.schema.getName(), subscribedComponentPath));
                }
                this.baseMap.remove(subscribedComponentPath);
            }
            this.subscribers.values().forEach(subscriber -> {
                block2: {
                    try {
                        subscriber.unsubscribe(subscribedComponent);
                    }
                    catch (Exception e) {
                        if (!BJsonSchemaService.log.isLoggable(Level.FINEST)) break block2;
                        BJsonSchemaService.log.log(Level.FINEST, String.format("Json Schema [%s] Could not remove child from baseMap: [%s]", this.schema.getName(), subscribedComponent), e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAndUnsubscribeAll() {
        Object object = this.mutex;
        synchronized (object) {
            this.baseMap.clear();
            this.subscribers.values().forEach(Subscriber::unsubscribeAll);
            this.subscribers.clear();
        }
        BJsonSchemaService.log.info(String.format("Json Schema [%s] subscription table cleared", this.schema.getName()));
    }

    void toSpy(SpyWriter out) {
        out.write("<b>" + SubscriptionTable.class.getName() + "</b>");
        out.startTable(true).thTitle((Object)"Child Item").thTitle((Object)"Base Items resolved against");
        int baseCount = 0;
        for (Map.Entry<String, Set<BComplex>> entry : this.baseMap.entrySet()) {
            out.write("<tr>");
            out.td((Object)JsonSchemaUtil.getSlotPath(entry.getKey()));
            if (entry.getValue().size() > 1) {
                out.td((Object)(entry.getValue().size() + " items"));
            } else {
                out.td((Object)JsonSchemaUtil.getSlotPath((BObject)entry.getValue().iterator().next()));
            }
            out.write("</tr>");
            baseCount += entry.getValue().size();
        }
        out.tr((Object)"Count:", (Object)this.baseMap.size());
        out.tr((Object)"Base Item Count:", (Object)baseCount);
        out.endTable();
    }
}

