/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.relative;

import com.tridium.util.PrefixLogUtil;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaTuningPolicy;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailException;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BBaseAndOutputPair;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BBaseQuery;
import com.tridiumx.jsonToolkit.outbound.schema.relative.SubscriptionTable;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="baseQuery", type="BBaseQuery", defaultValue="new BBaseQuery()")
@NiagaraActions(value={@NiagaraAction(name="forceGenerateJson", flags=20, override=true), @NiagaraAction(name="unregisterAndUnsubscribeAll", flags=16), @NiagaraAction(name="enqueueBase", parameterType="BComponent", defaultValue="new BComponent()", flags=2052)})
@NiagaraTopics(value={@NiagaraTopic(name="currentBase", eventType="BValue"), @NiagaraTopic(name="currentBaseAndOutput", eventType="BBaseAndOutputPair")})
public class BRelativeJsonSchema
extends BJsonSchema {
    @Generated
    public static final Property baseQuery = BRelativeJsonSchema.newProperty((int)0, (BValue)new BBaseQuery(), null);
    @Generated
    public static final Action forceGenerateJson = BRelativeJsonSchema.newAction((int)20, null);
    @Generated
    public static final Action unregisterAndUnsubscribeAll = BRelativeJsonSchema.newAction((int)16, null);
    @Generated
    public static final Action enqueueBase = BRelativeJsonSchema.newAction((int)2052, (BValue)new BComponent(), null);
    @Generated
    public static final Topic currentBase = BRelativeJsonSchema.newTopic((int)0, null);
    @Generated
    public static final Topic currentBaseAndOutput = BRelativeJsonSchema.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRelativeJsonSchema.class);
    private final SubscriptionTable subscriptionTable = new SubscriptionTable(this);
    private final BlockingQueue<BComplex> baseItemQueue = new LinkedBlockingQueue<BComplex>();
    private final Object currentBaseMutex = new Object();
    private Thread dequeueThread;
    private BComplex currentBaseItem;
    private Clock.Ticket baseQueryExecuteTicket = Clock.expiredTicket;
    static final Logger logger = BJsonSchemaService.childLogger("relative");
    private static final BIcon RELATIVE_ICON = BIcon.make((String)"module://jsonToolkit/icons/bracesRelative.png");

    @Generated
    public BBaseQuery getBaseQuery() {
        return (BBaseQuery)this.get(baseQuery);
    }

    @Generated
    public void setBaseQuery(BBaseQuery v) {
        this.set(baseQuery, (BValue)v, null);
    }

    @Generated
    public void unregisterAndUnsubscribeAll() {
        this.invoke(unregisterAndUnsubscribeAll, null, null);
    }

    @Generated
    public void enqueueBase(BComponent parameter) {
        this.invoke(enqueueBase, (BValue)parameter, null);
    }

    @Generated
    public void fireCurrentBase(BValue event) {
        this.fire(currentBase, event, null);
    }

    @Generated
    public void fireCurrentBaseAndOutput(BBaseAndOutputPair event) {
        this.fire(currentBaseAndOutput, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doGenerateJson(Context context) {
        this.getBaseQuery().publish();
    }

    @Override
    public final void doForceGenerateJson(Context context) {
        this.cancelMinWritePublishTimer();
        this.doGenerateJson(context);
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled) && this.getEnabled() && this.getConfig().getTuningPolicy().getWriteOnEnabled()) {
            this.getBaseQuery().republish();
            return;
        }
        super.changed(property, context);
        if (property.equals(output) && logger.isLoggable(Level.FINEST)) {
            logger.finest("Relative schema output changed to: " + this.getOutput());
        } else if (property.getName().equals(BJsonSchemaTuningPolicy.updateStrategy.getName())) {
            this.subscriptionTable.unregisterAndUnsubscribeAll();
            this.resetBaseQueryTimer();
            if (this.getEnabled() && this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.cov) {
                this.getBaseQuery().republish();
            }
        } else if (property.getName().equals(BBaseQuery.publishInterval.getName())) {
            this.resetBaseQueryTimer();
        }
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child instanceof BBaseQuery || super.isChildLegal(child);
    }

    @Override
    public void started() {
        super.started();
        this.dequeueThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.processBase();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (!(t instanceof InterruptedException)) continue;
                    PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, (String)"Exiting relative schema processor thread", (Object)this);
                    return;
                }
                break;
            }
        });
        this.dequeueThread.setName(this.getName());
        this.dequeueThread.start();
        this.startBaseQueryTimer();
    }

    @Override
    protected boolean queryIntervalIsSet() {
        return this.getBaseQuery().getPublishInterval().getMillis() > 0L;
    }

    private void resetBaseQueryTimer() {
        this.cancelBaseQueryExecutionTimer();
        this.startBaseQueryTimer();
    }

    private void startBaseQueryTimer() {
        if (this.shouldRunQueries() && this.baseQueryExecuteTicket.isExpired()) {
            this.baseQueryExecuteTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getBaseQuery().getPublishInterval(), (Action)generateJson, null);
        }
    }

    private void cancelBaseQueryExecutionTimer() {
        if (!this.baseQueryExecuteTicket.isExpired()) {
            this.baseQueryExecuteTicket.cancel();
            this.baseQueryExecuteTicket = Clock.expiredTicket;
        }
    }

    public void doEnqueueBase(BComponent base) {
        if (!this.isRunning()) {
            return;
        }
        this.enqueueBase(base);
    }

    public void unregister(BJsonSchemaBoundMember binding) {
        this.subscriptionTable.unsubscribe(binding);
    }

    public void doUnregisterAndUnsubscribeAll() {
        this.subscriptionTable.unregisterAndUnsubscribeAll();
    }

    @Override
    public void stopped() {
        this.subscriptionTable.unregisterAndUnsubscribeAll();
        if (this.dequeueThread != null && this.dequeueThread.isAlive()) {
            this.dequeueThread.interrupt();
        }
    }

    @Override
    public OrdTarget getOrdTarget(BJsonSchemaBoundMember member, BObject overrideBase) {
        OrdTarget ordTarget = super.getOrdTarget(member, overrideBase);
        if (this.getConfig().getTuningPolicy().getUpdateStrategy() != BJsonSchemaUpdateStrategy.onDemandOnly) {
            this.subscriptionTable.register(member, ordTarget, this.currentBaseItem);
        }
        return ordTarget;
    }

    @Override
    public void doExecuteQueries(Context context) {
        this.subscriptionTable.unregisterAndUnsubscribeAll();
        this.getBaseQuery().publish();
    }

    @Override
    protected void processQueries(Context context, boolean runSynchronously) {
        if (this.currentBaseItem != null) {
            if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
                BJsonSchemaService.log.fine(String.format(this.getName() + " processQueries for base item %s", this.currentBaseItem.getName() + ' ' + this.currentBaseItem));
            }
            try {
                this.queryRunner.executeQueries(this.getBaseObject(), (Context)this.currentContext.get());
            }
            catch (QueryFailException e) {
                logger.severe(String.format("Query execution failed for relative schema %s: %s", this.getName(), e.getMessage()));
            }
        }
    }

    @Override
    protected boolean startQueryExecutionTimer(Context context) {
        return false;
    }

    public String getCurrentBasePath() {
        return JsonSchemaUtil.getSlotPath((BObject)this.currentBaseItem);
    }

    @Override
    public BComplex getBaseObject() {
        return this.currentBaseItem;
    }

    void enqueueBase(BComplex baseItem) {
        if (!this.baseItemQueue.contains(baseItem)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("Enqueuing Base Item: [%s] for schema [%s]", JsonSchemaUtil.getSlotPath((BObject)baseItem), this.getName()));
            }
            this.baseItemQueue.add(baseItem);
        } else if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
            BJsonSchemaService.log.fine(String.format("Not Enqueuing Duplicate Base Item: [%s] for schema [%s]", JsonSchemaUtil.getSlotPath((BObject)baseItem), this.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBase() throws InterruptedException {
        Object object = this.currentBaseMutex;
        synchronized (object) {
            try {
                this.currentBaseItem = this.baseItemQueue.take();
                this.fireCurrentBase((BValue)this.currentBaseItem);
                this.synchronousSchemaEvent(BSchemaEvent.relativeBaseItemChanged);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("processing base item %s", JsonSchemaUtil.getSlotPath((BObject)this.currentBaseItem)));
                }
                this.generateAndOutputJson(null);
                this.fireCurrentBaseAndOutput(new BBaseAndOutputPair(this.currentBaseItem, this.getOutput()));
            }
            finally {
                this.currentBaseItem = null;
            }
        }
    }

    @Override
    public boolean isRelative() {
        return true;
    }

    @Override
    protected void disableAll() {
        super.disableAll();
        this.unregisterAndUnsubscribeAll();
        this.cancelBaseQueryExecutionTimer();
    }

    @Override
    public BIcon getIcon() {
        return RELATIVE_ICON;
    }

    public void spy(SpyWriter out) throws Exception {
        this.subscriptionTable.toSpy(out);
        super.spy(out);
    }

    public long getQueueSize() {
        return this.baseItemQueue.size();
    }
}

