/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridium.util.PrefixLogUtil;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"jsonToolkit:SlotOrdFE\")")}), @NiagaraProperty(name="facetKey", type="String", defaultValue="units")})
public class BJsonSchemaFacetProperty
extends BJsonSchemaProperty<BObject> {
    @Generated
    public static final Property ord = BJsonSchemaFacetProperty.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")));
    @Generated
    public static final Property facetKey = BJsonSchemaFacetProperty.newProperty((int)0, (String)"units", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaFacetProperty.class);

    @Generated
    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    @Generated
    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    @Generated
    public String getFacetKey() {
        return this.getString(facetKey);
    }

    @Generated
    public void setFacetKey(String v) {
        this.setString(facetKey, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaFacetProperty make(BOrd ord, String facetKey) {
        BJsonSchemaFacetProperty facetProperty = new BJsonSchemaFacetProperty();
        facetProperty.setOrd(ord);
        facetProperty.setFacetKey(facetKey);
        return facetProperty;
    }

    private BObject lookupFacet(String facetKey, BValue target) {
        BFacets foundFacets = JsonSchemaUtil.getFacetsForTarget((BObject)target);
        if (foundFacets == null) {
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)String.format("Cannot fetch facets from object [%s]", target.toDebugString()), (Object)this);
        }
        try {
            if (foundFacets != null) {
                BObject facet = foundFacets.getFacet(facetKey);
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.FINE, (String)("Found facet " + facet), (Object)this);
                return facet;
            }
        }
        catch (Exception e) {
            if (BJsonSchemaService.log.isLoggable(Level.FINE)) {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)("Error reading facets from " + target.toDebugString()), (Throwable)e, (Object)this);
            }
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)("Error reading facets " + target.toDebugString()), (Object)this);
        }
        return BString.DEFAULT;
    }

    @Override
    public BObject getJsonValue() {
        BComplex base = this.getSchema().getBaseObject();
        if (this.getOrd() != null && !this.getOrd().isNull()) {
            try {
                BValue target = (BValue)this.getOrd().get((BObject)base);
                return this.lookupFacet(this.getFacetKey(), target);
            }
            catch (UnresolvedException ue) {
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)(this.getSchema() + ": base:" + base.getName() + ": cannot find child component with facets: " + this.getOrd()), (Throwable)ue, (Object)this);
            }
        } else {
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)String.format("Cannot function with null ord in [%s]", this.getName()), (Object)this);
        }
        return BString.DEFAULT;
    }
}

