/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridiumx.jsonToolkit.inbound.BJsonInbound;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import com.tridiumx.jsonToolkit.inbound.routing.slot.BAddSlotDetail;
import com.tridiumx.jsonToolkit.inbound.routing.slot.DynamicSlotUtil;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="learnMode", type="boolean", defaultValue="false")
@NiagaraAction(name="addSlot", parameterType="BAddSlotDetail", defaultValue="new BAddSlotDetail()")
public abstract class BJsonRouter
extends BJsonInbound
implements DynamicSlotUtil {
    @Generated
    public static final Property learnMode = BJsonRouter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action addSlot = BJsonRouter.newAction((int)0, (BValue)new BAddSlotDetail(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonRouter.class);
    public static int DEFAULT_ROUTER_SLOT_FLAGS = 9;

    @Generated
    public boolean getLearnMode() {
        return this.getBoolean(learnMode);
    }

    @Generated
    public void setLearnMode(boolean v) {
        this.setBoolean(learnMode, v, null);
    }

    @Generated
    public void addSlot(BAddSlotDetail parameter) {
        this.invoke(addSlot, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.resetDynamicProperties(this);
    }

    public void added(Property property, Context context) {
        this.readOnlySummaryOnAdd(this, property);
    }

    public void doAddSlot(BAddSlotDetail detail) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding " + detail.getSlotName() + ' ' + (Object)((Object)detail.getSlotType()));
        }
        this.add(SlotPath.escape((String)detail.getSlotName()), detail.getSlotType().getSlotDefaultValue(), DEFAULT_ROUTER_SLOT_FLAGS);
    }

    public void setNewValueOnSlot(String message, String slotName, BValue value) throws RoutingFailedException {
        try {
            this.set(slotName, value);
        }
        catch (NoSuchSlotException nsse) {
            if (this.getLearnMode()) {
                try {
                    this.add(slotName, value, DEFAULT_ROUTER_SLOT_FLAGS);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not create learnt slot " + slotName, e);
                }
            }
            throw new RoutingFailedException(message, "Could not find property " + slotName, nsse);
        }
    }

    @Override
    protected List<Property> implOutputsToClear() {
        return Arrays.asList(this.getDynamicPropertiesArray());
    }
}

