/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.collection.BITable;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BIQueryHandler;
import javax.baja.search.BISearchProvider;
import javax.baja.search.BSearchResult;
import javax.baja.search.BSearchService;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.CloseableIterator;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType(agent={@AgentOn(types={"baja:ComponentSpace", "baja:Component", "bql:BqlScheme"})})
public class BBqlSearchProvider
extends BObject
implements BISearchProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BBqlSearchProvider.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Stream<Entity> search(BOrd query, BIObject scope, Context context) {
        BOrd scopeOrd;
        OrdTarget scopeTarget;
        BIQueryHandler queryHandler;
        if (scope.getType().is(BIQueryHandler.TYPE) && scope.getType().is(BISpaceNode.TYPE) && (queryHandler = (BIQueryHandler)scope).canHandle(scopeTarget = (scopeOrd = ((BISpaceNode)scope).getAbsoluteOrd()).resolve((BObject)BSearchService.getService(), context), null)) {
            OrdQuery[] queries = query.parse();
            CloseableIterator results = queryHandler.query(scopeTarget, queries[queries.length - 1]);
            Spliterator split = Spliterators.spliteratorUnknownSize(results, 0);
            return (Stream)StreamSupport.stream(split, false).onClose(() -> {
                try {
                    results.close();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            });
        }
        BStation station = Sys.getStation();
        if (scope == station.getComponentSpace()) {
            scope = station.getComponentSpace().getRootComponent();
        }
        BITable result = (BITable)query.resolve((BObject)scope, context).get();
        return result.cursor().stream(true).filter(obj -> obj instanceof BISpaceNode || obj instanceof Entity && obj instanceof BIObject && ((Entity)obj).getOrdToEntity().isPresent()).map(obj -> BBqlSearchProvider.convertToSearchResult(obj));
    }

    private static Entity convertToSearchResult(Object obj) {
        if (obj instanceof BVirtualComponent) {
            BVirtualComponent node = (BVirtualComponent)obj;
            return BSearchResult.make(node.getNavOrd().relativizeToSession(), (BIObject)node);
        }
        if (obj instanceof BISpaceNode) {
            BISpaceNode node = (BISpaceNode)obj;
            return BSearchResult.make(node.getOrdInSession(), (BIObject)node);
        }
        if (obj instanceof Entity && obj instanceof BIObject && ((Entity)obj).getOrdToEntity().isPresent()) {
            return BSearchResult.make((BOrd)((Entity)obj).getOrdToEntity().get(), (BIObject)obj);
        }
        return null;
    }
}

