/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BTimeRange", defaultValue="new BTimeRange()"), @NiagaraProperty(name="daysOfWeek", type="BDaysOfWeekBits", defaultValue="BDaysOfWeekBits.DEFAULT"), @NiagaraProperty(name="transitions", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.ALL"), @NiagaraProperty(name="routeAcks", type="boolean", defaultValue="true")})
@NiagaraActions(value={@NiagaraAction(name="routeAlarmAck", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", flags=4), @NiagaraAction(name="routeAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", flags=8)})
@NiagaraTopic(name="newUnackedAlarm", eventType="BAlarmRecord", flags=4)
public abstract class BAlarmRecipient
extends BComponent {
    @Generated
    public static final Property timeRange = BAlarmRecipient.newProperty((int)0, (BValue)new BTimeRange(), null);
    @Generated
    public static final Property daysOfWeek = BAlarmRecipient.newProperty((int)0, (BValue)BDaysOfWeekBits.DEFAULT, null);
    @Generated
    public static final Property transitions = BAlarmRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, null);
    @Generated
    public static final Property routeAcks = BAlarmRecipient.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action routeAlarmAck = BAlarmRecipient.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Action routeAlarm = BAlarmRecipient.newAction((int)8, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Topic newUnackedAlarm = BAlarmRecipient.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmRecipient.class);
    private static final Logger logger = Logger.getLogger("alarm");
    private static final BIcon icon = BIcon.make((String)"module://icons/x16/alarm/alarmRecipient.png");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Generated
    public BTimeRange getTimeRange() {
        return (BTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public BDaysOfWeekBits getDaysOfWeek() {
        return (BDaysOfWeekBits)this.get(daysOfWeek);
    }

    @Generated
    public void setDaysOfWeek(BDaysOfWeekBits v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    @Generated
    public BAlarmTransitionBits getTransitions() {
        return (BAlarmTransitionBits)this.get(transitions);
    }

    @Generated
    public void setTransitions(BAlarmTransitionBits v) {
        this.set(transitions, (BValue)v, null);
    }

    @Generated
    public boolean getRouteAcks() {
        return this.getBoolean(routeAcks);
    }

    @Generated
    public void setRouteAcks(boolean v) {
        this.setBoolean(routeAcks, v, null);
    }

    @Generated
    public void routeAlarmAck(BAlarmRecord parameter) {
        this.invoke(routeAlarmAck, (BValue)parameter, null);
    }

    @Generated
    public void routeAlarm(BAlarmRecord parameter) {
        this.invoke(routeAlarm, (BValue)parameter, null);
    }

    @Generated
    public void fireNewUnackedAlarm(BAlarmRecord event) {
        this.fire(newUnackedAlarm, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void doRouteAlarm(BAlarmRecord alarmRecord) {
        if (this.accept(alarmRecord)) {
            this.handleAlarm(alarmRecord);
        }
    }

    public void doRouteAlarmAck(BAlarmRecord alarmRecord) {
        try {
            ((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).doAckAlarm(alarmRecord);
        }
        catch (ServiceNotFoundException e) {
            logger.warning("BAlarmRecipient: cannot find AlarmService");
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.warning("BAlarmRecipient: cannot resolve alarm source for: " + (Object)((Object)alarmRecord));
            e.printStackTrace();
        }
    }

    public abstract void handleAlarm(BAlarmRecord var1);

    public String[] getSubscribedAlarmClasses() {
        String[] subscribedAlarmClasses = this.getSubscribedAlarmClasses("alarm");
        return subscribedAlarmClasses;
    }

    public String[] getSubscribedEscalatedAlarmClasses(int level) {
        if (level < 1 || level > 3) {
            return new String[0];
        }
        return this.getSubscribedAlarmClasses("escalatedAlarm" + level);
    }

    private String[] getSubscribedAlarmClasses(String sourceSlotName) {
        ArrayList<String> classes = new ArrayList<String>();
        SlotCursor c = this.getProperties();
        while (c.next(BLink.class)) {
            try {
                BComponent srcComp;
                BLink link = (BLink)c.get();
                if (!link.isActive()) {
                    link.activate();
                }
                if ((srcComp = link.getSourceComponent()) == null || srcComp.getName() == null) continue;
                if (srcComp instanceof BAlarmClass && link.getSourceSlotName().equals(sourceSlotName)) {
                    classes.add(srcComp.getName());
                    continue;
                }
                while (srcComp instanceof BIAlarmClassFolder) {
                    BComponent folder = srcComp;
                    String folderSlotName = link.getSourceSlotName();
                    BStruct struct = (BStruct)folder.get(folderSlotName);
                    if (struct instanceof BCompositeAction) {
                        for (BLink srcLink : srcComp.getLinks((Slot)struct.getPropertyInParent())) {
                            if (!srcLink.getTargetSlotName().equals(((BCompositeAction)struct).getMirror().knob.getSourceSlotName())) continue;
                            srcComp = srcLink.getSourceComponent();
                            link = srcLink;
                        }
                    } else if (struct instanceof BCompositeTopic) {
                        link = ((BCompositeTopic)struct).getMirror().link;
                        srcComp = link.getSourceComponent();
                    }
                    if (!(srcComp instanceof BAlarmClass) || !link.getSourceSlotName().equals(sourceSlotName)) continue;
                    classes.add(srcComp.getName());
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "alarm:BAlarmRecipient:getSubscribedAlarmClasses " + e.getMessage(), e);
            }
        }
        return classes.toArray(EMPTY_STRING_ARRAY);
    }

    public boolean accept(BAlarmRecord rec) {
        BAbsTime now = rec.getTimestamp();
        if (!this.getDaysOfWeek().includes(now.getWeekday())) {
            return false;
        }
        if (!this.getTimeRange().includes(now)) {
            return false;
        }
        if (!this.getTransitions().includes(rec.getSourceState())) {
            return false;
        }
        if (!this.getRouteAcks() && rec.isAcknowledged()) {
            if (rec.getNormalTime().isNull()) {
                return false;
            }
            if (rec.getNormalTime().isBefore(rec.getAckTime())) {
                return false;
            }
        }
        return true;
    }

    public String toString(Context cx) {
        if (this.isMounted()) {
            return this.getName();
        }
        return TYPE.getTypeName();
    }

    public BIcon getIcon() {
        return icon;
    }
}

