/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.fox.BIFoxAlarmDatabase;
import com.tridium.alarm.fox.FoxAlarmDbConnection;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.nav.BINavSupport;
import java.util.Optional;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.bql.Queryable;
import javax.baja.bql.RemoteQueryable;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFoxAlarmDatabase
extends BAlarmDatabase
implements BIFoxProxySpace,
Queryable,
RemoteQueryable,
NavListener,
BIFoxAlarmDatabase {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxAlarmDatabase.class);
    private BFoxSession session;
    private BPermissions permissions;
    private BOrd navOrd;
    private Optional<BAlarmArchive> cachedAlarmArchive;
    private static final String ALARM_ORD = "alarm:";
    protected Work work = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxAlarmDatabase() {
    }

    public BFoxAlarmDatabase(BFoxSession session) {
        this.session = session;
    }

    @Override
    public AlarmDbConnection getDbConnection(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissionsFor((BIProtected)this).hasOperatorRead()) {
            throw new AlarmException("user needs alarm space permissions");
        }
        return FoxAlarmDbConnection.make(this, cx);
    }

    @Override
    public void updateConfig(BAlarmDbConfig config, Property p) {
    }

    public BAlarmDbChannel getChannel() {
        BAlarmDbChannel channel = null;
        try {
            channel = (BAlarmDbChannel)this.getSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
        }
        catch (Exception e) {
            BFoxChannelRegistry.getPrototype().add("alarmdb", (BValue)new BAlarmDbChannel());
            channel = (BAlarmDbChannel)this.getSession().getConnection().getChannels().get("alarmdb", BAlarmDbChannel.TYPE);
        }
        return channel;
    }

    public BFoxSession getSession() {
        return this.getFoxSession();
    }

    @Override
    public BFoxSession getFoxSession() {
        if (this.session == null) {
            this.session = (BFoxSession)this.getNavParent();
        }
        return this.session;
    }

    @Override
    protected Optional<BAlarmArchive> getAlarmArchive() {
        if (this.cachedAlarmArchive == null) {
            try {
                this.cachedAlarmArchive = this.getChannel().getArchive();
            }
            catch (Exception e) {
                this.cachedAlarmArchive = Optional.empty();
            }
        }
        return this.cachedAlarmArchive;
    }

    public BOrd getNavOrd() {
        if (this.navOrd == null && this.getFoxSession() != null) {
            this.navOrd = BOrd.make((String)(this.getFoxSession().getNavOrd() + "|alarm:"));
        }
        return this.navOrd;
    }

    public void init(BFoxSession foxSession) throws Exception {
        this.session = foxSession;
        this.permissions = this.getChannel().getPermissions();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        this.cachedAlarmArchive = null;
    }

    public void cleanup(BFoxSession foxSession) throws Exception {
        this.cachedAlarmArchive = null;
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent event) {
        if (this.cachedAlarmArchive == null) {
            return;
        }
        String parentOrd = event.getParentOrd().relativizeToSession().encodeToString();
        if (!this.cachedAlarmArchive.isPresent() && event.getId() == 1 && parentOrd.startsWith(ALARM_ORD)) {
            this.cachedAlarmArchive = null;
            this.refreshNavTree();
        } else if ((event.getId() == 2 || event.getId() == 5) && parentOrd.startsWith(ALARM_ORD)) {
            this.cachedAlarmArchive = null;
        }
    }

    private void refreshNavTree() {
        BINavSupport support = BINavSupport.getNavSupport();
        if (support != null) {
            if (this.work == null) {
                this.work = new Work(support.makeNavTreeWork((BINavNode)this));
            }
            if (!this.work.running) {
                support.runNavTreeWork((Runnable)this.work);
            }
        }
    }

    public BObject bqlQuery(BOrd ord) {
        try {
            return this.getChannel().resolve(ord);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (this.permissions == null) {
            try {
                this.permissions = this.getChannel().getPermissions();
            }
            catch (Exception e) {
                this.permissions = BPermissions.all;
                e.printStackTrace();
            }
        }
        return this.permissions;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public BCategoryMask getCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    protected static class Work
    implements Runnable {
        public boolean running = false;
        Runnable work;

        public Work(Runnable work) {
            this.work = work;
        }

        @Override
        public void run() {
            try {
                this.running = true;
                this.work.run();
            }
            finally {
                this.running = false;
            }
        }
    }
}

