/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.fox;

import com.tridium.alarm.fox.BAlarmArchiveChannel;
import com.tridium.alarm.fox.BAlarmDbChannel;
import com.tridium.alarm.fox.BIFoxAlarmDatabase;
import com.tridium.alarm.fox.FoxAlarmArchiveConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmDbConfig;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BArchiveAlarmProvider;
import javax.baja.bql.RemoteQueryable;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFoxAlarmArchive
extends BAlarmArchive
implements BIFoxProxySpace,
RemoteQueryable,
BIFoxAlarmDatabase {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxAlarmArchive.class);
    private BPermissions permissions;
    private BFoxSession session;
    private BOrd navOrd;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxAlarmArchive(BFoxSession session) {
        this.session = session;
    }

    @Override
    protected BAlarmService getAlarmService() {
        BAlarmService svc = super.getAlarmService();
        svc.lease(1);
        return svc;
    }

    private boolean isAlarmArchiveEnabled() {
        BArchiveAlarmProvider[] providers = (BArchiveAlarmProvider[])this.getAlarmService().getChildren(BArchiveAlarmProvider.class);
        return providers.length == 1 && providers[0].getEnabled();
    }

    @Override
    public AlarmDbConnection getDbConnection(Context cx) {
        if (this.isAlarmArchiveEnabled()) {
            return FoxAlarmArchiveConnection.make(this, cx);
        }
        return null;
    }

    @Override
    public void updateConfig(BAlarmDbConfig config, Property p) throws AlarmException {
    }

    public void init(BFoxSession foxSession) throws Exception {
        this.session = foxSession;
        this.permissions = this.getChannel().getPermissions();
    }

    public void cleanup(BFoxSession foxSession) throws Exception {
    }

    public BObject bqlQuery(BOrd ord) {
        try {
            return this.getChannel().resolve(ord);
        }
        catch (Exception e) {
            if (e instanceof AlarmException) {
                throw (AlarmException)((Object)e);
            }
            throw new AlarmException(e);
        }
    }

    @Override
    public BISession getSession() {
        return this.getFoxSession();
    }

    public BOrd getNavOrd() {
        if (this.navOrd == null && this.getFoxSession() != null) {
            this.navOrd = BOrd.make((String)(this.getFoxSession().getNavOrd() + "|alarm:archive"));
        }
        return this.navOrd;
    }

    @Override
    public BFoxSession getFoxSession() {
        if (this.session != null) {
            return this.session;
        }
        BINavNode navSession = this.getNavParent();
        while (navSession != null) {
            if (navSession instanceof BFoxSession) {
                this.session = (BFoxSession)navSession;
                return this.session;
            }
            navSession = this.getNavParent();
        }
        return null;
    }

    public BAlarmDbChannel getChannel() {
        return (BAlarmDbChannel)this.getFoxSession().getConnection().getChannels().get("alarmArchive", BAlarmArchiveChannel.TYPE);
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (this.permissions == null) {
            try {
                this.permissions = this.getChannel().getPermissions();
            }
            catch (Exception e) {
                this.permissions = BPermissions.all;
                e.printStackTrace();
            }
        }
        return this.permissions;
    }

    @Override
    public BArchiveAlarmProvider getProvider() {
        return null;
    }
}

