/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import com.tridium.alarm.db.file.DataRecoveryAlarmEvent;
import com.tridium.dataRecovery.BDataRecoveryEmptyKey;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.io.BIEncodable;
import javax.baja.naming.BOrdList;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BUuid;

public class FileAlarmDbConnection
extends AlarmDbConnection {
    private static final boolean efficient = FileAlarmDbConnection.getEfficientConfiguration();
    private static final boolean USE_EFFICIENT_CONFIGURATION = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("niagara.fileAlarm.enableCachedSources", "true")));
    private BFileAlarmDatabase db;
    private Context cx;
    private AlarmStore alarmStore;
    public static final Logger LOG = Logger.getLogger("alarm.dbConnection");
    private static final BIEncodable EMPTY_KEY = BDataRecoveryEmptyKey.INSTANCE;
    private BIDataRecoveryService dataRecoveryService;
    private static final Logger dataRecoveryLog = Logger.getLogger("alarm.dataRecovery");

    FileAlarmDbConnection(BFileAlarmDatabase db, Context cx) {
        this.db = db;
        this.cx = cx;
        if (db.dataRecoveryService != null && db.dataRecoveryService.isEnabled()) {
            this.dataRecoveryService = db.dataRecoveryService;
        }
    }

    @Override
    public BAlarmDatabase getAlarmDatabase() {
        return this.db;
    }

    private AlarmStore getAlarmStore() {
        if (this.alarmStore == null) {
            this.alarmStore = (AlarmStore)this.db.fw(602, null, null, null, null);
        }
        return this.alarmStore;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void append(BAlarmRecord rec) throws IOException, AlarmException {
        this.db.assertOpen();
        if (this.dataRecoveryService != null) {
            this.appendDataRecoveryRecord(this.db, EMPTY_KEY, new DataRecoveryAlarmEvent.Append(rec));
        }
        this.getAlarmStore().append(rec);
    }

    @Override
    public void update(BAlarmRecord rec) throws IOException, AlarmException {
        this.db.assertOpen();
        if (this.dataRecoveryService != null) {
            this.appendDataRecoveryRecord(this.db, EMPTY_KEY, new DataRecoveryAlarmEvent.Update(rec));
        }
        this.getAlarmStore().update(rec);
    }

    @Override
    public synchronized int getRecordCount() {
        this.db.assertOpen();
        return this.getAlarmStore().getRecordCount();
    }

    public synchronized int getOpenRecordCount(BOrdList source) {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenCount(source);
    }

    public synchronized int getOpenAckPendingRecordCount(BOrdList source) {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenAckPendCount(source);
    }

    public synchronized int getOpenUnackedRecordCount(BOrdList source) {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenUnackCount(source);
    }

    public synchronized int getOpenAckedRecordCount(BOrdList source) {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenAckCount(source);
    }

    @Override
    public synchronized BAlarmRecord getRecord(BUuid uuid) throws IOException {
        this.db.assertOpen();
        return this.getAlarmStore().getRecord(uuid);
    }

    @Override
    public synchronized Cursor<BAlarmRecord> getOpenAlarms() throws IOException {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenAlarms();
    }

    @Override
    public synchronized Cursor<BAlarmSource> getOpenAlarmSources() throws IOException {
        if (efficient) {
            this.db.assertOpen();
            return this.getAlarmStore().getAlarmSources(this.cx);
        }
        return super.getOpenAlarmSources();
    }

    @Override
    public Cursor<BAlarmRecord> getAckPendingAlarms() throws IOException {
        this.db.assertOpen();
        return this.getAlarmStore().getAckPendingAlarms();
    }

    @Override
    public Cursor<BAlarmRecord> getAlarmsForSource(BOrdList alarmSource) throws IOException {
        this.db.assertOpen();
        return this.getAlarmStore().getAlarmsForSource(alarmSource);
    }

    @Override
    public Cursor<BAlarmRecord> getOpenAlarmsForSource(BOrdList alarmSource) throws IOException {
        this.db.assertOpen();
        return this.getAlarmStore().getOpenAlarmsForSource(alarmSource);
    }

    @Override
    public Cursor<BAlarmRecord> scan() throws IOException, AlarmException {
        this.db.assertOpen();
        return this.getAlarmStore().scan();
    }

    @Override
    public Cursor<BAlarmRecord> timeQuery(BAbsTime start, BAbsTime end) throws IOException, AlarmException {
        this.db.assertOpen();
        return this.getAlarmStore().timeQuery(start, end);
    }

    @Override
    public void clearAllRecords(Context cx) throws IOException {
        this.db.assertOpen();
        if (this.dataRecoveryService != null) {
            this.appendDataRecoveryRecord(this.db, EMPTY_KEY, new DataRecoveryAlarmEvent.ClearAll());
        }
        Auditor auditor = Nre.auditor;
        int oldCount = this.getRecordCount();
        this.getAlarmStore().clearAllRecords(cx);
        if (auditor != null) {
            String userName = "";
            if (cx != null && cx.getUser() != null) {
                userName = cx.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear", Integer.toString(oldCount) + " records", Integer.toString(this.getRecordCount()) + " records", userName));
        }
    }

    @Override
    public void clearOldRecords(BAbsTime before, Context cx) throws IOException {
        this.db.assertOpen();
        if (this.dataRecoveryService != null) {
            this.appendDataRecoveryRecord(this.db, EMPTY_KEY, new DataRecoveryAlarmEvent.ClearOld(before));
        }
        Auditor auditor = Nre.auditor;
        int oldCount = this.getRecordCount();
        this.getAlarmStore().clearOldRecords(before, cx);
        if (auditor != null) {
            String userName = "";
            if (cx != null && cx.getUser() != null) {
                userName = cx.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear before " + before.toString((Context)BAlarmRecord.TIMESTAMP_FACETS), Integer.toString(oldCount) + " records", Integer.toString(this.getRecordCount()) + " records", userName));
        }
    }

    @Override
    public void clearRecord(BUuid uuid, Context cx) throws IOException {
        if (uuid == null || uuid.isNull()) {
            return;
        }
        this.db.assertOpen();
        if (this.dataRecoveryService != null) {
            this.appendDataRecoveryRecord(this.db, EMPTY_KEY, new DataRecoveryAlarmEvent.ClearRecord(uuid));
        }
        Auditor auditor = Nre.auditor;
        int oldCount = this.getRecordCount();
        this.getAlarmStore().clearRecord(uuid, cx);
        if (auditor != null) {
            String userName = "";
            if (cx != null && cx.getUser() != null) {
                userName = cx.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "Alarm Database", "Clear record " + uuid, Integer.toString(oldCount) + " records", Integer.toString(this.getRecordCount()) + " records", userName));
        }
    }

    private void appendDataRecoveryRecord(BIDataRecoverySource source, BIEncodable key, DataRecoveryAlarmEvent event) {
        try {
            if (this.dataRecoveryService != null) {
                if (dataRecoveryLog.isLoggable(Level.FINE)) {
                    dataRecoveryLog.fine("Recording alarm event '" + event + "'");
                }
                this.dataRecoveryService.append(source, key, event.encode());
            }
        }
        catch (DataRecoveryServiceInFaultException drsife) {
            this.dataRecoveryService = null;
            dataRecoveryLog.log(Level.WARNING, "DataRecoveryService in fault, could not append alarm event '" + event + "'. Stopped data recovery alarm recording.", drsife);
        }
        catch (Throwable e) {
            dataRecoveryLog.log(Level.SEVERE, "DataRecoveryService could not record alarm event '" + event + "'", e);
        }
    }

    private static boolean getEfficientConfiguration() {
        return USE_EFFICIENT_CONFIGURATION;
    }
}

