/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Block;
import java.io.IOException;
import java.io.PrintStream;
import javax.baja.nre.util.IntHashMap;

public class BlockCache {
    private AlarmStore store;
    private int max;
    private int size;
    private IntHashMap table;
    private Block newest;
    private Block oldest;

    public BlockCache(AlarmStore store, int maxBlocks) {
        this.store = store;
        this.max = maxBlocks;
        this.table = new IntHashMap(this.max);
        this.size = 0;
        this.newest = null;
        this.oldest = null;
    }

    public synchronized Block getBlock(int blockIndex) {
        return (Block)this.table.get(blockIndex);
    }

    public synchronized void add(Block block) throws IOException {
        int index = block.getIndex();
        Block existing = (Block)this.table.get(index);
        if (existing != null) {
            if (existing.prev != null) {
                existing.prev.next = existing.next;
            }
            if (existing.next != null) {
                existing.next.prev = existing.prev;
            }
            if (existing == this.newest) {
                this.newest = existing.next;
            }
            if (existing == this.oldest) {
                this.oldest = existing.prev;
            }
            existing.next = null;
            existing.prev = null;
            --this.size;
        }
        this.table.put(index, (Object)block);
        if (this.newest == null) {
            this.newest = this.oldest = block;
            block.next = null;
            block.prev = null;
        } else {
            this.newest.prev = block;
            block.next = this.newest;
            block.prev = null;
            this.newest = block;
        }
        ++this.size;
        if (this.size > this.max) {
            this.evict(this.size - this.max);
        }
    }

    public synchronized void remove(int blockIndex) {
        Block block = (Block)this.table.get(blockIndex);
        if (block == null) {
            return;
        }
        this.table.remove(blockIndex);
        if (block.prev != null) {
            block.prev.next = block.next;
        }
        if (block.next != null) {
            block.next.prev = block.prev;
        }
        if (block == this.newest) {
            this.newest = block.next;
        }
        if (block == this.oldest) {
            this.oldest = block.prev;
        }
        block.next = null;
        block.prev = null;
        --this.size;
    }

    public synchronized void remove(Block block) {
        this.remove(block.getIndex());
    }

    public synchronized void flush() throws IOException {
        Block temp = this.newest;
        while (temp != null) {
            this.store.writeBlock(temp);
            temp = temp.next;
        }
    }

    public synchronized void evict(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            if (this.size == 0) {
                return;
            }
            this.store.writeBlock(this.oldest);
            this.table.remove(this.oldest.getIndex());
            if (this.newest == this.oldest) {
                this.oldest = null;
                this.newest = null;
            } else {
                Block gone = this.oldest;
                this.oldest = this.oldest.prev;
                this.oldest.next = null;
                gone.next = null;
                gone.prev = null;
            }
            --this.size;
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(PrintStream out) {
        out.println("BlockCache.dump");
        out.println("  forward");
        int i = 0;
        Block temp = this.newest;
        while (temp != null) {
            out.print("    " + i++ + ") block " + temp.getIndex());
            if (temp == this.oldest) {
                out.print(" (oldest)");
            }
            if (temp == this.newest) {
                out.print(" (newest)");
            }
            out.println();
            temp = temp.next;
        }
        out.println("  reverse");
        --i;
        temp = this.oldest;
        while (temp != null) {
            out.print("    " + i-- + ") block " + temp.getIndex());
            if (temp == this.oldest) {
                out.print(" (oldest)");
            }
            if (temp == this.newest) {
                out.print(" (newest)");
            }
            out.println();
            temp = temp.prev;
        }
    }
}

