/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AckPendingIndex;
import com.tridium.alarm.db.file.AlarmSourceIndex;
import com.tridium.alarm.db.file.AlarmStoreHeader;
import com.tridium.alarm.db.file.Block;
import com.tridium.alarm.db.file.BlockCache;
import com.tridium.alarm.db.file.FreePageMap;
import com.tridium.alarm.db.file.IndexEntry;
import com.tridium.alarm.db.file.OpenIndex;
import com.tridium.alarm.db.file.Page;
import com.tridium.alarm.db.file.PageReader;
import com.tridium.alarm.db.file.SkipList;
import com.tridium.alarm.db.file.TimestampIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSource;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.AbstractReverseCursor;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BObjectArrayCursor;
import javax.baja.util.BUuid;

public class AlarmStore {
    private static final int BLOCK_CACHE_SIZE = 10;
    private static final int MAX_SIZE = 250000;
    private static final int MAX_SIZE_PER_SOURCE = 10000;
    private static final BAlarmSource[] EMPTY_ALARM_SOURCE_ARRAY = new BAlarmSource[0];
    private final File alarmFile;
    private RandomAccessFile io;
    private int capacity;
    private AlarmStoreHeader header;
    private FreePageMap freeMap;
    private BlockCache blockCache;
    private ByteBuffer writeBuf;
    private PageReader reader;
    private int[] recPages;
    private Map<BUuid, IndexEntry> byUuid;
    private TimestampIndex timestampIndex;
    private AlarmSourceIndex sourceIndex;
    private OpenIndex openIndex;
    private AckPendingIndex ackPendingIndex;
    private Map<BOrdList, AlarmCount> currentCounts;
    private BAlarmRecord trimRec;
    private final BAlarmService alarmService;

    public AlarmStore(File alarmFile, int capacity) {
        this.alarmFile = alarmFile;
        this.capacity = capacity;
        this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    public AlarmStore(File alarmFile) {
        this.alarmFile = alarmFile;
        this.capacity = Integer.MAX_VALUE;
        this.alarmService = null;
    }

    public AlarmStoreHeader getHeader() {
        return this.header;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void open() throws IOException {
        try {
            AccessController.doPrivileged(new OpenPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private void create() throws IOException {
        this.header = new AlarmStoreHeader(new BAlarmRecord(BUuid.DEFAULT).getSerialVersionId());
        this.io.seek(0L);
        this.header.write(this.io);
        this.freeMap = new FreePageMap();
        BAlarmDatabase.log.info("Created");
    }

    private void init() throws IOException {
        BAlarmDatabase.log.info("Loading...");
        this.header = new AlarmStoreHeader();
        this.io.seek(0L);
        this.header.read(this.io);
        int recVersion = new BAlarmRecord(BUuid.DEFAULT).getSerialVersionId();
        if (this.header.getRecordVersion() != recVersion) {
            throw new IOException("Incompatible record versions.  (expected=" + recVersion + ", actual=" + this.header.getRecordVersion() + ')');
        }
        this.freeMap = new FreePageMap();
        int pageCount = (int)((this.io.length() - this.header.getDataOffset()) / (long)this.header.getPageSize());
        BAlarmRecord rec = new BAlarmRecord(BUuid.DEFAULT);
        BAlarmRecord dup = new BAlarmRecord(BUuid.DEFAULT);
        long start = Clock.ticks();
        int badRecordCount = 0;
        for (int i = 0; i < pageCount; ++i) {
            BAlarmClass ac;
            Page p = this.readPage(i);
            if (p.getPageOfRecord() != 0) continue;
            if ((rec = this.readRecord(i, rec, this.freeMap)) == null) {
                if (++badRecordCount != 20) continue;
                throw new IOException("Alarm database is invalid.  Too many invalid records read during init.");
            }
            IndexEntry entry = this.byUuid.get(rec.getUuid());
            if (entry != null) {
                if ((dup = this.readRecord(entry.pageIndex, dup, null)) == null) {
                    if (++badRecordCount == 20) {
                        throw new IOException("Alarm database is invalid.  Too many invalid records read during init.");
                    }
                    this.freePageRun(entry.pageIndex);
                    this.updateIndices(rec, null, i);
                }
                if (dup.getLastUpdate().isAfter(rec.getLastUpdate())) {
                    if (BAlarmDatabase.log.isLoggable(Level.FINE)) {
                        BAlarmDatabase.log.fine("Record " + rec.getUuid() + ": Already Exists in DB - Using existing record.");
                        if (BAlarmDatabase.log.isLoggable(Level.FINEST)) {
                            BAlarmDatabase.log.finest("  Discarded record: " + (Object)((Object)rec));
                            BAlarmDatabase.log.finest("  Existing record: " + (Object)((Object)dup));
                        }
                    }
                    this.freePageRun(i);
                    continue;
                }
                if (BAlarmDatabase.log.isLoggable(Level.FINE)) {
                    BAlarmDatabase.log.fine("Record " + rec.getUuid() + ": Already Exists in DB. Using new record.");
                    if (BAlarmDatabase.log.isLoggable(Level.FINEST)) {
                        BAlarmDatabase.log.finest("  Existing record: " + (Object)((Object)dup));
                        BAlarmDatabase.log.finest("  New record: " + (Object)((Object)rec));
                    }
                }
                this.freePageRun(entry.pageIndex);
                this.updateIndices(rec, dup, i);
            } else {
                this.updateIndices(rec, null, i);
            }
            if (this.alarmService == null || !(ac = this.alarmService.lookupAlarmClass(rec.getAlarmClass())).getName().equals(rec.getAlarmClass())) continue;
            ac.setTotalAlarmCount(ac.getTotalAlarmCount() + 1);
            if (!(rec.isAcknowledged() || !rec.getAckRequired() && rec.isNormal())) {
                ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() + 1);
            }
            if (rec.isOpen()) {
                ac.setOpenAlarmCount(ac.getOpenAlarmCount() + 1);
            }
            if (rec.isNormal()) continue;
            ac.setInAlarmCount(ac.getInAlarmCount() + 1);
        }
        long end = Clock.ticks();
        BAlarmDatabase.log.info("Loaded [" + (end - start) + "ms, " + this.getRecordCount() + " alarms, " + pageCount + " pages]");
        if (badRecordCount > 0 && BAlarmDatabase.log.isLoggable(Level.FINE)) {
            BAlarmDatabase.log.fine("Discarded " + badRecordCount + " Bad Records");
        }
    }

    public synchronized void close() {
        if (this.io != null) {
            try {
                this.io.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.io = null;
        }
    }

    public synchronized void append(BAlarmRecord rec) throws IOException {
        this.appendToStore(rec);
        this.trimToCapacity();
    }

    private synchronized void appendToStore(BAlarmRecord rec) throws IOException {
        int oldStartIndex = -1;
        IndexEntry entry = this.byUuid.get(rec.getUuid());
        if (entry != null) {
            oldStartIndex = entry.pageIndex;
        }
        boolean exists = entry != null;
        this.writeBuf.reset();
        rec.write((DataOutput)this.writeBuf, BAlarmRecord.ALARM_STORE_CX);
        rec.getUuid().encode((DataOutput)this.writeBuf);
        byte[] recbytes = this.writeBuf.getBytes();
        int len = this.writeBuf.getLength();
        int offset = 0;
        int pageCapacity = this.header.getPageSize() - 12;
        int pages = len / pageCapacity;
        if (len % pageCapacity != 0) {
            ++pages;
        }
        int[] recPages = this.takePages(pages);
        if (!exists) {
            BAlarmClass ac;
            if (this.alarmService != null && (ac = this.alarmService.lookupAlarmClass(rec.getAlarmClass())).getName().equals(rec.getAlarmClass())) {
                ac.setTotalAlarmCount(ac.getTotalAlarmCount() + 1);
                if (!rec.isAcknowledged()) {
                    ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() + 1);
                }
                if (rec.isOpen()) {
                    ac.setOpenAlarmCount(ac.getOpenAlarmCount() + 1);
                }
                if (!rec.isNormal()) {
                    ac.setInAlarmCount(ac.getInAlarmCount() + 1);
                }
            }
            this.updateIndices(rec, null, recPages[0]);
        } else {
            BAlarmClass ac;
            IndexEntry oldRec = this.byUuid.get(rec.getUuid());
            BAlarmRecord oldRecord = this.readRecord(oldRec.pageIndex, null);
            if (this.alarmService != null && (ac = this.alarmService.lookupAlarmClass(rec.getAlarmClass())).getName().equals(rec.getAlarmClass())) {
                if (!oldRec.isAcked() && rec.isAcknowledged()) {
                    ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() - 1);
                } else if (!oldRec.isAcked() && rec.isNormal() && !rec.getAckRequired()) {
                    ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() - 1);
                } else if (oldRec.isAcked() && !rec.isAcknowledged()) {
                    ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() + 1);
                }
                if (!oldRec.isOpen() && rec.isOpen()) {
                    ac.setOpenAlarmCount(ac.getOpenAlarmCount() + 1);
                }
                if (oldRec.isOpen() && !rec.isOpen()) {
                    ac.setOpenAlarmCount(ac.getOpenAlarmCount() - 1);
                }
                if (oldRec.isNormal() && !rec.isNormal()) {
                    ac.setInAlarmCount(ac.getInAlarmCount() + 1);
                }
                if (!oldRec.isNormal() && rec.isNormal()) {
                    ac.setInAlarmCount(ac.getInAlarmCount() - 1);
                }
            }
            this.updateIndices(rec, oldRecord, recPages[0]);
        }
        for (int i = 0; i < pages; ++i) {
            int pageIndex = recPages[i];
            int nextIndex = i == pages - 1 ? -1 : recPages[i + 1];
            Page p = this.readPage(pageIndex);
            int bytesThisPage = Math.min(len - offset, pageCapacity);
            p.write(i, pages, nextIndex, recbytes, offset, bytesThisPage);
            offset += bytesThisPage;
        }
        if (offset != len) {
            throw new IOException("Write error: " + offset + " of " + len + " bytes written.");
        }
        if (oldStartIndex != -1) {
            this.freePageRun(oldStartIndex);
        }
    }

    public synchronized void update(BAlarmRecord rec) throws IOException {
        this.appendToStore(rec);
        this.trimToCapacity();
    }

    private synchronized void remove(IndexEntry entry, BAlarmRecord temp) throws IOException {
        BAlarmClass ac;
        AlarmCount alarmCount;
        if (entry == null && temp == null) {
            return;
        }
        if (entry == null && (entry = this.byUuid.get(temp.getUuid())) == null) {
            return;
        }
        if ((temp = this.readRecord(entry.pageIndex, temp, null)) == null && BAlarmDatabase.log.isLoggable(Level.FINE)) {
            BAlarmDatabase.log.fine("Could not read record while removing entry; entry.pageIndex: " + entry.pageIndex + ", entry.timestamp: " + entry.timestamp);
        }
        AlarmCount alarmCount2 = alarmCount = temp != null ? this.currentCounts.get(temp.getSource()) : null;
        if (temp != null) {
            this.byUuid.remove(temp.getUuid());
        } else {
            this.byUuid.values().remove(entry);
        }
        this.timestampIndex.remove(entry);
        if (temp != null) {
            this.sourceIndex.remove(temp.getSource(), entry);
        } else {
            for (Map.Entry<BOrdList, SkipList> sourceIndexEntry : this.sourceIndex.getTable().entrySet()) {
                SkipList skipList = sourceIndexEntry.getValue();
                skipList.remove(entry);
            }
        }
        if (entry.isOpen()) {
            this.openIndex.remove(entry);
            if (alarmCount != null && temp != null) {
                AlarmStore.decrementOpenCounts(alarmCount, temp);
            }
        }
        if (entry.isAckPending()) {
            this.ackPendingIndex.remove(entry);
        }
        if (temp != null) {
            this.currentCounts.remove(temp.getSource());
        }
        if (alarmCount != null && !alarmCount.empty()) {
            alarmCount.checkCounts();
            this.currentCounts.put(temp.getSource(), alarmCount);
        }
        this.freePageRun(entry.pageIndex);
        if (this.alarmService != null && temp != null && (ac = this.alarmService.lookupAlarmClass(temp.getAlarmClass())).getName().equals(temp.getAlarmClass())) {
            ac.setTotalAlarmCount(ac.getTotalAlarmCount() - 1);
            if (!temp.isAcknowledged()) {
                ac.setUnackedAlarmCount(ac.getUnackedAlarmCount() - 1);
            }
            if (temp.isOpen()) {
                ac.setOpenAlarmCount(ac.getOpenAlarmCount() - 1);
            }
            if (!temp.isNormal()) {
                ac.setInAlarmCount(ac.getInAlarmCount() - 1);
            }
        }
        entry.nextTimestamp = null;
        entry.prevTimestamp = null;
        entry.nextSource = null;
        entry.prevSource = null;
        entry = null;
    }

    private static void decrementOpenCounts(AlarmCount entryCount, BAlarmRecord rec) {
        --entryCount.openCount;
        if (rec.isAcknowledged() && entryCount.openAckCount > 0) {
            --entryCount.openAckCount;
        } else if (rec.isAckPending() && entryCount.openAckPendingCount > 0) {
            --entryCount.openAckPendingCount;
        } else if (entryCount.openUnackCount > 0) {
            --entryCount.openUnackCount;
        }
    }

    private static void incrementOpenCounts(AlarmCount entryCount, BAlarmRecord rec) {
        ++entryCount.openCount;
        if (rec.isAcknowledged()) {
            ++entryCount.openAckCount;
        } else if (rec.isAckPending()) {
            ++entryCount.openAckPendingCount;
        } else {
            ++entryCount.openUnackCount;
        }
    }

    private synchronized void updateIndices(BAlarmRecord rec, BAlarmRecord oldRec, int startPage) {
        AlarmCount alarmCount;
        IndexEntry existing = this.byUuid.get(rec.getUuid());
        if (existing != null) {
            this.byUuid.remove(rec.getUuid());
            this.timestampIndex.remove(existing);
            alarmCount = this.currentCounts.get(rec.getSource());
            if (oldRec != null) {
                this.sourceIndex.remove(oldRec.getSource(), existing);
            }
            if (existing.isOpen()) {
                this.openIndex.remove(existing);
                if (alarmCount != null && oldRec != null) {
                    AlarmStore.decrementOpenCounts(alarmCount, oldRec);
                }
            }
            if (existing.isAckPending()) {
                this.ackPendingIndex.remove(existing);
            }
            this.currentCounts.remove(rec.getSource());
            if (alarmCount != null && !alarmCount.empty()) {
                this.currentCounts.put(rec.getSource(), alarmCount);
            }
        }
        IndexEntry newEntry = new IndexEntry(rec, startPage);
        this.byUuid.put(rec.getUuid(), newEntry);
        alarmCount = this.currentCounts.get(rec.getSource());
        if (alarmCount == null) {
            alarmCount = new AlarmCount();
        }
        this.timestampIndex.add(newEntry);
        this.sourceIndex.add(rec.getSource(), newEntry);
        if (rec.isOpen()) {
            this.openIndex.add(newEntry);
            AlarmStore.incrementOpenCounts(alarmCount, rec);
        }
        if (rec.isAckPending()) {
            this.ackPendingIndex.add(newEntry);
        }
        this.currentCounts.put(rec.getSource(), alarmCount);
        newEntry.setAcked(rec.isAcknowledged());
        newEntry.setNormal(rec.isNormal());
        newEntry.setAckPending(rec.isAckPending());
    }

    public synchronized void flush() throws IOException {
        this.blockCache.flush();
    }

    public synchronized int getRecordCount() {
        return this.timestampIndex.getSize();
    }

    public synchronized BAlarmRecord getRecord(BUuid uuid) throws IOException {
        IndexEntry entry = this.byUuid.get(uuid);
        if (entry != null) {
            return this.readRecord(entry.pageIndex, null);
        }
        return null;
    }

    public synchronized int getOpenCount(BOrdList source) {
        int count = 0;
        AlarmCount sourceCount = this.currentCounts.get(source);
        if (sourceCount != null) {
            count = sourceCount.openCount;
        }
        return count;
    }

    public synchronized int getOpenAckCount(BOrdList source) {
        int count = 0;
        AlarmCount sourceCount = this.currentCounts.get(source);
        if (sourceCount != null) {
            count = sourceCount.openAckCount;
        }
        return count;
    }

    public synchronized int getOpenUnackCount(BOrdList source) {
        int count = 0;
        AlarmCount sourceCount = this.currentCounts.get(source);
        if (sourceCount != null) {
            count = sourceCount.openUnackCount;
        }
        return count;
    }

    public synchronized int getOpenAckPendCount(BOrdList source) {
        int count = 0;
        AlarmCount sourceCount = this.currentCounts.get(source);
        if (sourceCount != null) {
            count = sourceCount.openAckPendingCount;
        }
        return count;
    }

    public synchronized Cursor<BAlarmRecord> scan() {
        return new TimestampCursor(this, this.timestampIndex.getFirstEntry(), null);
    }

    public synchronized Cursor<BAlarmRecord> timeQuery(BAbsTime startTime, BAbsTime endTime) {
        IndexEntry startEntry;
        if (startTime == null || startTime.isNull()) {
            startEntry = this.timestampIndex.getFirstEntry();
        } else {
            startEntry = this.timestampIndex.find(startTime);
            if (startEntry != null) {
                startEntry = startEntry.nextTimestamp[0];
            }
        }
        return new TimestampCursor(this, startEntry, endTime);
    }

    public synchronized Cursor<BAlarmRecord> getAlarmsForSource(BOrdList source) {
        IndexEntry startEntry = this.sourceIndex.getListForSource(source);
        IndexEntry tailEntry = this.sourceIndex.getLastForSource(source);
        return new SourceCursor(this, startEntry, tailEntry, null);
    }

    public synchronized Cursor<BAlarmRecord> getOpenAlarmsForSource(BOrdList source) {
        IndexEntry tailEntry = this.sourceIndex.getLastForSource(source);
        IndexEntry headEntry = this.sourceIndex.getListForSource(source);
        return new OpenSourceCursor(this, headEntry, tailEntry, null);
    }

    synchronized Cursor<BAlarmSource> getAlarmSources(Context cx) {
        return new AlarmSourceCursor(this, cx);
    }

    public synchronized Cursor<BAlarmRecord> getOpenAlarms() {
        IndexEntry startEntry = this.openIndex.getFirstEntry();
        return new OpenCursor(this, startEntry, null);
    }

    synchronized Cursor<BAlarmRecord> getAckPendingAlarms() {
        IndexEntry startEntry = this.ackPendingIndex.getFirstEntry();
        return new AckPendingCursor(this, startEntry, null);
    }

    private synchronized int[] takePages(int count) throws IOException {
        if (this.recPages == null || this.recPages.length < count) {
            this.recPages = new int[count];
        }
        for (int i = 0; i < count; ++i) {
            this.recPages[i] = this.nextFreePage();
            this.freeMap.setFree(this.recPages[i], false);
        }
        return this.recPages;
    }

    private synchronized void freePageRun(int startIndex) throws IOException {
        int i = startIndex;
        do {
            Page p;
            if ((p = this.readPage(i)) == null) {
                return;
            }
            this.freeMap.setFree(i, true);
            i = p.getNextPage();
            p.clear();
        } while (i != -1);
    }

    private synchronized int nextFreePage() throws IOException {
        int freePage = this.freeMap.getFreePage();
        if (freePage == -1) {
            this.grow();
        }
        if ((freePage = this.freeMap.getFreePage()) == -1) {
            throw new IOException("Cannot allocate a new page.");
        }
        return freePage;
    }

    synchronized Page readPage(int pageIndex) throws IOException {
        int pagesPerBlock = this.header.getPagesPerBlock();
        int blockIndex = pageIndex / pagesPerBlock;
        int blockPage = pageIndex - blockIndex * pagesPerBlock;
        return this.getBlock(blockIndex).getPage(blockPage);
    }

    private synchronized void grow() throws IOException {
        int pageSize = this.header.getPageSize();
        int pagesPerBlock = this.header.getPagesPerBlock();
        int blockSize = pageSize * pagesPerBlock;
        int blockIndex = (int)((this.io.length() - this.header.getDataOffset()) / (long)blockSize);
        Block newBlock = new Block(this, blockIndex);
        newBlock.clear();
        this.io.seek(this.io.length());
        newBlock.write(this.io);
        this.freeMap.addFreePages(this.header.getPagesPerBlock());
    }

    private synchronized Block getBlock(int blockIndex) throws IOException {
        Block block = this.blockCache.getBlock(blockIndex);
        if (block == null) {
            block = this.readBlock(blockIndex);
            this.blockCache.add(block);
        }
        return block;
    }

    private synchronized Block readBlock(int blockIndex) throws IOException {
        Block block = new Block(this, blockIndex);
        long blockLocation = this.header.getDataOffset() + (long)(blockIndex * block.getSize());
        this.io.seek(blockLocation);
        block.read(this.io);
        return block;
    }

    synchronized void writeBlock(Block block) throws IOException {
        if (!block.isDirty()) {
            return;
        }
        int blockIndex = block.getIndex();
        long blockLocation = this.header.getDataOffset() + (long)(blockIndex * block.getSize());
        this.io.seek(blockLocation);
        block.write(this.io);
    }

    private BAlarmRecord readRecord(int pageIndex, BAlarmRecord rec) throws IOException {
        return this.readRecord(pageIndex, rec, null);
    }

    synchronized BAlarmRecord readRecord(int pageIndex, BAlarmRecord rec, FreePageMap freeMap) throws IOException {
        if (rec == null) {
            rec = new BAlarmRecord(BUuid.DEFAULT);
        }
        if (this.reader == null) {
            this.reader = new PageReader(this, pageIndex);
        } else {
            this.reader.init(pageIndex);
        }
        try {
            rec.read(this.reader, BAlarmRecord.ALARM_STORE_CX);
        }
        catch (Exception e) {
            BAlarmDatabase.log.log(Level.SEVERE, "Unable to read record", e);
            return null;
        }
        BUuid checkUuid = (BUuid)BUuid.DEFAULT.decode((DataInput)this.reader);
        if (!rec.getUuid().equals((Object)checkUuid)) {
            BAlarmDatabase.log.log(Level.SEVERE, "Read record failed: record UUID (" + rec.getUuid() + ") does not match check UUID (" + checkUuid + ')');
            return null;
        }
        if (freeMap != null) {
            int pageCount = this.reader.getPageCount();
            for (int i = 0; i < pageCount; ++i) {
                freeMap.setFree(this.reader.getPageIndex(i), false);
            }
        }
        return rec;
    }

    synchronized void trimToCapacity() throws IOException {
        if (this.timestampIndex.getSize() > this.capacity) {
            if (this.trimRec == null) {
                this.trimRec = new BAlarmRecord(BUuid.make());
            }
            while (this.timestampIndex.getSize() > this.capacity) {
                this.remove(this.timestampIndex.getFirstEntry(), this.trimRec);
            }
        }
    }

    public synchronized void clearAllRecords(Context cx) throws IOException {
        if (!this.hasDeletePermissions(cx)) {
            BAlarmDatabase.log.log(Level.INFO, "This user can't delete records from the DB.");
            return;
        }
        this.close();
        if (this.alarmService != null) {
            BAlarmClass[] acs;
            for (BAlarmClass ac : acs = (BAlarmClass[])this.alarmService.getChildren(BAlarmClass.class)) {
                ac.setTotalAlarmCount(0);
                ac.setUnackedAlarmCount(0);
                ac.setOpenAlarmCount(0);
                ac.setInAlarmCount(0);
            }
        }
        boolean deleted = AccessController.doPrivileged(() -> this.alarmFile.delete());
        this.open();
        if (!deleted) {
            throw new IOException("Cannot delete alarm history file: " + this.alarmFile.getAbsolutePath());
        }
    }

    public synchronized void clearOldRecords(BAbsTime before, Context cx) throws IOException {
        if (!this.hasDeletePermissions(cx)) {
            BAlarmDatabase.log.log(Level.INFO, "This user can't delete records from the DB.");
            return;
        }
        if (this.timestampIndex.getSize() == 0) {
            return;
        }
        BAlarmRecord rec = new BAlarmRecord(BUuid.make());
        while (this.timestampIndex.getSize() > 0) {
            IndexEntry entry = this.timestampIndex.getFirstEntry();
            if (!entry.timestamp.isBefore(before)) break;
            this.remove(entry, rec);
        }
    }

    public synchronized void clearRecord(BUuid uuid, Context cx) throws IOException {
        if (!this.hasDeletePermissions(cx)) {
            BAlarmDatabase.log.log(Level.INFO, "This user can't delete records from the DB.");
            return;
        }
        if (this.byUuid.isEmpty()) {
            return;
        }
        BAlarmRecord rec = new BAlarmRecord(BUuid.make());
        IndexEntry entry = this.byUuid.get(uuid);
        if (entry != null) {
            this.remove(entry, rec);
        }
    }

    private boolean hasDeletePermissions(Context cx) {
        BUser user = cx != null ? cx.getUser() : null;
        return user == null || this.alarmService == null || user.getPermissionsFor((BIProtected)this.alarmService).hasAdminInvoke();
    }

    public void analyze(PrintStream out) {
        DecimalFormat fileSizeFormat = new DecimalFormat("###,###,###,###");
        DecimalFormat doubleFormat = new DecimalFormat("###,###,###.##");
        DecimalFormat intFormat = new DecimalFormat("###,###,###");
        long length = AccessController.doPrivileged(() -> this.alarmFile.length());
        out.println("db file     : " + this.alarmFile.getAbsolutePath());
        out.println("file size   : " + fileSizeFormat.format(length));
        out.println("capacity    : " + this.capacity);
        out.println("record count: " + this.byUuid.size());
        out.println("free map    : " + this.freeMap.getPageCount() + " pages (" + this.freeMap.getFreeCount() + " free), " + intFormat.format(this.freeMap.getSizeInBytes()) + " bytes");
        out.println("-------");
        out.println("Indexes");
        out.println("alarmSourceIndex size : " + this.sourceIndex.getSize());
        out.println("openIndex size        : " + this.openIndex.getSize());
        out.println("ackPendingIndex size  : " + this.ackPendingIndex.getSize());
        this.timestampIndex.analyze("timestamp index", out);
        out.println();
        int nonListBytes = this.timestampIndex.getSize() * 21;
        out.println("non-list entry ram: " + doubleFormat.format((double)nonListBytes / 1024.0 / 1024.0) + " MB");
    }

    private static class AlarmCount {
        int openCount = 0;
        int openAckCount = 0;
        int openUnackCount = 0;
        int openAckPendingCount = 0;

        AlarmCount() {
        }

        boolean empty() {
            return this.openCount + this.openAckPendingCount + this.openAckCount + this.openUnackCount == 0;
        }

        void checkCounts() {
            if (this.openCount < 0) {
                BAlarmDatabase.log.warning(String.format("Current number of open alarms is negative (%d)", this.openCount));
            }
            if (this.openAckCount < 0) {
                BAlarmDatabase.log.warning(String.format("Current number of open acknowledged alarms is negative (%d)", this.openAckCount));
            }
            if (this.openUnackCount < 0) {
                BAlarmDatabase.log.warning(String.format("Current number of open unacknowledged alarms is negative (%d)", this.openUnackCount));
            }
            if (this.openAckPendingCount < 0) {
                BAlarmDatabase.log.warning(String.format("Current number of open acknowledged pending alarms is negative (%d)", this.openAckPendingCount));
            }
        }
    }

    private static class AckPendingCursor
    extends AlarmStoreCursor {
        AckPendingCursor(AlarmStore store, IndexEntry start, BAbsTime end) {
            super(store, start, end);
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            return entry.nextAckPending;
        }
    }

    private static class OpenCursor
    extends AlarmStoreCursor {
        OpenCursor(AlarmStore store, IndexEntry start, BAbsTime end) {
            super(store, start, end);
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            return entry.nextOpen;
        }

        @Override
        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return null;
        }
    }

    private static class ReverseOpenSourceCursor
    extends SourceCursor {
        private final AlarmStore cursorStore;
        private final IndexEntry head;
        private final IndexEntry tail;
        private final BAbsTime endTime;

        ReverseOpenSourceCursor(AlarmStore store, IndexEntry start, IndexEntry finish, BAbsTime end) {
            super(store, start, finish, end);
            this.cursorStore = store;
            this.head = start;
            this.tail = finish;
            this.endTime = end;
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            IndexEntry temp = null;
            if (entry != null) {
                temp = entry.prevSource;
            }
            while (temp != null && !temp.isOpen()) {
                temp = temp.prevSource;
            }
            return temp;
        }

        @Override
        public boolean advanceCursor() {
            boolean advanced = super.advanceCursor();
            while (this.rec != null && !this.rec.isOpen()) {
                advanced = super.advanceCursor();
            }
            return advanced;
        }

        @Override
        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return new OpenSourceCursor(this.cursorStore, this.tail, this.head, this.endTime);
        }
    }

    private static class OpenSourceCursor
    extends SourceCursor {
        private final AlarmStore cursorStore;
        private final IndexEntry head;
        private final IndexEntry tail;
        private final BAbsTime endTime;

        OpenSourceCursor(AlarmStore store, IndexEntry start, IndexEntry finish, BAbsTime end) {
            super(store, start, finish, end);
            this.cursorStore = store;
            this.head = start;
            this.tail = finish;
            this.endTime = end;
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            IndexEntry temp = null;
            if (entry != null) {
                temp = entry.nextSource[0];
            }
            while (temp != null && !temp.isOpen()) {
                temp = temp.nextSource[0];
            }
            return temp;
        }

        @Override
        public boolean advanceCursor() {
            while (this.init && this.entry != null && !this.entry.isOpen()) {
                this.entry = this.nextEntry(this.entry);
            }
            return super.advanceCursor();
        }

        @Override
        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return new ReverseOpenSourceCursor(this.cursorStore, this.tail, this.head, this.endTime);
        }
    }

    private static class SourceReverseCursor
    extends AlarmStoreCursor {
        private final AlarmStore cursorStore;
        private final IndexEntry start;
        private final IndexEntry finish;
        private final BAbsTime end;

        SourceReverseCursor(AlarmStore store, IndexEntry start, IndexEntry finish, BAbsTime end) {
            super(store, finish, end);
            this.cursorStore = store;
            this.start = start;
            this.finish = finish;
            this.end = end;
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            if (entry.prevSource == null) {
                return null;
            }
            return entry.prevSource;
        }

        @Override
        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return new SourceCursor(this.cursorStore, this.start, this.finish, this.end);
        }
    }

    private static class SourceCursor
    extends AlarmStoreCursor {
        private final AlarmStore cursorStore;
        private final IndexEntry head;
        private final IndexEntry tail;
        private final BAbsTime end;

        SourceCursor(AlarmStore store, IndexEntry start, IndexEntry tail, BAbsTime end) {
            super(store, start, end);
            this.cursorStore = store;
            this.head = start;
            this.end = end;
            this.tail = tail;
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            if (entry.nextSource == null) {
                return null;
            }
            return entry.nextSource[0];
        }

        @Override
        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return new SourceReverseCursor(this.cursorStore, this.head, this.tail, this.end);
        }
    }

    private static class TimestampCursor
    extends AlarmStoreCursor {
        TimestampCursor(AlarmStore store, IndexEntry start, BAbsTime end) {
            super(store, start, end);
        }

        @Override
        public IndexEntry nextEntry(IndexEntry entry) {
            if (entry.nextTimestamp == null) {
                return null;
            }
            return entry.nextTimestamp[0];
        }
    }

    private static abstract class AlarmStoreCursor
    extends AbstractReverseCursor<BAlarmRecord> {
        protected boolean init = true;
        private final AlarmStore store;
        protected IndexEntry entry;
        protected BAlarmRecord rec;
        private BAbsTime endTime;
        private final BUser user;
        private final Map<String, BAlarmClass> alarmClasses = new HashMap<String, BAlarmClass>();

        AlarmStoreCursor(AlarmStore store, IndexEntry start, BAbsTime end) {
            this.store = store;
            this.entry = start;
            this.rec = new BAlarmRecord(BUuid.make());
            this.user = BUser.getCurrentAuthenticatedUser();
            this.endTime = end;
            if (this.endTime != null && this.endTime.isNull()) {
                this.endTime = null;
            }
        }

        protected BAlarmRecord doGet() {
            if (this.init) {
                throw new IllegalStateException("get() before next()");
            }
            if (this.entry != null) {
                return this.rec;
            }
            return null;
        }

        protected boolean advanceCursor() {
            BAlarmClass alarmClass;
            BPermissions perms;
            if (this.entry == null) {
                return false;
            }
            do {
                if (this.init) {
                    this.init = false;
                    if (!this.loadRecord()) {
                        return false;
                    }
                    if (this.endTime != null && this.rec.getTimestamp().isAfter(this.endTime)) {
                        this.entry = null;
                        return false;
                    }
                } else {
                    this.entry = this.nextEntry(this.entry);
                    if (this.entry != null && this.entry.pageIndex >= 0) {
                        if (!this.loadRecord()) {
                            return false;
                        }
                        if (this.endTime != null && this.rec.getTimestamp().isAfter(this.endTime)) {
                            this.entry = null;
                            return false;
                        }
                    } else {
                        this.rec = null;
                        return false;
                    }
                }
                if (this.user == null) break;
                String className = this.rec.getAlarmClass();
                alarmClass = this.alarmClasses.get(className);
                if (alarmClass != null) continue;
                alarmClass = this.store.alarmService.lookupAlarmClass(className);
                this.alarmClasses.put(className, alarmClass);
            } while (!(perms = this.user.getPermissionsFor((BIProtected)alarmClass)).hasOperatorRead());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadRecord() {
            try {
                AlarmStore alarmStore = this.store;
                synchronized (alarmStore) {
                    if (this.store.io == null) {
                        throw new IllegalStateException("Alarm database is closed.");
                    }
                    if (-1 == this.store.readPage(this.entry.pageIndex).getPageOfRecord()) {
                        return false;
                    }
                    BAlarmRecord record = this.store.readRecord(this.entry.pageIndex, this.rec);
                    if (record == null) {
                        return false;
                    }
                    if (!record.getTimestamp().equals((Object)this.entry.timestamp)) {
                        return false;
                    }
                }
            }
            catch (Exception ex) {
                BAlarmDatabase.log.log(Level.SEVERE, "Unable to read record", ex);
                return false;
            }
            return true;
        }

        public AbstractReverseCursor<BAlarmRecord> getReverseCursor() {
            return null;
        }

        protected abstract IndexEntry nextEntry(IndexEntry var1);
    }

    public class AlarmSourceCursor
    extends AbstractCursor<BAlarmSource> {
        AlarmStore store;
        BAlarmRecord rec;
        private final Cursor<BAlarmSource> sources;

        AlarmSourceCursor(AlarmStore store, Context cx) {
            this.store = store;
            this.rec = new BAlarmRecord(BUuid.make());
            ArrayList<BAlarmSource> sources = new ArrayList<BAlarmSource>();
            for (BOrdList ord : AlarmStore.this.sourceIndex.getTable().keySet()) {
                BAlarmRecord record;
                IndexEntry indexEntry = AlarmStore.this.sourceIndex.getLastForSource(ord);
                if (indexEntry.pageIndex == -1 || (record = this.loadRecord(indexEntry)) == null) continue;
                sources.add(new BAlarmSource(ord, (BAlarmRecord)record.newCopy()));
            }
            this.sources = new BObjectArrayCursor((BObject[])sources.toArray(EMPTY_ALARM_SOURCE_ARRAY), cx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BAlarmRecord loadRecord(IndexEntry entry) {
            try {
                AlarmStore alarmStore = this.store;
                synchronized (alarmStore) {
                    if (this.store.io == null) {
                        throw new IllegalStateException("Alarm database is closed.");
                    }
                    if (-1 == this.store.readPage(entry.pageIndex).getPageOfRecord()) {
                        return null;
                    }
                    return this.store.readRecord(entry.pageIndex, this.rec);
                }
            }
            catch (Exception ex) {
                BAlarmDatabase.log.log(Level.SEVERE, "Unable to read record", ex);
                return null;
            }
        }

        protected BAlarmSource doGet() {
            return (BAlarmSource)((Object)this.sources.get());
        }

        public Context getContext() {
            return this.sources.getContext();
        }

        protected boolean advanceCursor() {
            boolean foundOpen = false;
            while (!foundOpen && this.sources.next()) {
                BAlarmSource current = (BAlarmSource)((Object)this.sources.get());
                foundOpen = current.getCurrentAlarm() != null;
            }
            return foundOpen;
        }

        protected void closeCursor() {
            this.sources.close();
        }
    }

    private class OpenPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private OpenPrivilegedAction() {
        }

        @Override
        public Object run() throws IOException {
            AlarmStore.this.byUuid = new HashMap();
            AlarmStore.this.currentCounts = new HashMap();
            AlarmStore.this.timestampIndex = new TimestampIndex(0.5, 250000);
            AlarmStore.this.sourceIndex = new AlarmSourceIndex(0.5, 10000);
            AlarmStore.this.openIndex = new OpenIndex();
            AlarmStore.this.ackPendingIndex = new AckPendingIndex();
            AlarmStore.this.blockCache = new BlockCache(AlarmStore.this, 10);
            AlarmStore.this.io = new RandomAccessFile(AlarmStore.this.alarmFile, "rw");
            try {
                if (AlarmStore.this.io.length() == 0L) {
                    AlarmStore.this.create();
                } else {
                    AlarmStore.this.init();
                }
            }
            catch (IOException | RuntimeException e) {
                AlarmStore.this.io.close();
                AlarmStore.this.io = null;
                throw e;
            }
            AlarmStore.this.writeBuf = new ByteBuffer(AlarmStore.this.header.getPageSize());
            return null;
        }
    }
}

