/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.AlarmUtil;
import com.tridium.sys.Nre;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public interface BIAlarmRecordDecorator
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BIAlarmRecordDecorator.class);
    public static final Set<BTypeSpec> TRUSTED_ALARM_RECORD_DECORATORS = Collections.unmodifiableSet(Stream.of(BTypeSpec.make((String)"niagaraDriver:NiagaraVirtualNetworkExt")).collect(Collectors.toSet()));

    default public void decorateOnReadStart(BAlarmRecord alarmRecord, Context context) {
    }

    public void decorateOnReadEnd(BAlarmRecord var1, Context var2);

    public BAlarmRecord undecorateOnWriteStart(BAlarmRecord var1, Context var2);

    default public void redecorateOnWriteEnd(BAlarmRecord alarmRecord, Context context) {
    }

    public static void decorateAllOnReadStart(BAlarmRecord alarmRecord, Context context) {
        for (BIAlarmRecordDecorator decorator : AlarmUtil.DECORATORS) {
            decorator.decorateOnReadStart(alarmRecord, context);
        }
    }

    public static void decorateAllOnReadEnd(BAlarmRecord alarmRecord, Context context) {
        for (BIAlarmRecordDecorator decorator : AlarmUtil.DECORATORS) {
            decorator.decorateOnReadEnd(alarmRecord, context);
        }
    }

    public static BAlarmRecord undecorateAllOnWriteStart(BAlarmRecord alarmRecord, Context context) {
        for (BIAlarmRecordDecorator decorator : AlarmUtil.DECORATORS) {
            alarmRecord = decorator.undecorateOnWriteStart(alarmRecord, context);
        }
        return alarmRecord;
    }

    public static void redecorateAllOnWriteEnd(BAlarmRecord alarmRecord, Context context) {
        for (BIAlarmRecordDecorator decorator : AlarmUtil.DECORATORS) {
            decorator.redecorateOnWriteEnd(alarmRecord, context);
        }
    }

    public static void registerAlarmRecordDecorator(BIAlarmRecordDecorator decorator) {
        Objects.requireNonNull(decorator, "Cannot register a null alarm record decorator");
        if (!TRUSTED_ALARM_RECORD_DECORATORS.contains(decorator.getType().getTypeSpec())) {
            throw new IllegalStateException("Cannot register an untrusted alarm record decorator: " + decorator.getType());
        }
        AlarmUtil.DECORATORS.add(decorator);
        if (Nre.spySysManagers.find("alarmRecordDecorators") == null) {
            Nre.spySysManagers.add("alarmRecordDecorators", (Spy)new AlarmUtil.AlarmRecordDecoratorSpyPage());
        }
    }

    public static boolean unregisterAlarmRecordDecorator(BIAlarmRecordDecorator decorator) {
        return AlarmUtil.DECORATORS.remove(decorator);
    }
}

