/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.point;

import com.tridium.util.ComponentTreeCursor;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.obix.driver.point.BObixPointDiscoveryJob;
import javax.baja.obix.driver.point.BObixPointFolder;
import javax.baja.obix.driver.point.BObixProxyExt;
import javax.baja.obix.driver.util.BObixSubscription;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;
import obix.net.ObixSession;
import obix.net.SessionWatch;
import obix.net.WatchListener;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="watchInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(2)", facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.TRUE")}), @NiagaraProperty(name="watchUri", type="String", defaultValue="BString.make(\"\")", flags=1), @NiagaraProperty(name="debugWatch", type="boolean", defaultValue="false")})
@NiagaraActions(value={@NiagaraAction(name="getClient", returnType="BOrd", flags=4), @NiagaraAction(name="read", flags=20), @NiagaraAction(name="submitPointDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="subscribe", flags=20), @NiagaraAction(name="refreshWatch", flags=16), @NiagaraAction(name="forceUpdate", flags=24), @NiagaraAction(name="write", flags=20)})
public class BObixPointDeviceExt
extends BPointDeviceExt
implements WatchListener {
    @Generated
    public static final Property watchInterval = BObixPointDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)2), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property watchUri = BObixPointDeviceExt.newProperty((int)1, (BValue)BString.make((String)""), null);
    @Generated
    public static final Property debugWatch = BObixPointDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action getClient = BObixPointDeviceExt.newAction((int)4, null);
    @Generated
    public static final Action read = BObixPointDeviceExt.newAction((int)20, null);
    @Generated
    public static final Action submitPointDiscoveryJob = BObixPointDeviceExt.newAction((int)4, null);
    @Generated
    public static final Action subscribe = BObixPointDeviceExt.newAction((int)20, null);
    @Generated
    public static final Action refreshWatch = BObixPointDeviceExt.newAction((int)16, null);
    @Generated
    public static final Action forceUpdate = BObixPointDeviceExt.newAction((int)24, null);
    @Generated
    public static final Action write = BObixPointDeviceExt.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixPointDeviceExt.class);
    public static final double REFRESH_SAFETY_FACTOR = 0.75;
    static final Context verifyPtsSubsCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1009;
        }

        public String toString() {
            return "obixDriver:verifyPtsSubs";
        }
    };
    static final Context verifyPtsWatchCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1013;
        }

        public String toString() {
            return "obixDriver:verifyPtsWatch";
        }
    };
    static final Context forceCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1019;
        }

        public String toString() {
            return "obixDriver:force";
        }
    };
    static final Context pollCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1021;
        }

        public String toString() {
            return "obixDriver:poll";
        }
    };
    static final Context readSubscribedCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1031;
        }

        public String toString() {
            return "obixDriver:readSubscribed";
        }
    };
    static final Context staleCx = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return 1033;
        }

        public String toString() {
            return "obixDriver:stale";
        }
    };
    private boolean attached;
    private boolean batchWorks = true;
    private ObixEncoder debugger;
    private Logger log;
    private final Object mutexRead = new Object();
    private final Object mutexSubscribe = new Object();
    private final Object mutexUnsubscribe = new Object();
    private final Object mutexWrite = new Object();
    private final Object mutexWatch = new Object();
    private TreeMap<String, BObixProxyExt> pendingRead = new TreeMap();
    private HashSet<BObixProxyExt> pendingSubscribe = new HashSet();
    private TreeMap<String, BObixProxyExt> pendingUnsubscribe = new TreeMap();
    private TreeMap<String, BObixProxyExt> pendingWrite = new TreeMap();
    private volatile boolean reading;
    private volatile boolean subscribing;
    private int addsCount;
    private final SortedMap<String, BObixProxyExt> subscriptions = Collections.synchronizedSortedMap(new TreeMap());
    private SessionWatch watch;
    private Logger sublog;
    Clock.Ticket refreshTicket = Clock.expiredTicket;
    private long refreshPeriod = 3600000L;

    @Generated
    public BRelTime getWatchInterval() {
        return (BRelTime)this.get(watchInterval);
    }

    @Generated
    public void setWatchInterval(BRelTime v) {
        this.set(watchInterval, (BValue)v, null);
    }

    @Generated
    public String getWatchUri() {
        return this.getString(watchUri);
    }

    @Generated
    public void setWatchUri(String v) {
        this.setString(watchUri, v, null);
    }

    @Generated
    public boolean getDebugWatch() {
        return this.getBoolean(debugWatch);
    }

    @Generated
    public void setDebugWatch(boolean v) {
        this.setBoolean(debugWatch, v, null);
    }

    @Generated
    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    @Generated
    public void read() {
        this.invoke(read, null, null);
    }

    @Generated
    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    @Generated
    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    @Generated
    public void refreshWatch() {
        this.invoke(refreshWatch, null, null);
    }

    @Generated
    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    @Generated
    public void write() {
        this.invoke(write, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void attach() {
        this.updateRefreshPeriod();
        this.attached = true;
        this.subscribe();
        this.read();
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(watchInterval)) {
            try {
                Object object = this.mutexWatch;
                synchronized (object) {
                    if (this.watch != null) {
                        long millis = this.getWatchInterval().getMillis();
                        long lease = this.watch.getLease();
                        long safeLease = Math.max(millis * 2L, lease + this.getObixClient().getWatchSafetyFactor().getMillis());
                        this.watch.setLease(safeLease);
                        this.watch.setPollPeriod(millis);
                    }
                }
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("obix", "Invalid watch interval:" + this.getWatchInterval(), (Throwable)e);
            }
        }
    }

    public void changed(Obj obj) {
        this.debug(obj);
        Uri uri = obj.getHref();
        if (uri == null) {
            return;
        }
        String href = uri.get();
        BObixProxyExt ext = (BObixProxyExt)this.subscriptions.get(href);
        if (ext != null) {
            ext.readOk(obj);
        } else {
            this.getLogger().info("No recipient for " + href + '(' + obj.toDisplayString() + ')');
        }
        this.getObixClient().pingOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(SessionWatch toClose) {
        String watchHref = toClose != null ? toClose.getWatchObj().getHref().get() : "null";
        Object object = this.mutexWatch;
        synchronized (object) {
            if (toClose == this.watch) {
                this.watch = null;
                this.setWatchUri("");
                this.getLogger().info("Watch closed " + watchHref + " on " + BObixPointDeviceExt.thd());
                BObixClient client = this.getObixClient();
                client.doPing();
                if (client.getState().isEngaged()) {
                    ArrayList<BObixProxyExt> tmp = new ArrayList<BObixProxyExt>(this.subscriptions.values());
                    this.detach();
                    Object object2 = this.mutexSubscribe;
                    synchronized (object2) {
                        for (BObixProxyExt bObixProxyExt : tmp) {
                            bObixProxyExt.setSubscription(BObixSubscription.pending);
                        }
                        this.pendingSubscribe.addAll(tmp);
                    }
                    this.attach();
                }
            } else {
                this.getLogger().warning("Unknown watch closed " + watchHref);
            }
        }
    }

    public void detach() {
        this.detach(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(boolean keepSubs) {
        if (this.sublog.isLoggable(Level.FINE)) {
            this.sublog.log(Level.FINE, "detach(" + keepSubs + ") on Points in " + (Object)((Object)this.getObixClient()) + ":: kill watch " + this.watch, this.getSubDebug() ? new Throwable() : null);
        }
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (keepSubs) {
                ArrayList<BObixProxyExt> tmp = new ArrayList<BObixProxyExt>(this.subscriptions.values());
                for (BObixProxyExt bObixProxyExt : tmp) {
                    bObixProxyExt.setSubscription(BObixSubscription.pending);
                }
                this.pendingSubscribe.addAll(tmp);
            } else {
                this.pendingSubscribe.clear();
            }
        }
        this.subscriptions.clear();
        object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.clear();
        }
        object = this.mutexWatch;
        synchronized (object) {
            if (this.watch != null) {
                this.watch.delete();
                this.watch = null;
                this.refreshTicket.cancel();
                this.refreshPeriod = 3600000L;
                this.setWatchUri("");
            }
        }
        this.attached = false;
    }

    public void doDumpSubs() {
        this.doDumpSubs(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doPrintSubs() {
        SortedMap<String, BObixProxyExt> sortedMap = this.mutexSubscribe;
        synchronized (sortedMap) {
            System.out.println("pendingSubscribe:" + this.pendingSubscribe.size());
            for (BObixProxyExt bObixProxyExt : this.pendingSubscribe) {
                System.out.println(bObixProxyExt);
            }
        }
        sortedMap = this.mutexUnsubscribe;
        synchronized (sortedMap) {
            System.out.println("pendingUnsubscribe:" + this.pendingUnsubscribe.size());
            for (BObixProxyExt bObixProxyExt : this.pendingSubscribe) {
                System.out.println(bObixProxyExt);
            }
        }
        sortedMap = this.mutexRead;
        synchronized (sortedMap) {
            System.out.println("pendingRead:" + this.pendingRead.size());
            for (BObixProxyExt bObixProxyExt : this.pendingSubscribe) {
                System.out.println(bObixProxyExt);
            }
        }
        sortedMap = this.mutexWrite;
        synchronized (sortedMap) {
            System.out.println("pendingWrite:" + this.pendingWrite.size());
            for (BObixProxyExt bObixProxyExt : this.pendingSubscribe) {
                System.out.println(bObixProxyExt);
            }
        }
        sortedMap = this.subscriptions;
        synchronized (sortedMap) {
            System.out.println("subscriptions:" + this.subscriptions.size());
            for (String k : this.subscriptions.keySet()) {
                BObixProxyExt v = (BObixProxyExt)this.subscriptions.get(k);
                System.out.println(k + "->" + v.toPathString());
            }
        }
    }

    public void doVerifyPoints() {
        if (!this.isRunning()) {
            return;
        }
        BControlPoint[] pts = this.getPoints();
        int unsubCnt = 0;
        int subCnt = 0;
        int ptSubNotInSubsCnt = 0;
        int ptSubNotInWatchCnt = 0;
        this.sublog.info("Verifying Points in subscription vs watch");
        if (this.attached && this.watch == null) {
            this.sublog.info("Watch is null, reattach");
            this.getObixClient().ping();
            this.closed(null);
            return;
        }
        for (BControlPoint pt : pts) {
            BObixProxyExt px = (BObixProxyExt)pt.getProxyExt();
            if (px.getSubscription().isSubscribed()) {
                ++subCnt;
                if (this.subscriptions.get(px.getHref()) == null) {
                    ++ptSubNotInSubsCnt;
                    this.sublog.info(px.toPathString() + " subscribed but not in subscriptions list - resubscribing");
                    this.subscribe(px, verifyPtsSubsCx);
                }
                Obj o = null;
                try {
                    o = this.watch.get(new Uri(px.getHref()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (o != null) continue;
                ++ptSubNotInWatchCnt;
                this.sublog.info(px.toPathString() + " subscribed but not in watch - resubscribing");
                this.subscribe(px, verifyPtsWatchCx);
                continue;
            }
            ++unsubCnt;
        }
        this.sublog.info("Verified proxy point subscriptions: subCnt=" + subCnt + "; unsubCnt=" + unsubCnt + "; ptSubNotInSubsCnt=" + ptSubNotInSubsCnt + "; ptSubNotInWatchCnt=" + ptSubNotInWatchCnt);
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRead() {
        Object object = this.mutexRead;
        synchronized (object) {
            if (this.reading) {
                return;
            }
            if (!this.isRunning()) {
                return;
            }
            if (!this.attached) {
                return;
            }
            this.reading = true;
        }
        try {
            this.performRead();
        }
        finally {
            boolean read = false;
            Object object2 = this.mutexRead;
            synchronized (object2) {
                this.reading = false;
                if (!this.pendingRead.isEmpty()) {
                    read = true;
                }
            }
            if (read) {
                this.read();
            }
        }
    }

    public BOrd doSubmitPointDiscoveryJob(Context cx) {
        return new BObixPointDiscoveryJob(this, this.getObixClient().get("lobby")).submit(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSubscribe() {
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("ds+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (this.subscribing) {
                return;
            }
            if (!this.isRunning()) {
                return;
            }
            if (!this.attached) {
                if (this.sublog.isLoggable(Level.FINE)) {
                    this.sublog.fine("Posting device ping to fix attach flag...");
                }
                this.getObixClient().ping();
                return;
            }
            this.subscribing = true;
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println(" doSubscribe: perform");
        }
        try {
            this.performUnsubscribe();
            this.performSubscribe();
        }
        finally {
            if (this.sublog.isLoggable(Level.FINE)) {
                System.out.println("doSubscribe: in finally, clear subscribing");
            }
            boolean sub = false;
            Object object2 = this.mutexSubscribe;
            synchronized (object2) {
                this.subscribing = false;
                if (!this.pendingSubscribe.isEmpty()) {
                    sub = true;
                }
            }
            object2 = this.mutexUnsubscribe;
            synchronized (object2) {
                if (!this.pendingUnsubscribe.isEmpty()) {
                    sub = true;
                }
            }
            if (sub) {
                this.subscribe();
            }
            if (this.sublog.isLoggable(Level.FINE)) {
                System.out.println("ds-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
            }
        }
    }

    public void doForceUpdate() {
        ComponentTreeCursor cur = new ComponentTreeCursor((BComponent)this, null);
        while (cur.next(BObixProxyExt.class)) {
            BObixProxyExt ext = (BObixProxyExt)cur.get();
            ext.doForceUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefreshWatch() {
        Object object = this.mutexWatch;
        synchronized (object) {
            int watchsize;
            int subsize = this.subscriptions.size();
            int n = watchsize = this.watch != null ? this.watch.size() : 0;
            if (subsize != watchsize) {
                this.sublog.warning("Subscription size (" + subsize + ") does not match expected watch size (" + watchsize + ")!");
                this.doVerifyPoints();
            }
            if (this.watch != null) {
                try {
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        this.getLogger().fine("refreshWatch! " + Clock.time().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
                    }
                    this.watch.pollRefresh();
                    if (!this.subscriptions.isEmpty()) {
                        long millis = Long.MAX_VALUE;
                        for (BObixProxyExt bObixProxyExt : this.subscriptions.values()) {
                            long ms = bObixProxyExt.getTuningPolicy().getStaleTime().getMillis();
                            if (ms <= 0L || ms >= millis) continue;
                            millis = ms;
                        }
                        if (millis == Long.MAX_VALUE) {
                            this.refreshTicket.cancel();
                        } else if ((long)((double)millis * 0.75) > this.refreshPeriod) {
                            this.refreshPeriod = (long)((double)millis * 0.75);
                            this.scheduleRefresh();
                        }
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.INFO, "Watch Poll Refresh failed on " + (Object)((Object)this) + " in " + (Object)((Object)this.getObixClient()), e);
                }
            }
        }
    }

    public void doWrite() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.attached) {
            return;
        }
        try {
            this.performWrite();
        }
        finally {
            if (!this.pendingWrite.isEmpty()) {
                this.write();
            }
        }
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public Logger getLogger() {
        if (this.log == null) {
            try {
                this.log = Logger.getLogger(this.getObixClient().getLogger().getName() + "-Points");
            }
            catch (Exception x) {
                this.log = this.getObixClient().getLogger();
            }
        }
        return this.log;
    }

    public Type getPointFolderType() {
        return BObixPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BObixProxyExt.TYPE;
    }

    Logger getSubLogger() {
        return this.sublog;
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (this.sublog.isLoggable(Level.FINE) && !BObixPointDeviceExt.thd().startsWith("Poll")) {
            System.out.println("### post(" + a + ") on " + BObixPointDeviceExt.thd());
        }
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(BObixProxyExt ext) {
        Object object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.put(ext.getHref(), ext);
        }
        this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(BObixProxyExt ext, Context cx) {
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("s1+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd() + '\t' + ext.toPathString() + '\t' + cx);
        }
        this.updateRefreshPeriod(ext.getTuningPolicy().getStaleTime());
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.add(ext);
        }
        this.subscribe();
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("s1-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String href, BObixProxyExt ext, Context cx) {
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("u1+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(href, ext);
        }
        this.subscribe();
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("u1-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
    }

    private void updateRefreshPeriod() {
        BControlPoint[] pts = this.getPoints();
        long millis = 3600000L;
        for (BControlPoint pt : pts) {
            long ptMillis = ((BProxyExt)pt.getProxyExt()).getTuningPolicy().getStaleTime().getMillis();
            if (ptMillis >= millis) continue;
            millis = ptMillis;
        }
        this.updateRefreshPeriod(BRelTime.make((long)millis));
    }

    public void updateRefreshPeriod(BRelTime newPeriod) {
        if (newPeriod == null) {
            return;
        }
        long newMillis = (long)((double)newPeriod.getMillis() * 0.75);
        if (newMillis == 0L) {
            return;
        }
        if (newMillis < this.refreshPeriod) {
            this.refreshPeriod = newMillis;
        }
    }

    private void scheduleRefresh() {
        if (!this.isRunning()) {
            return;
        }
        if (this.refreshPeriod > 0L) {
            this.refreshTicket.cancel();
            this.refreshTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.refreshPeriod), (Action)refreshWatch, null);
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            this.sublog.fine("scheduleRefresh: refreshPeriod=" + this.refreshPeriod + "; ticket=" + this.refreshTicket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BObixProxyExt ext, Context cx) {
        Object object = this.mutexWrite;
        synchronized (object) {
            this.pendingWrite.put(ext.getHref(), ext);
        }
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("ObixPointDeviceExt");
        out.prop((Object)"attached", this.attached);
        out.prop((Object)"batchWorks", this.batchWorks);
        out.prop((Object)"watch", (Object)this.watch);
        if (this.watch != null) {
            BObixPointDeviceExt.spy(this.watch, out);
        }
        out.prop((Object)"reading", this.reading);
        out.prop((Object)"subscribing", this.subscribing);
        out.prop((Object)"pendingRead", this.pendingRead.size());
        out.prop((Object)"pendingSubscribe", this.pendingSubscribe.size());
        out.prop((Object)"pendingUnsubscribe", this.pendingUnsubscribe.size());
        out.prop((Object)"pendingWrite", this.pendingWrite.size());
        out.prop((Object)"subscriptions", this.subscriptions.size());
        out.prop((Object)"refreshTicket", (Object)this.refreshTicket);
        out.prop((Object)"refreshPeriod", (double)this.refreshPeriod);
        out.prop((Object)"addsCount", this.addsCount);
        out.endProps();
        out.startTable(true);
        out.trTitle((Object)"Subscriptions", 2);
        out.w((Object)"<tr>").th((Object)"Href").th((Object)"ProxyExt").w((Object)"</tr>\n");
        SortedMap<String, BObixProxyExt> sortedMap = this.subscriptions;
        synchronized (sortedMap) {
            for (String k : this.subscriptions.keySet()) {
                BObixProxyExt v = (BObixProxyExt)this.subscriptions.get(k);
                out.tr((Object)k, (Object)v.toPathString());
            }
        }
        out.endTable();
        super.spy(out);
    }

    public void started() throws Exception {
        super.started();
        try {
            this.sublog = Logger.getLogger(this.getObixClient().getLogger().getName() + "-Subscription");
        }
        catch (Exception x) {
            this.sublog = Logger.getLogger("obix.subscription");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.refreshTicket.cancel();
    }

    protected Obj getForceObj(Obj obj) {
        return obj;
    }

    protected Uri getFullNormalizedHref(Op op, Obj obj) {
        if (op == null || op.getHref() == null) {
            return null;
        }
        return op.getNormalizedHref();
    }

    protected BRelTime getRefreshPeriod() {
        return BRelTime.make((long)this.refreshPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRead() {
        TreeMap<String, BObixProxyExt> tmp = null;
        Object object = this.mutexRead;
        synchronized (object) {
            if (!this.pendingRead.isEmpty()) {
                tmp = this.pendingRead;
                this.pendingRead = new TreeMap();
            }
        }
        if (tmp != null) {
            Iterator<BObixProxyExt> i = tmp.values().iterator();
            BObixProxyExt ext = null;
            while (i.hasNext()) {
                try {
                    ext = i.next();
                    Obj o = this.getObixClient().obixRead(new Uri(ext.getHref()));
                    ext.readOk(o);
                    this.getDevice().pingOk();
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, "Read failed: " + ext.toPathString(), x);
                    ext.readFail(x.getMessage());
                }
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performSubscribe() {
        Object sub0;
        HashSet<BObixProxyExt> tmp = null;
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("ps+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
        this.scheduleRefresh();
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (!this.pendingSubscribe.isEmpty()) {
                tmp = this.pendingSubscribe;
                this.pendingSubscribe = new HashSet();
            }
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            sub0 = "sub0:--";
            if (tmp != null && !tmp.isEmpty()) {
                sub0 = "sub0:" + (Object)((Object)tmp.iterator().next().getSubscription());
            }
            System.out.println("### performSubscribe after mutexSub: pSub=" + (tmp != null ? tmp.size() : 0) + "; w=" + this.watch + " w.s=" + (this.watch != null ? String.valueOf(this.watch.getSession()) : "null ") + (String)sub0 + " on " + BObixPointDeviceExt.thd());
        }
        if (tmp != null) {
            sub0 = this.mutexWatch;
            synchronized (sub0) {
                if (this.watch == null || this.watch.getSession() == null) {
                    try {
                        long millis = this.getWatchInterval().getMillis();
                        this.watch = this.getObixClient().makeWatch(this.getName(), millis, this);
                        long lease = this.watch.getLease();
                        long safeLease = Math.max(millis * 2L, lease + this.getObixClient().getWatchSafetyFactor().getMillis());
                        this.watch.setLease(safeLease);
                        this.watch.setPollPeriod(millis);
                        this.setWatchUri(this.watch.getWatchObj().getHref().get());
                        this.getLogger().info("Watch created " + this.getWatchUri());
                    }
                    catch (Exception x) {
                        this.getLogger().log(Level.SEVERE, "Watch creation failed", x);
                    }
                }
            }
            BObixProxyExt ext = null;
            Iterator<BObixProxyExt> i = tmp.iterator();
            Object object2 = this.mutexWatch;
            synchronized (object2) {
                if (this.watch == null) {
                    while (i.hasNext()) {
                        ext = i.next();
                        if (!ext.getSubscription().isPending()) continue;
                        ext.subscribeFailTryPolling("Could not create watch");
                    }
                } else {
                    block17: while (true) {
                        try {
                            while (i.hasNext()) {
                                ext = i.next();
                                BObixProxyExt e = (BObixProxyExt)this.subscriptions.get(ext.getHref());
                                if (e != null && e != ext) {
                                    ext.subscribeFail("Href already subscribed by " + e.toPathString());
                                    continue;
                                }
                                try {
                                    if (!ext.getSubscription().isPending() && !this.getObixClient().isTridiumServer().booleanValue()) continue block17;
                                    if (this.sublog.isLoggable(Level.FINE)) {
                                        System.out.println("adding " + ext.toPathString() + " [" + (Object)((Object)ext.getSubscription()) + "] to watch " + this.watch);
                                    }
                                    Obj obj = this.watch.add(new Uri(ext.getHref()));
                                    ++this.addsCount;
                                    this.getObixClient().pingOk();
                                    if (obj.isErr()) {
                                        ext.subscribeFail(ObixEncoder.toString((Obj)obj));
                                        this.subscriptions.remove(ext.getHref());
                                        this.retrySubscribe(ext, i);
                                        break block17;
                                    }
                                    this.subscriptions.put(obj.getHref().get(), ext);
                                    ext.subscribeOk();
                                    ext.readOk(obj);
                                    continue block17;
                                }
                                catch (ErrException x) {
                                    if (x.err.getHref().get().equals(ext.getHref())) {
                                        ext.subscribeFail(x.getMessage());
                                        this.subscriptions.remove(ext.getHref());
                                        continue;
                                    }
                                    ext.subscribeFail(x.getMessage());
                                    if (this.sublog.isLoggable(Level.FINE)) {
                                        this.doDumpSubs("tmp", tmp);
                                    }
                                    this.subscriptions.remove(ext.getHref());
                                    this.retrySubscribe(ext, i);
                                    break block17;
                                }
                                catch (Exception x) {
                                    ext.subscribeFail(x.toString());
                                    if (this.sublog.isLoggable(Level.FINE)) {
                                        this.doDumpSubs("tmp", tmp);
                                    }
                                    this.subscriptions.remove(ext.getHref());
                                    this.getLogger().severe("Error Subscribing " + ext.toPathString() + ": watch=" + this.watch + " w.session=" + (this.watch != null ? String.valueOf(this.watch.getSession()) : String.valueOf(null)) + " on thd " + BObixPointDeviceExt.thd());
                                    if (this.watch != null && this.watch.getSession() != null) continue;
                                    this.retrySubscribe(ext, i);
                                    break block17;
                                }
                            }
                            break;
                        }
                        catch (Exception x) {
                            if (ext != null) {
                                this.subscriptions.remove(ext.getHref());
                                ext.subscribeFail(x.toString());
                                this.getLogger().log(Level.SEVERE, "Subscribing " + ext.toPathString(), x);
                            }
                            break;
                        }
                    }
                }
            }
            tmp = null;
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("ps-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void performUnsubscribe() {
        TreeMap<String, BObixProxyExt> tmp = null;
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("pu+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            if (!this.pendingUnsubscribe.isEmpty()) {
                tmp = this.pendingUnsubscribe;
                this.pendingUnsubscribe = new TreeMap();
            }
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("### performUnsubscribe after mutexUnsub: pUnsub=" + (tmp != null ? tmp.size() : 0) + "; w=" + this.watch + " w.s=" + (this.watch != null ? String.valueOf(this.watch.getSession()) : String.valueOf(null)) + " on " + BObixPointDeviceExt.thd());
        }
        if (tmp != null) {
            void var4_8;
            Vector<Uri> v = new Vector<Uri>(tmp.size());
            for (String string : tmp.keySet()) {
                BObixProxyExt ext = tmp.get(string);
                if (this.subscriptions.get(string) != ext) continue;
                v.addElement(new Uri(string));
            }
            if (v.isEmpty()) {
                return;
            }
            Object[] toRemove = new Uri[v.size()];
            v.copyInto(toRemove);
            Object object2 = this.mutexWatch;
            synchronized (object2) {
                if (this.watch != null) {
                    try {
                        this.watch.remove((Uri[])toRemove);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            int n = toRemove.length;
            while (--var4_8 >= 0) {
                this.subscriptions.remove(toRemove[var4_8].get());
            }
            tmp = null;
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("pu-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performWrite() {
        TreeMap<String, BObixProxyExt> tmp = null;
        Object object = this.mutexWrite;
        synchronized (object) {
            if (!this.pendingWrite.isEmpty()) {
                tmp = this.pendingWrite;
                this.pendingWrite = new TreeMap();
            }
        }
        if (tmp != null) {
            BatchIn bin = null;
            if (this.batchWorks) {
                try {
                    bin = this.getObixClient().makeBatch();
                }
                catch (Exception x) {
                    this.getLogger().log(Level.SEVERE, this.toPathString() + " batch failure", x);
                    this.batchWorks = false;
                }
            }
            if (bin != null) {
                this.write(tmp, bin);
            } else {
                this.write(tmp);
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrySubscribe(BObixProxyExt ext, Iterator<BObixProxyExt> i) {
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("es+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.watch + '\t' + BObixPointDeviceExt.thd());
        }
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.add(ext);
            while (i.hasNext()) {
                ext = i.next();
                this.pendingSubscribe.add(ext);
            }
            this.pendingSubscribe.addAll(this.subscriptions.values());
        }
        object = this.mutexWatch;
        synchronized (object) {
            if (this.watch != null && this.watch.getSession() != null) {
                try {
                    this.watch.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.watch = null;
            this.refreshTicket.cancel();
            this.refreshPeriod = 3600000L;
            this.setWatchUri("");
        }
        if (this.sublog.isLoggable(Level.FINE)) {
            System.out.println("es-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + BObixPointDeviceExt.thd());
        }
    }

    private void debug(Obj obj) {
        if (!this.getDebugWatch()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = ObixEncoder.make((OutputStream)System.out, null);
            }
            System.out.println(this.toPathString() + " Points:");
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean getSubDebug() {
        try {
            Property p = this.getProperty("subDebug");
            if (p != null && p.getType().is(BBoolean.TYPE)) {
                return this.getBoolean(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void doDumpSubs(String name, Collection<BObixProxyExt> c) {
        System.out.println("pendingSubscribe:" + this.pendingSubscribe.size());
        System.out.println("pendingUnsubscribe:" + this.pendingUnsubscribe.size());
        System.out.println("pendingRead:" + this.pendingRead.size());
        System.out.println("pendingWrite:" + this.pendingWrite.size());
        System.out.println("subscriptions:" + this.subscriptions.size());
        if (c != null) {
            System.out.println(name + ':' + c.size());
        }
    }

    private static void spy(SessionWatch w, SpyWriter out) {
        out.prop((Object)"  w.size", w.size());
        ObixSession s = w.getSession();
        out.prop((Object)"  w.session", (Object)s);
        out.prop((Object)"  w.watchObj", (Object)w.getWatchObj().getHref());
        out.prop((Object)"  w.lease", (Object)String.valueOf(w.getLease()));
        out.prop((Object)"  w.pollPeriod", (Object)String.valueOf(w.getPollPeriod()));
        out.prop((Object)"  w.lastAttempt", (Object)String.valueOf(w.lastPollAttempt()));
        out.prop((Object)"  w.lastSuccess", (Object)String.valueOf(w.lastPollSuccess()));
    }

    private void write(TreeMap<String, BObixProxyExt> map) {
        Iterator<BObixProxyExt> i = map.values().iterator();
        BObixProxyExt ext = null;
        while (i.hasNext()) {
            ext = i.next();
            try {
                ext.performWrite();
            }
            catch (Exception x) {
                this.getLogger().log(Level.SEVERE, "Write failed: " + ext.toPathString(), x);
                ext.writeFail(x.toString());
            }
        }
    }

    private void write(TreeMap<String, BObixProxyExt> map, BatchIn bin) {
        Iterator<BObixProxyExt> i = map.values().iterator();
        BObixProxyExt ext2 = null;
        while (i.hasNext()) {
            ext2 = i.next();
            ext2.batchWrite(bin);
        }
        Obj[] res = null;
        try {
            if (this.getObixClient().getDebugRequests()) {
                bin.dump();
            }
            List response = bin.commit();
            if (this.getObixClient().getDebugResponses()) {
                response.dump();
            }
            res = response.list();
        }
        catch (Exception x) {
            String message = x.toString();
            for (BObixProxyExt ext2 : map.values()) {
                ext2.writeFail(message);
            }
            return;
        }
        int len = res.length;
        i = map.values().iterator();
        for (Obj re : res) {
            ext2 = i.next();
            ext2.batchWriteResult(re);
        }
    }

    private static String thd() {
        return Thread.currentThread().getName();
    }
}

