/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.alarm;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.alarm.BObixAlarmImport;
import javax.baja.obix.driver.alarm.BR2AlarmDeviceExt;
import javax.baja.obix.driver.point.BObixPointDeviceExt;
import javax.baja.obix.driver.point.BObixProxyExt;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;

@NiagaraType
public class BR2AlarmImport
extends BObixAlarmImport {
    @Generated
    public static final Type TYPE = Sys.loadType(BR2AlarmImport.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BR2AlarmDeviceExt;
    }

    @Override
    protected void setSource(BAlarmRecord rec, Obj obj) throws Exception {
        BString alarmSourceName = BString.make((String)(this.getObixClient().getName() + '-' + this.getName()));
        BOrdList sourceList = this.asSource();
        String hrf = this.getObixClient().getRelativeUri(obj.getHref()).get();
        BControlPoint pt = this.getSource(hrf);
        if (pt != null) {
            alarmSourceName = BString.make((String)(this.getObixClient().getName() + '-' + pt.getName()));
            sourceList = this.makeSource((BComponent)pt.getProxyExt());
        }
        rec.addAlarmFacet("sourceName", (BIDataValue)alarmSourceName);
        rec.setSource(sourceList);
    }

    @Override
    protected boolean shouldRoute(BAlarmRecord existing, BAlarmRecord incoming) {
        BString notifyType = (BString)incoming.getAlarmFacet("notifyType");
        return !existing.isAcknowledged() || notifyType == null || !"ack_notification".equals(notifyType.getString());
    }

    private BControlPoint getSource(String href) {
        if (href.indexOf(this.subscribedHref) == 0) {
            int ndx = href.indexOf(47, this.subscribedHref.length());
            ndx = href.indexOf(47, ndx + 1);
            if ((ndx = href.indexOf(47, ndx + 1)) >= 0) {
                BObixPointDeviceExt points = this.getObixClient().getPoints();
                href = "/obix/config" + href.substring(ndx);
                SlotCursor sc = points.getProperties();
                while (sc.next(BControlPoint.class)) {
                    BControlPoint pt = (BControlPoint)sc.get();
                    if (!(pt.getProxyExt() instanceof BObixProxyExt)) continue;
                    BObixProxyExt ext = (BObixProxyExt)pt.getProxyExt();
                    if ((href + '/').startsWith(ext.getHref())) {
                        return pt;
                    }
                    if (!ext.getHref().startsWith(href)) continue;
                    return pt;
                }
            }
        }
        return null;
    }
}

