/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.obix.driver.alarm.BObixAlarmDeviceExt;
import javax.baja.obix.driver.history.BObixHistoryDeviceExt;
import javax.baja.obix.driver.point.BObixPointDeviceExt;
import javax.baja.obix.driver.schedule.BObixScheduleDeviceExt;
import javax.baja.obix.driver.util.BObixPollScheduler;
import javax.baja.obix.driver.util.BObixState;
import javax.baja.security.BPassword;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Abstime;
import obix.Bool;
import obix.Enum;
import obix.Int;
import obix.Obj;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ObixSession;
import obix.net.SessionWatch;
import obix.net.WatchListener;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lobby", type="String", defaultValue="http://url/to/lobby/here", flags=64), @NiagaraProperty(name="authUser", type="String", defaultValue=""), @NiagaraProperty(name="authPass", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="debugResponses", type="boolean", defaultValue="false"), @NiagaraProperty(name="debugRequests", type="boolean", defaultValue="false"), @NiagaraProperty(name="pollScheduler", type="BObixPollScheduler", defaultValue="new BObixPollScheduler()"), @NiagaraProperty(name="state", type="BObixState", defaultValue="BObixState.detached", flags=67), @NiagaraProperty(name="alarms", type="BObixAlarmDeviceExt", defaultValue="new BObixAlarmDeviceExt()"), @NiagaraProperty(name="histories", type="BObixHistoryDeviceExt", defaultValue="new BObixHistoryDeviceExt()"), @NiagaraProperty(name="points", type="BObixPointDeviceExt", defaultValue="new BObixPointDeviceExt()"), @NiagaraProperty(name="schedules", type="BObixScheduleDeviceExt", defaultValue="new BObixScheduleDeviceExt()", flags=4), @NiagaraProperty(name="sessionTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(15)", flags=4, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="watchSafetyFactor", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.SHOW_SECONDS", value="true"), @Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(5)")})})
@NiagaraActions(value={@NiagaraAction(name="attach", flags=20), @NiagaraAction(name="detach", flags=20), @NiagaraAction(name="reattach", flags=16)})
public class BObixClient
extends BDevice {
    @Generated
    public static final Property lobby = BObixClient.newProperty((int)64, (String)"http://url/to/lobby/here", null);
    @Generated
    public static final Property authUser = BObixClient.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property authPass = BObixClient.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property debugResponses = BObixClient.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property debugRequests = BObixClient.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property pollScheduler = BObixClient.newProperty((int)0, (BValue)new BObixPollScheduler(), null);
    @Generated
    public static final Property state = BObixClient.newProperty((int)67, (BValue)BObixState.detached, null);
    @Generated
    public static final Property alarms = BObixClient.newProperty((int)0, (BValue)new BObixAlarmDeviceExt(), null);
    @Generated
    public static final Property histories = BObixClient.newProperty((int)0, (BValue)new BObixHistoryDeviceExt(), null);
    @Generated
    public static final Property points = BObixClient.newProperty((int)0, (BValue)new BObixPointDeviceExt(), null);
    @Generated
    public static final Property schedules = BObixClient.newProperty((int)4, (BValue)new BObixScheduleDeviceExt(), null);
    @Generated
    public static final Property sessionTimeout = BObixClient.newProperty((int)4, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)));
    @Generated
    public static final Property watchSafetyFactor = BObixClient.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true)), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)5))));
    @Generated
    public static final Action attach = BObixClient.newAction((int)20, null);
    @Generated
    public static final Action detach = BObixClient.newAction((int)20, null);
    @Generated
    public static final Action reattach = BObixClient.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixClient.class);
    private ObixEncoder debugger;
    private Uri lobbyUri;
    private ObixSession session;
    private BObixNetwork network;
    private boolean licenseChecked;
    private Boolean tridium;
    private final Object sync = new Object();

    @Generated
    public String getLobby() {
        return this.getString(lobby);
    }

    @Generated
    public void setLobby(String v) {
        this.setString(lobby, v, null);
    }

    @Generated
    public String getAuthUser() {
        return this.getString(authUser);
    }

    @Generated
    public void setAuthUser(String v) {
        this.setString(authUser, v, null);
    }

    @Generated
    public BPassword getAuthPass() {
        return (BPassword)this.get(authPass);
    }

    @Generated
    public void setAuthPass(BPassword v) {
        this.set(authPass, (BValue)v, null);
    }

    @Generated
    public boolean getDebugResponses() {
        return this.getBoolean(debugResponses);
    }

    @Generated
    public void setDebugResponses(boolean v) {
        this.setBoolean(debugResponses, v, null);
    }

    @Generated
    public boolean getDebugRequests() {
        return this.getBoolean(debugRequests);
    }

    @Generated
    public void setDebugRequests(boolean v) {
        this.setBoolean(debugRequests, v, null);
    }

    @Generated
    public BObixPollScheduler getPollScheduler() {
        return (BObixPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BObixPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public BObixState getState() {
        return (BObixState)this.get(state);
    }

    @Generated
    public void setState(BObixState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BObixAlarmDeviceExt getAlarms() {
        return (BObixAlarmDeviceExt)this.get(alarms);
    }

    @Generated
    public void setAlarms(BObixAlarmDeviceExt v) {
        this.set(alarms, (BValue)v, null);
    }

    @Generated
    public BObixHistoryDeviceExt getHistories() {
        return (BObixHistoryDeviceExt)this.get(histories);
    }

    @Generated
    public void setHistories(BObixHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    @Generated
    public BObixPointDeviceExt getPoints() {
        return (BObixPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BObixPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BObixScheduleDeviceExt getSchedules() {
        return (BObixScheduleDeviceExt)this.get(schedules);
    }

    @Generated
    public void setSchedules(BObixScheduleDeviceExt v) {
        this.set(schedules, (BValue)v, null);
    }

    @Generated
    public BRelTime getSessionTimeout() {
        return (BRelTime)this.get(sessionTimeout);
    }

    @Generated
    public void setSessionTimeout(BRelTime v) {
        this.set(sessionTimeout, (BValue)v, null);
    }

    @Generated
    public BRelTime getWatchSafetyFactor() {
        return (BRelTime)this.get(watchSafetyFactor);
    }

    @Generated
    public void setWatchSafetyFactor(BRelTime v) {
        this.set(watchSafetyFactor, (BValue)v, null);
    }

    @Generated
    public void attach() {
        this.invoke(attach, null, null);
    }

    @Generated
    public void detach() {
        this.invoke(detach, null, null);
    }

    @Generated
    public void reattach() {
        this.invoke(reattach, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.getEnabled()) {
            this.attach();
        }
        this.deviceAtSteadyState();
    }

    public void changed(Property p, Context c) {
        super.changed(p, c);
        if (c != Context.decoding && this.isRunning()) {
            if (p.equals(lobby) || p.equals(authUser) || p.equals(authPass)) {
                this.lobbyUri = null;
                this.reattach();
            } else if (p.equals(status)) {
                if (this.isDown() || this.isDisabled() || this.isFault()) {
                    if (this.getState().isEngaged()) {
                        this.detach();
                    }
                } else if (this.getState().isDisengaged()) {
                    this.attach();
                }
            } else if (p.equals(enabled) && !this.isDisabled()) {
                this.getObixNetwork().enqueue(new Runnable(){

                    @Override
                    public void run() {
                        BObixClient.this.session();
                    }
                });
            }
        }
    }

    public void doAttach() {
        if (this.getState().isEngaged() || this.isDisabled() || this.isFatalFault()) {
            return;
        }
        if (lobby.isEquivalentToDefaultValue(this.get(lobby))) {
            this.configFail("Configure Lobby URI");
            return;
        }
        this.configOk();
        this.getLogger().fine("Attaching on " + this.getName());
        try {
            this.setAttaching();
            this.session();
            this.setAttached();
            this.pingOk();
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Device attach:" + this.getName(), x);
            this.pingFail(x.toString());
            this.setDetached();
            return;
        }
        try {
            this.getPoints().attach();
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Point device extension attach:" + this.getName(), x);
        }
        try {
            this.getAlarms().attach();
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Alarm device extension attach:" + this.getName(), x);
        }
    }

    public void doDetach() {
        this.doDetach(false);
    }

    private void doDetach(boolean keepSubs) {
        if (this.getState().isDisengaged()) {
            return;
        }
        this.getLogger().fine("Detaching on " + this.getName());
        try {
            this.setDetached();
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.session = null;
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Device detach:" + this.getName(), x);
        }
        try {
            this.getPoints().detach(keepSubs);
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Point device extension detach:" + this.getName(), x);
        }
        try {
            this.getAlarms().detach();
        }
        catch (Throwable x) {
            this.getLogger().log(Level.SEVERE, "Alarm device extension detach:" + this.getName(), x);
        }
    }

    public void doReattach() {
        this.doDetach(true);
        this.getPoints().doVerifyPoints();
        this.doAttach();
    }

    public void doPing() {
        try {
            if (lobby.isEquivalentToDefaultValue(this.get(lobby))) {
                this.configFail("Configure Lobby URI");
                return;
            }
            this.configOk();
            if (this.getState().isAttached()) {
                this.session().ping();
                this.getPoints().attach();
                this.getAlarms().attach();
                this.pingOk();
            } else if (this.getState().isDetached()) {
                this.attach();
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.SEVERE, "Ping failed", t);
            this.pingFail(t.getMessage());
        }
    }

    public Type getNetworkType() {
        return BObixNetwork.TYPE;
    }

    public final Uri getAbsoluteUri(Uri arg) {
        if (arg.isAbsolute()) {
            return arg;
        }
        return arg.normalize(this.lobby());
    }

    public final BObixNetwork getObixNetwork() {
        if (this.network == null) {
            for (BComplex cur = this.getParent(); cur != null; cur = cur.getParent()) {
                if (!(cur instanceof BObixNetwork)) continue;
                this.network = (BObixNetwork)cur;
                break;
            }
        }
        return this.network;
    }

    public final Uri getRelativeUri(Uri arg) {
        if (arg.isRelative()) {
            return arg;
        }
        Uri lobbyUri = this.lobby();
        if (arg.get().startsWith(lobbyUri.get())) {
            String abs = arg.get();
            String auth = lobbyUri.getAuthority();
            if (auth.endsWith("/")) {
                return new Uri(abs.substring(auth.length() - 1));
            }
            return new Uri(abs.substring(auth.length()));
        }
        return arg;
    }

    public final Boolean isTridiumServer() {
        return this.isTridiumServer(this.session());
    }

    public BatchIn makeBatch() throws Exception {
        return this.session().makeBatch();
    }

    public BFacets makeBoolRange(Uri uri) {
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        String trueText = "true";
        Obj tmpObj = obj.get("true");
        if (tmpObj != null && tmpObj.getDisplayName() != null) {
            trueText = tmpObj.getDisplayName();
        }
        String falseText = "false";
        tmpObj = obj.get("false");
        if (tmpObj != null && tmpObj.getDisplayName() != null) {
            falseText = tmpObj.getDisplayName();
        }
        return BFacets.makeBoolean((BString)BString.make((String)trueText), (BString)BString.make((String)falseText));
    }

    public BFacets makeFacets(BFacets base, Obj obj) {
        BFacets ret = base;
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        if (obj.isVal()) {
            if (obj.isBool()) {
                Bool oBool = (Bool)obj;
                Uri uri = this.normalize((Obj)oBool, oBool.getRange());
                if (uri != null) {
                    String current = base.gets("boolUri", "");
                    if (!uri.get().equals(current)) {
                        t.put("boolUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    ret = BFacets.makeRemove((BFacets)ret, (String)"trueText");
                    ret = BFacets.makeRemove((BFacets)ret, (String)"falseText");
                }
            } else if (obj.isReal()) {
                Real oReal = (Real)obj;
                t.put("min", BDouble.make((double)oReal.getMin()));
                t.put("max", BDouble.make((double)oReal.getMax()));
                t.put("precision", BInteger.make((int)oReal.getPrecision()));
                Uri uri = this.normalize((Obj)oReal, oReal.getUnit());
                if (uri != null) {
                    String current = base.gets("unitsUri", "");
                    if (!uri.get().equals(current)) {
                        t.put("unitsUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    ret = BFacets.makeRemove((BFacets)ret, (String)"units");
                }
            } else if (obj.isInt()) {
                Int oInt = (Int)obj;
                t.put("min", BDouble.make((double)oInt.getMin()));
                t.put("max", BDouble.make((double)oInt.getMax()));
                Uri uri = this.normalize((Obj)oInt, oInt.getUnit());
                if (uri != null) {
                    String current = base.gets("unitsUri", "");
                    if (!uri.get().equals(current)) {
                        t.put("unitsUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    ret = BFacets.makeRemove((BFacets)ret, (String)"units");
                }
            } else if (obj.isEnum()) {
                Enum oEnum = (Enum)obj;
                Uri uri = this.normalize((Obj)oEnum, oEnum.getRange());
                if (uri != null) {
                    String current = base.gets("enumUri", "");
                    if (!uri.get().equals(current)) {
                        t.put("enumUri", BString.make((String)this.getRelativeUri(uri).get()));
                    }
                } else {
                    ret = BFacets.makeRemove((BFacets)ret, (String)"range");
                }
            } else if (obj.isReltime()) {
                t.put("units", BUnit.getUnit((String)"millisecond"));
            }
        }
        if (!t.isEmpty()) {
            ret = BFacets.make((BFacets)ret, (BFacets)BFacets.make(t));
        }
        return ret;
    }

    public BEnumRange makeEnumRange(Uri uri) {
        String val = uri.get();
        if (val.startsWith("obix:")) {
            if ("obix:Weekday".equals(val)) {
                return BWeekday.sunday.getRange();
            }
            if ("obix:Month".equals(val)) {
                return BMonth.may.getRange();
            }
            throw new RuntimeException("Unknown range: " + val);
        }
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        Obj[] kids = obj.list();
        int len = kids.length;
        String[] tags = new String[len];
        for (int i = 0; i < len; ++i) {
            tags[i] = SlotPath.escape((String)kids[i].getName());
        }
        return BEnumRange.make((String[])tags);
    }

    public Obj makeObj(BValue val, Context cx) {
        BStatusValue sv;
        Bool ret;
        BIBoolean v;
        if (val == null) {
            Obj ret2 = new Obj();
            ret2.setNull(true);
            return ret2;
        }
        if (val instanceof BIBoolean) {
            v = (BIBoolean)val;
            ret = new Bool(v.getBoolean());
        } else if (val instanceof BAbsTime) {
            v = (BAbsTime)val;
            ret = new Abstime(v.getMillis(), TimeZone.getTimeZone(v.getTimeZone().getId()));
        } else if (val instanceof BRelTime) {
            v = (BRelTime)val;
            ret = new Reltime(v.getMillis());
        } else if (val instanceof BInteger) {
            v = (BInteger)val;
            ret = new Int((long)v.getInt());
        } else if (val instanceof BINumeric) {
            v = (BINumeric)val;
            ret = new Real(v.getNumeric());
        } else if (val instanceof BIEnum) {
            v = (BIEnum)val;
            Enum oEnum = new Enum();
            oEnum.set(SlotPath.unescape((String)v.getEnum().getTag()));
            BEnumRange range = null;
            if (cx != null) {
                range = (BEnumRange)cx.getFacets().get("range");
            }
            if (range == null) {
                range = (BEnumRange)v.getEnumFacets().get("range");
            }
            if (range != null) {
                oEnum.set(SlotPath.unescape((String)range.getTag(v.getEnum().getOrdinal())));
            }
            ret = oEnum;
        } else {
            Str oStr = new Str();
            try {
                if (val.isSimple()) {
                    oStr.set(val.asSimple().encodeToString());
                } else {
                    oStr.set(val.toString(cx));
                }
            }
            catch (Exception x) {
                oStr.set(val.toString(cx));
            }
            ret = oStr;
        }
        if (val instanceof BIStatus) {
            BIStatus status = (BIStatus)val;
            BStatus s = status.getStatus();
            if (s.isDisabled()) {
                ret.setStatus(Status.disabled);
            } else if (s.isFault()) {
                ret.setStatus(Status.fault);
            } else if (s.isDown()) {
                ret.setStatus(Status.down);
            } else if (s.isAlarm() && s.isUnackedAlarm()) {
                ret.setStatus(Status.unackedAlarm);
            } else if (s.isAlarm()) {
                ret.setStatus(Status.alarm);
            } else if (s.isUnackedAlarm()) {
                ret.setStatus(Status.unacked);
            } else if (s.isOverridden()) {
                ret.setStatus(Status.overridden);
            }
            if (s.isNull()) {
                ret.setNull(true);
            }
        }
        if (val.isNull()) {
            ret.setNull(true);
        } else if (val instanceof BStatusValue && (sv = (BStatusValue)val).getValueValue().isNull()) {
            ret.setNull(true);
        }
        return ret;
    }

    public BSimple makeSimple(Obj obj, Context cx) {
        BBoolean ret;
        if (obj.isBool()) {
            Bool oBool = (Bool)obj;
            ret = oBool.get() ? BBoolean.TRUE : BBoolean.FALSE;
        } else if (obj.isReal()) {
            Real oReal = (Real)obj;
            ret = BDouble.make((double)oReal.get());
        } else if (obj.isInt()) {
            Int oInt = (Int)obj;
            ret = BInteger.make((int)((int)oInt.get()));
        } else if (obj.isEnum()) {
            BEnumRange range = (BEnumRange)cx.getFacets().get("range");
            Enum oEnum = (Enum)obj;
            if (range == null) {
                try {
                    ret = BDynamicEnum.make((int)Integer.parseInt(oEnum.get()));
                }
                catch (Exception x) {
                    throw new WrapperException(x);
                }
            } else {
                try {
                    ret = range.get(SlotPath.escape((String)oEnum.get()));
                }
                catch (Exception x) {
                    try {
                        ret = BDynamicEnum.make((int)Integer.parseInt(oEnum.get()));
                    }
                    catch (Exception e) {
                        throw new WrapperException(x);
                    }
                }
            }
        } else if (obj.isReltime()) {
            Reltime oRel = (Reltime)obj;
            ret = BRelTime.make((long)oRel.get());
        } else if (obj.isVal()) {
            Val oVal = (Val)obj;
            ret = BString.make((String)oVal.encodeVal());
        } else {
            ret = BString.make((String)obj.toDisplayString());
        }
        return ret;
    }

    public BStatusValue makeStatusValue(Obj obj, BFacets facets) {
        int at;
        BStatusBoolean ret;
        if (obj.isBool()) {
            Bool oBool = (Bool)obj;
            ret = new BStatusBoolean();
            ret.setValueValue((BValue)BBoolean.make((boolean)oBool.get()));
        } else if (obj.isReal()) {
            Real oReal = (Real)obj;
            ret = new BStatusNumeric();
            ret.setValueValue((BValue)BDouble.make((double)oReal.get()));
        } else if (obj.isInt()) {
            Int oInt = (Int)obj;
            ret = new BStatusNumeric();
            ret.setValueValue((BValue)BDouble.make((double)oInt.get()));
        } else if (obj.isEnum()) {
            BEnumRange range = (BEnumRange)facets.get("range");
            Enum oEnum = (Enum)obj;
            BStatusEnum tmp = new BStatusEnum();
            ret = tmp;
            if (range == null) {
                try {
                    tmp.setValue(BDynamicEnum.make((int)Integer.parseInt(oEnum.get())));
                }
                catch (Exception x) {
                    throw new WrapperException(x);
                }
            } else {
                try {
                    tmp.setValue(range.get(SlotPath.escape((String)oEnum.get())));
                }
                catch (Exception x) {
                    try {
                        tmp.setValueValue((BValue)BDynamicEnum.make((int)Integer.parseInt(oEnum.get())));
                    }
                    catch (Exception e) {
                        throw new WrapperException(x);
                    }
                }
            }
        } else if (obj.isReltime()) {
            Reltime oRel = (Reltime)obj;
            ret = new BStatusNumeric();
            ret.setValueValue((BValue)BDouble.make((double)oRel.get()));
        } else if (obj.isVal()) {
            Val oVal = (Val)obj;
            ret = new BStatusString();
            ret.setValueValue((BValue)BString.make((String)oVal.encodeVal()));
        } else {
            ret = new BStatusString();
            ret.setValueValue((BValue)BString.make((String)obj.toDisplayString()));
        }
        Status s = obj.getStatus();
        if (s == Status.alarm) {
            ret.setStatus(BStatus.alarm);
        } else if (s == Status.disabled) {
            ret.setStatus(BStatus.disabled);
        } else if (s == Status.down) {
            ret.setStatus(BStatus.down);
        } else if (s == Status.fault) {
            ret.setStatus(BStatus.fault);
        } else if (s == Status.ok) {
            ret.setStatus(BStatus.ok);
        } else if (s == Status.overridden) {
            ret.setStatus(BStatus.overridden);
        } else if (s == Status.unacked) {
            ret.setStatus(BStatus.unackedAlarm);
        } else if (s == Status.unackedAlarm) {
            ret.setStatus(BStatus.makeAlarm((BStatus)BStatus.unackedAlarm, (boolean)true));
        }
        String displ = obj.getDisplay();
        if (displ != null && (at = displ.indexOf(64)) > 0) {
            ret.setStatus("activeLevel", (BIDataValue)BString.make((String)displ.substring(at + 1).trim()));
        }
        if (obj.isNull()) {
            ret.setStatusNull(true);
        }
        return ret;
    }

    public BUnit makeUnits(Uri uri) {
        if (uri.get().startsWith("obix:units/")) {
            String s = uri.get().substring(11);
            BUnit unit = BUnit.getUnit((String)(s = s.replace('_', ' ')));
            if (unit == null) {
                throw new RuntimeException("Unit not found: " + s);
            }
            return unit;
        }
        Obj obj = this.obixRead(uri);
        this.obixReadFully(obj);
        String name = obj.getDisplay();
        BUnit ret = BUnit.getUnit((String)name);
        if (ret != null) {
            return ret;
        }
        String symbol = obj.get("symbol").getStr();
        double scale = obj.get("scale").getReal();
        Obj dim = obj.get("dimension");
        BDimension dimension = BDimension.make((int)((int)dim.get("m").getInt()), (int)((int)dim.get("kg").getInt()), (int)((int)dim.get("sec").getInt()), (int)((int)dim.get("A").getInt()), (int)((int)dim.get("K").getInt()), (int)((int)dim.get("mol").getInt()), (int)((int)dim.get("cd").getInt()));
        return BUnit.make((String)name, (String)symbol, (BDimension)dimension, (double)scale);
    }

    public SessionWatch makeWatch(String name, long watchPollRate, WatchListener listener) throws Exception {
        return this.session().makeWatch(name, watchPollRate, listener);
    }

    public Obj obixInvoke(Uri uri, Obj arg) {
        try {
            this.debug(true, "Invoke Request: " + uri.get(), arg);
            Obj ret = this.session().invoke(this.getAbsoluteUri(uri), arg);
            this.debug(false, "Invoke Response: ", ret);
            return ret;
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public Obj obixRead(Uri uri) {
        try {
            this.debug(true, "Read Request: ", (Obj)uri);
            Obj ret = this.session().read(this.getAbsoluteUri(uri));
            this.debug(false, "Read Response: ", ret);
            return ret;
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public void obixReadChildren(Obj obj) {
        Obj[] kids = obj.list();
        if (kids == null) {
            return;
        }
        int i = kids.length;
        while (--i >= 0) {
            if (!kids[i].isRef()) continue;
            Obj kid = this.obixRead(kids[i].getNormalizedHref());
            obj.replace(kids[i], kid);
        }
    }

    public void obixReadFully(Obj obj) {
        Obj[] kids = obj.list();
        int i = kids.length;
        while (--i >= 0) {
            if (kids[i].isRef()) {
                Obj kid = this.obixRead(kids[i].getNormalizedHref());
                obj.replace(kids[i], kid);
                kids[i] = kid;
            }
            this.obixReadFully(kids[i]);
        }
    }

    public Obj obixWrite(Obj arg) {
        try {
            this.debug(true, "Write Request: ", arg);
            arg.setHref(this.getAbsoluteUri(arg.getHref()));
            Obj ret = this.session().write(arg);
            this.debug(false, "Write Response: ", ret);
            return ret;
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public InputStream open(Uri uri) throws Exception {
        return this.session().open(this.getAbsoluteUri(uri));
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, a, arg, cx));
        return null;
    }

    public IFuture postPing() {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, ping, null, null));
        return null;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps("ObixClient");
        out.prop((Object)"licenseChecked", this.licenseChecked());
        out.prop((Object)"session", (Object)this.session);
        out.prop((Object)"network", (Object)this.network);
        out.prop((Object)"lobbyUri", (Object)this.lobbyUri);
        out.endProps();
        super.spy(out);
    }

    public final void started() throws Exception {
        this.network = null;
        super.started();
        this.deviceStarted();
    }

    public void stopped() throws Exception {
        try {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            if (this.getState().isEngaged()) {
                this.detach();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopped();
    }

    public String toString(Context c) {
        return "ObixClient:" + this.getName();
    }

    protected void deviceAtSteadyState() throws Exception {
    }

    protected void deviceStarted() throws Exception {
    }

    protected Uri getFullRelativeUri(Obj obj, Uri uri) {
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkObixLicense(ObixSession s) {
        if (this.licenseChecked()) {
            return;
        }
        if (this.isDown()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            try {
                String licenseFault;
                Boolean isTridium = this.isTridiumServer(s);
                if (isTridium == null) {
                    return;
                }
                if (!isTridium.booleanValue() && (licenseFault = this.getObixNetwork().checkObixLimit("foreignDevice.limit")) != null) {
                    this.configFatal(licenseFault);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.configFatal(e.toString());
            }
            this.licenseChecked = true;
        }
    }

    private void debug(boolean request, String title, Obj obj) {
        if (request && !this.getDebugRequests()) {
            return;
        }
        if (!request && !this.getDebugResponses()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = ObixEncoder.make((OutputStream)System.out, null);
            }
            System.out.println(title);
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Boolean isTridiumServer(ObixSession s) {
        if (this.tridium != null) {
            return this.tridium;
        }
        if (this.isDown()) {
            return null;
        }
        try {
            Obj pn;
            String pnstr;
            Obj vn;
            String vnstr;
            Obj lobby = s.read(this.lobby());
            if (lobby == null) {
                return null;
            }
            Obj about = lobby.get("about");
            if (about == null) {
                return null;
            }
            if (about.getHref() != null && (vnstr = (vn = (about = s.read(about.getNormalizedHref())).get("vendorName")).getStr()).contains(TextUtil.capitalize((String)"tridium")) && (pnstr = (pn = about.get("productName")).getStr()).contains("Niagara")) {
                this.tridium = Boolean.TRUE;
                return this.tridium;
            }
            this.tridium = Boolean.FALSE;
        }
        catch (ConnectException e) {
            this.pingFail(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tridium = Boolean.FALSE;
        }
        return this.tridium;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean licenseChecked() {
        Object object = this.sync;
        synchronized (object) {
            return this.licenseChecked;
        }
    }

    private Uri lobby() {
        if (this.lobbyUri == null) {
            String s = this.getLobby();
            if (!s.endsWith("/")) {
                s = s + "/";
            }
            this.lobbyUri = new Uri(s);
        }
        return this.lobbyUri;
    }

    private Uri normalize(Obj obj, Uri uri) {
        if (uri == null || "".equals(uri.get())) {
            return null;
        }
        if (obj == null) {
            return uri;
        }
        Uri base = this.getAbsoluteUri(obj.getRoot().getHref());
        if (base == null || "".equals(base.get())) {
            return uri;
        }
        Uri fruri = this.getFullRelativeUri(obj, uri);
        return fruri.normalize(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObixSession session() {
        try {
            Object s;
            if (this.session == null) {
                s = new ObixSession(new Uri(this.getLobby()), this.getAuthUser(), AccessController.doPrivileged(() -> ((BPassword)this.getAuthPass()).getValue()), (int)this.getSessionTimeout().getMillis());
                s.open();
                this.session = s;
            }
            s = this.sync;
            synchronized (s) {
                if (!this.licenseChecked()) {
                    this.checkObixLicense(this.session);
                }
            }
        }
        catch (IOException x) {
            this.pingFail(x.toString());
            throw new WrapperException(x);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
        return this.session;
    }

    private void setAttached() {
        this.setState(BObixState.attached);
    }

    private void setAttaching() {
        this.setState(BObixState.attaching);
    }

    private void setDetached() {
        this.setState(BObixState.detached);
    }
}

