/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.watch;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.server.BObixOp;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.PermissionErr;
import com.tridium.obix.watch.BWatchEntry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixServer;
import javax.baja.obix.io.BIObixWatchable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="lease", type="BRelTime", defaultValue="BRelTime.makeSeconds(15)", flags=256), @NiagaraProperty(name="expires", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=260), @NiagaraProperty(name="add", type="BObixOp", defaultValue="new BObixOp(\"add\",WATCH_IN,WATCH_OUT)", flags=256), @NiagaraProperty(name="remove", type="BObixOp", defaultValue="new BObixOp(\"remove\",WATCH_IN,URN_NIL)", flags=256), @NiagaraProperty(name="pollChanges", type="BObixOp", defaultValue="new BObixOp(\"pollChanges\",URN_NIL,WATCH_OUT)", flags=256), @NiagaraProperty(name="pollRefresh", type="BObixOp", defaultValue="new BObixOp(\"pollRefresh\",URN_NIL,WATCH_OUT)", flags=256), @NiagaraProperty(name="delete", type="BObixOp", defaultValue="new BObixOp(\"delete\",URN_NIL,URN_NIL)", flags=256)})
public class BObixWatch
extends BObixAgent
implements BObixOp.Parent {
    public static final String WATCH_IN = "obix:WatchIn";
    public static final String WATCH_OUT = "obix:WatchOut";
    @Generated
    public static final Property lease = BObixWatch.newProperty((int)256, (BValue)BRelTime.makeSeconds((int)15), null);
    @Generated
    public static final Property expires = BObixWatch.newProperty((int)260, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property add = BObixWatch.newProperty((int)256, (BValue)new BObixOp("add", "obix:WatchIn", "obix:WatchOut"), null);
    @Generated
    public static final Property remove = BObixWatch.newProperty((int)256, (BValue)new BObixOp("remove", "obix:WatchIn", "obix:Nil"), null);
    @Generated
    public static final Property pollChanges = BObixWatch.newProperty((int)256, (BValue)new BObixOp("pollChanges", "obix:Nil", "obix:WatchOut"), null);
    @Generated
    public static final Property pollRefresh = BObixWatch.newProperty((int)256, (BValue)new BObixOp("pollRefresh", "obix:Nil", "obix:WatchOut"), null);
    @Generated
    public static final Property delete = BObixWatch.newProperty((int)256, (BValue)new BObixOp("delete", "obix:Nil", "obix:Nil"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixWatch.class);
    Map<String, BIObixWatchable> entries = new ConcurrentHashMap<String, BIObixWatchable>();
    private final Object mutex = new Object();
    BObixServer server;
    Subscription subscriber = new Subscription();
    BUser user;

    @Generated
    public BRelTime getLease() {
        return (BRelTime)this.get(lease);
    }

    @Generated
    public void setLease(BRelTime v) {
        this.set(lease, (BValue)v, null);
    }

    @Generated
    public BAbsTime getExpires() {
        return (BAbsTime)this.get(expires);
    }

    @Generated
    public void setExpires(BAbsTime v) {
        this.set(expires, (BValue)v, null);
    }

    @Generated
    public BObixOp getAdd() {
        return (BObixOp)this.get(add);
    }

    @Generated
    public void setAdd(BObixOp v) {
        this.set(add, (BValue)v, null);
    }

    @Generated
    public BObixOp getRemove() {
        return (BObixOp)this.get(remove);
    }

    @Generated
    public void setRemove(BObixOp v) {
        this.set(remove, (BValue)v, null);
    }

    @Generated
    public BObixOp getPollChanges() {
        return (BObixOp)this.get(pollChanges);
    }

    @Generated
    public void setPollChanges(BObixOp v) {
        this.set(pollChanges, (BValue)v, null);
    }

    @Generated
    public BObixOp getPollRefresh() {
        return (BObixOp)this.get(pollRefresh);
    }

    @Generated
    public void setPollRefresh(BObixOp v) {
        this.set(pollRefresh, (BValue)v, null);
    }

    @Generated
    public BObixOp getDelete() {
        return (BObixOp)this.get(delete);
    }

    @Generated
    public void setDelete(BObixOp v) {
        this.set(delete, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixWatch() {
        this.renewLease();
    }

    public void stopped() {
        this.doCleanup();
    }

    @Override
    public String processAttr(String name, String value) {
        this.renewLease();
        if (name.equals("is")) {
            return "obix:Watch";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(BObixOp op, ObixDecoder in, ObixEncoder out) {
        try {
            this.checkUser(in.getUser());
            Object object = this.mutex;
            synchronized (object) {
                this.renewLease();
                switch (op.getOpName()) {
                    case "add": {
                        this.doAdd(in, out);
                        break;
                    }
                    case "remove": {
                        this.doRemove(in, out);
                        break;
                    }
                    case "pollChanges": {
                        this.doPollChanges(out, in);
                        break;
                    }
                    case "pollRefresh": {
                        this.doPollRefresh(out, in);
                        break;
                    }
                    case "delete": {
                        out.encodeNull();
                        this.getParent().asComponent().remove(this.getName());
                    }
                }
                this.renewLease();
            }
        }
        catch (Exception e) {
            out.encode(e);
        }
    }

    public boolean isExpired() {
        return this.getExpires().isBefore(Clock.time());
    }

    public void renewLease() {
        this.setExpires(Clock.time().add(this.getLease()));
    }

    public void setUser(BUser creator) {
        this.user = creator;
    }

    protected void doAdd(ObixDecoder in, ObixEncoder out) {
        try {
            XElem[] hrefs = this.getHrefs(in);
            Obj obj = new Obj().setIs(WATCH_OUT);
            obj.write(out, true);
            obj.initList("values", "obix:obj").write(out, true);
            out.commit();
            BObixServer server = this.getServer();
            for (XElem href1 : hrefs) {
                String href = href1.get("val", null);
                if (href == null) continue;
                BIObixWatchable watched = this.entries.get(href);
                if (watched == null) {
                    try {
                        OrdTarget t = server.resolve(href, in);
                        watched = this.getAgent(t);
                        watched.watchInit(href1, t);
                        this.entries.put(href, watched);
                    }
                    catch (Exception x) {
                        out.setHref(href);
                        out.encode(x);
                    }
                }
                if (watched != null) {
                    try {
                        watched.watchRefresh(out, in);
                    }
                    catch (Exception x) {
                        out.setHref(href);
                        out.encode(x);
                    }
                }
                out.commit();
            }
            obj.setElement("list").endElem(out);
            obj.reset().endElem(out);
        }
        catch (Exception x) {
            out.encode(x);
        }
    }

    protected void doPollChanges(ObixEncoder out, Context cx) {
        Obj obj = new Obj().setIs(WATCH_OUT);
        obj.write(out, true);
        obj.initList("values", "obix:obj").write(out, true);
        for (BIObixWatchable watchable : this.entries.values()) {
            watchable.watchChanges(out, cx);
        }
        obj.setElement("list").endElem(out);
        obj.reset().endElem(out);
    }

    protected void doPollRefresh(ObixEncoder out, Context cx) {
        Obj obj = new Obj().setIs(WATCH_OUT);
        obj.write(out, true);
        obj.initList("values", "obix:obj").write(out, true);
        for (BIObixWatchable watchable : this.entries.values()) {
            watchable.watchRefresh(out, cx);
        }
        obj.setElement("list").endElem(out);
        obj.reset().endElem(out);
    }

    protected void doRemove(ObixDecoder in, ObixEncoder out) {
        try {
            XElem[] hrefs;
            for (XElem href1 : hrefs = this.getHrefs(in)) {
                BIObixWatchable e;
                String href = href1.get("val", null);
                if (href == null || (e = this.entries.remove(href)) == null) continue;
                e.watchCleanup();
            }
            out.encodeNull();
        }
        catch (Exception x) {
            out.encode(x);
        }
    }

    void doCleanup() {
        this.entries.values().forEach(BIObixWatchable::watchCleanup);
    }

    BObixServer getServer() {
        if (this.server == null) {
            for (BObixWatch o = this; o != null && this.server == null; o = o.getParent()) {
                if (!(o instanceof BObixServer)) continue;
                this.server = (BObixServer)((Object)o);
            }
        }
        return this.server;
    }

    private BIObixWatchable getAgent(OrdTarget tgt) {
        BObject obj = tgt.get();
        if (obj instanceof BIObixWatchable) {
            return (BIObixWatchable)obj;
        }
        AgentList list = obj.getAgents((Context)tgt);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AgentInfo info = list.get(i);
            if (!info.getAgentType().is(BIObixWatchable.TYPE.getTypeInfo())) continue;
            return (BIObixWatchable)info.getInstance();
        }
        return new BWatchEntry(this);
    }

    protected XElem[] getHrefs(ObixDecoder in) throws Exception {
        XElem e = in.getDocument();
        e = e.elem("list");
        return e.elems();
    }

    private void checkUser(BUser requestUser) {
        if (requestUser != this.user) {
            throw new PermissionErr("Cannot access/modify another user's watch");
        }
    }

    static class Subscription
    extends Subscriber {
        Map<BComponent, BWatchEntry> subscriptions;

        Subscription() {
        }

        public void subscribe(BWatchEntry entry) {
            BWatchEntry e;
            BComponent c = entry.getComponent();
            if (c == null) {
                return;
            }
            if (this.subscriptions == null) {
                this.subscriptions = new ConcurrentHashMap<BComponent, BWatchEntry>();
            }
            if ((e = this.subscriptions.get(c)) != null) {
                entry.next = e;
            }
            this.subscriptions.put(c, entry);
            this.subscribe(c);
        }

        public void unsubscribe(BWatchEntry toRemove) {
            if (this.subscriptions == null) {
                return;
            }
            BComponent c = toRemove.getComponent();
            if (c == null) {
                return;
            }
            BWatchEntry e = this.subscriptions.get(c);
            if (e == null) {
                return;
            }
            if (e == toRemove) {
                e = e.next;
                if (e == null) {
                    this.unsubscribe(c);
                    this.subscriptions.remove(c);
                }
            } else {
                BWatchEntry prev = e;
                e = e.next;
                while (e != null) {
                    if (e == toRemove) {
                        prev.next = e.next;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
            }
        }

        public void event(BComponentEvent event) {
            switch (event.getId()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    this.markChanges(event);
                }
            }
        }

        public void markChanges(BComponentEvent event) {
            BComponent c = event.getSourceComponent();
            Slot s = event.getSlot();
            BWatchEntry e = this.subscriptions.get(c);
            while (e != null) {
                if (e.getSlot() == null || e.getSlot() == s) {
                    e.changed = true;
                }
                e = e.next;
            }
        }
    }
}

