/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.Obj;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:IDataTable", "baja:FilteredTable", "bql:BogCollection", "bql:ObjectList", "bql:ObjectTable", "bql:ProjectionTable"}, requiredPermissions="r")})
public class BObixCollectionAgent
extends BObixAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixCollectionAgent.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean encode(OrdTarget target, ObixEncoder out) throws Exception {
        Encoder enc = new Encoder(out);
        BObject o = target.get();
        if (o instanceof BITable) {
            this.encodeTable(target, enc);
        }
        enc.commit();
        return false;
    }

    protected void encodeTable(OrdTarget target, ObixEncoder out) throws Exception {
        BITable tbl = (BITable)target.get();
        Obj obj = new Obj();
        obj.setName(out.getName());
        obj.setHref(out.getHref());
        obj.write(out, true);
        out.setHref(null);
        TableCursor c = tbl.cursor();
        BFacets f = null;
        if (c.getContext() != null) {
            f = c.getContext().getFacets();
        }
        ColumnList list = tbl.getColumns();
        int len = list.size();
        Column[] cols = list.list();
        while (c.next()) {
            obj.reset().write(out, true);
            for (int i = 0; i < len; ++i) {
                out.setName(cols[i].getName());
                out.encode(new ObixTarget(target, (BObject)c.cell(cols[i]).as(BObject.class), f));
            }
            obj.endElem(out);
        }
        obj.reset().endElem(out);
    }

    static class Encoder
    extends ObixEncoder {
        Encoder(ObixEncoder base) throws Exception {
            super(base);
        }

        @Override
        protected void configChild(String parentHref, OrdTarget tgt) {
            super.configChild(parentHref, tgt);
            this.setRef(false);
        }
    }
}

