/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.lobby.BIObixLobbyAgent;
import javax.baja.obix.driver.lobby.BObixLobby;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType(agent={@AgentOn(types={"obixDriver:ObixLobby"}, requiredPermissions="r")})
public class BBatchOp
extends BObixAgent
implements BIObixLobbyAgent,
BIObixEncodable,
BIObixInvocable,
ObixConstants {
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchOp.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        this.encodeLobbyChild(out, cx);
    }

    @Override
    public void encodeLobbyChild(ObixEncoder out, Context cx) {
        try {
            Obj o = new Obj().initOp("batch", "obix:BatchIn", "obix:BatchOut");
            o.setHref(out.getHref());
            o.write(out, false);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    @Override
    public String getLobbyName() {
        return "batch";
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        XElem cur = in.getDocument();
        if (cur == null) {
            throw new IllegalArgumentException("BatchIn list not encountered.");
        }
        if (!"list".equals(cur.name())) {
            throw new IllegalArgumentException("Expecting list element but encountered " + cur.name());
        }
        BObixLobby lobby = (BObixLobby)this.getParent();
        XElem[] elems = cur.elems();
        Obj obj = new Obj().initList(null, "obix:BatchOut");
        obj.write(out, true);
        out.commit();
        for (XElem elem : elems) {
            out.setHref(null);
            try {
                cur = elem;
                if (!cur.name().equals("uri")) {
                    throw new Exception("Unexpected batch element: " + cur.name());
                }
                String href = cur.get("val", null);
                out.setHref(href);
                if (href == null) {
                    Exception x = new Exception("Missing val attribute: " + cur.toString());
                    out.encode(x);
                } else {
                    ObixDecoder arg;
                    XElem child;
                    String resource = ObixUtils.resource(out.getLobbyPath(), href);
                    resource = ObixUtils.replace(resource, "~", "|obix:");
                    resource = ObixUtils.replace(resource, "/|", "|");
                    OrdTarget tgt = lobby.resolve(resource, in);
                    String is = cur.get("is", "");
                    if (is.contains("obix:Read")) {
                        out.encode(tgt);
                    } else if (is.contains("obix:Write")) {
                        child = ObixUtils.child("in", cur);
                        if (child == null) {
                            throw new Exception("Batch write missing child named 'in'");
                        }
                        arg = new ObixDecoder(child, (Context)in);
                        arg.setDebug(in.isDebug());
                        ObixUtils.serviceWrite(tgt, arg, out);
                    } else if (is.contains("obix:Invoke")) {
                        child = ObixUtils.child("in", cur);
                        if (child == null) {
                            throw new Exception("Batch invoke missing child named 'in'");
                        }
                        arg = new ObixDecoder(child, (Context)in);
                        ObixUtils.serviceInvoke(tgt, arg, out);
                    } else {
                        out.encode(new Exception("Unknown batch contract: " + cur.toString()));
                    }
                }
            }
            catch (Exception x) {
                out.encode(x);
            }
            out.commit();
        }
        obj.initList(null, "obix:BatchOut").endElem(out);
    }

    @Override
    public OrdTarget resolve(String uri, Context cx) {
        BOrd o = this.getSlotPathOrd();
        return o.resolve((BObject)Sys.getStation(), cx);
    }
}

