/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BAlarmServiceAgent;
import com.tridium.obix.util.Obj;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAlarmServiceQuery
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmServiceQuery.class);
    BAlarmService service;
    BAlarmClass alarmClass;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmServiceQuery() {
    }

    public BAlarmServiceQuery(BAlarmService service) {
        this.service = service;
    }

    public BAlarmServiceQuery(BAlarmClass ac) {
        this.alarmClass = ac;
        this.service = (BAlarmService)ac.getParent();
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.initOp("query", "obix:AlarmFilter", "obix:AlarmQueryOut");
        obj.setHref(out.getHref());
        obj.write(out, false);
    }

    @Override
    public void invoke(ObixDecoder in, ObixEncoder out) {
        BInteger limit = null;
        BAbsTime start = null;
        BAbsTime end = null;
        try {
            BComponent filter = (BComponent)in.decode();
            if (filter != null) {
                limit = (BInteger)filter.get("limit");
                start = (BAbsTime)filter.get("start");
                end = (BAbsTime)filter.get("end");
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        Obj obj = new Obj().setIs("obix:AlarmQueryOut");
        obj.write(out, true);
        obj.initList("data", "obix:Alarm").write(out, true);
        out.commit();
        BOrd o = BOrd.make((String)BAlarmServiceAgent.queryRefresh(start, end, this.alarmClass));
        BITable results = (BITable)o.resolve((BObject)this.service).get();
        try (TableCursor cursor = results.cursor();){
            BAlarmServiceAgent.IterationResults res = BAlarmServiceAgent.iterateResults(limit, (Cursor<BAlarmRecord>)cursor, obj, out, in);
            obj.initList(null, null).endElem(out);
            obj.initInt("count", res.count).write(out, false);
            if (res.first != null) {
                obj.initAbstime("start", res.first).write(out, false);
            } else if (start != null) {
                obj.initAbstime("start", start).write(out, false);
            }
            if (res.last != null) {
                obj.initAbstime("end", res.last).write(out, false);
            } else if (end != null) {
                obj.initAbstime("end", end).write(out, false);
            }
        }
        obj.reset().endElem(out);
    }
}

