/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.FileUtil;

public class UserFileRepositoryCopy {
    private static final String NHOME_REPO_NAME = File.separator + "userFileRepo";
    private static final String NUSERHOME_REPO_NAME = File.separator + "shared" + File.separator + "fileRepo";

    public static void copyFileRepo() throws IllegalStateException {
        Logger nreLogger = Logger.getLogger("nre");
        nreLogger.fine("Copying files from niagara.home's userFileRepo");
        String niagaraHome = AccessController.doPrivileged(() -> System.getProperty("niagara.home"));
        String niagaraUserHome = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home"));
        if (niagaraHome == null || niagaraUserHome == null) {
            throw new IllegalStateException("Niagara environment variables not properly set");
        }
        File source = new File(niagaraHome + NHOME_REPO_NAME);
        File target = new File(niagaraUserHome + NUSERHOME_REPO_NAME);
        try {
            if (source.exists()) {
                UserFileRepositoryCopy.copy(source, target);
            }
        }
        catch (IOException e) {
            nreLogger.warning("Error copying files from niagara.home's userFileRepo");
        }
    }

    private static void copy(File source, File target) throws IOException {
        Logger nreLogger = Logger.getLogger("nre");
        if (nreLogger.isLoggable(Level.FINE)) {
            nreLogger.fine("Copying user repo file: \n\t" + source.getCanonicalPath() + "\n\t -> " + target.getCanonicalPath());
        }
        if (source.isDirectory()) {
            UserFileRepositoryCopy.copyDir(source, target);
        } else if (!target.exists()) {
            FileUtil.copyFile((File)source, (File)target);
        } else {
            nreLogger.fine("File already exists. Skipping copy.");
        }
    }

    private static void copyDir(File source, File target) throws IOException {
        if (!target.exists() && !target.mkdirs()) {
            throw new IOException("Cannot make dir: " + target);
        }
        File[] children = source.listFiles();
        if (children != null) {
            for (File child : children) {
                UserFileRepositoryCopy.copy(child, new File(target, child.getName()));
            }
        }
        target.setLastModified(source.lastModified());
    }
}

