/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.owasp.encoder.Encode;

public class LexiconModule {
    private final BModule module;
    private Lexicon currentLexicon;
    public static final Logger log = Logger.getLogger("sys.lexicon.module");
    private static LocaleInfo lastDefaultLocaleInfo = null;

    public static LexiconModule make(Type typeInModule) {
        return LexiconModule.make(typeInModule.getModule());
    }

    public static LexiconModule make(BModule module) {
        return new LexiconModule(module);
    }

    public static LexiconModule make(String module) {
        return LexiconModule.make(Lexicon.module(module));
    }

    public static LexiconModule make(Class<?> cls) {
        return LexiconModule.make(Sys.getModuleForClass(cls));
    }

    protected LexiconModule(BModule module) {
        this.module = module;
    }

    public String get(String key, Context cx) {
        return this.get(key, cx, null);
    }

    public String get(String key, Context cx, String def) {
        return this.getOrChangeCurrentLexicon(cx).get(key, def);
    }

    private Lexicon getOrChangeCurrentLexicon(Context cx) {
        Lexicon lexicon = this.currentLexicon;
        Lexicon lexiconForContext = LexiconModule.getLexiconForContext(lexicon, this.module, cx);
        if (lexiconForContext != null) {
            this.currentLexicon = lexiconForContext;
        }
        return this.currentLexicon;
    }

    private static Lexicon getLexiconForContext(Lexicon lexicon, BModule module, Context cx) {
        String contextLang;
        if (cx != null) {
            contextLang = Context.getLanguageTag(cx);
        } else {
            Locale defaultLocale = Locale.getDefault();
            LocaleInfo localeInfo = lastDefaultLocaleInfo;
            if (localeInfo != null && defaultLocale == localeInfo.getLocale()) {
                contextLang = localeInfo.getLanguageTag();
            } else {
                localeInfo = new LocaleInfo(defaultLocale);
                contextLang = localeInfo.getLanguageTag();
                lastDefaultLocaleInfo = localeInfo;
            }
        }
        if (lexicon == null) {
            return Lexicon.make(module, Lexicon.getLocaleFromLanguageCode(contextLang));
        }
        String lexiconLang = LexiconModule.getLanguageTag(lexicon);
        if (lexiconLang.equals(contextLang)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("LexiconModule language reused for " + lexicon.module + ": " + lexiconLang + " = " + contextLang);
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("LexiconModule language change for " + lexicon.module + ": " + lexiconLang + " != " + contextLang);
        }
        return Lexicon.make(module, Lexicon.getLocaleFromLanguageCode(contextLang));
    }

    private static String getLanguageTag(Lexicon lex) {
        StringBuilder localeKey = new StringBuilder();
        localeKey.append(lex.language);
        if (!lex.country.isEmpty()) {
            localeKey.append('-').append(lex.country);
        }
        if (!lex.variant.isEmpty()) {
            localeKey.append('-').append(lex.variant);
        }
        return localeKey.toString();
    }

    public String getText(String key, Context cx) {
        return this.get(key, cx, key);
    }

    public String getText(String key, Context cx, Object ... args) {
        String value = this.get(key, cx, null);
        if (value == null) {
            return key;
        }
        return MessageFormat.format(value, args);
    }

    public String getHtmlSafe(String key, Context cx) {
        String val = this.get(key, cx);
        return val != null ? Encode.forHtml((String)val) : val;
    }

    public String getHtmlSafe(String key, Context cx, String def) {
        String val = this.getHtmlSafe(key, cx);
        return val != null ? val : Encode.forHtml((String)def);
    }

    public String getHtmlSafeText(String key, Context cx) {
        return Encode.forHtml((String)this.getText(key, cx));
    }

    public String getHtmlSafeText(String key, Context cx, Object ... args) {
        String value = this.get(key, cx);
        if (value == null) {
            return Encode.forHtml((String)key);
        }
        return Encode.forHtml((String)MessageFormat.format(value, args));
    }

    public BModule getModule() {
        return this.module;
    }

    private static class LocaleInfo {
        private final String languageTag;
        private final Locale locale;

        private LocaleInfo(Locale locale) {
            StringBuilder localeKey = new StringBuilder();
            localeKey.append(locale.getLanguage());
            if (!locale.getCountry().isEmpty()) {
                localeKey.append('-').append(locale.getCountry());
            }
            if (!locale.getVariant().isEmpty()) {
                localeKey.append('-').append(locale.getVariant());
            }
            this.languageTag = localeKey.toString();
            this.locale = locale;
        }

        public String getLanguageTag() {
            return this.languageTag;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

