/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.util.DiagnosticLexicon;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.RegistryException;
import javax.baja.sys.BModule;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.PatternFilter;
import org.owasp.encoder.Encode;

public class Lexicon {
    public static final FilePath LEXICON_HOME_PATH = new FilePath("!lexicon");
    private static Logger log = Logger.getLogger("sys.lexicon");
    private static final Map<String, Properties> common = new ConcurrentHashMap<String, Properties>();
    private static Properties empty = new Properties();
    private static final Set<String> extendedPropsModules = new HashSet<String>();
    public final BModule module;
    public final String language;
    public final String country;
    public final String variant;
    private Properties moduleProps;
    private Properties langProps;
    private static final LexiconProcessor[] PROCESSORS = new LexiconProcessor[]{new NestedLexiconTag(), new BrandLexiconTag()};
    private static final Map<String, Locale> LOCALES_BY_LANG = new ConcurrentHashMap<String, Locale>();

    public static Lexicon make(BModule module, String lang, String country, String variant) {
        if (DiagnosticLexicon.DIAGNOSTICS) {
            return new DiagnosticLexicon(module, lang, country, variant);
        }
        return new Lexicon(module, lang, country, variant);
    }

    public static Lexicon make(BModule module, String lang) {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equalsIgnoreCase(lang)) {
            return Lexicon.make(module, locale);
        }
        locale = Lexicon.getLocaleFromLanguageCode(lang);
        if (!locale.getLanguage().isEmpty()) {
            return Lexicon.make(module, locale);
        }
        return Lexicon.make(module, lang, "", "");
    }

    static Locale getLocaleFromLanguageCode(String lang) {
        if (lang == null) {
            return Locale.getDefault();
        }
        Locale result = LOCALES_BY_LANG.computeIfAbsent(lang, l -> Locale.forLanguageTag(Context.getLanguageTag(lang)));
        return result;
    }

    public static Lexicon make(String module, String lang, String country, String variant) {
        return Lexicon.make(Lexicon.module(module), lang, country, variant);
    }

    public static Lexicon make(String module, String lang) {
        return Lexicon.make(Lexicon.module(module), lang);
    }

    public static Lexicon make(BModule module, Locale locale) {
        return Lexicon.make(module, locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static Lexicon make(BModule module, Context cx) {
        return Lexicon.make(module, Lexicon.lang(cx));
    }

    public static Lexicon make(String module, Locale locale) {
        return Lexicon.make(Lexicon.module(module), locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static Lexicon make(String module, Context cx) {
        return Lexicon.make(Lexicon.module(module), Lexicon.lang(cx));
    }

    public static Lexicon make(String module) {
        return Lexicon.make(Lexicon.module(module), Locale.getDefault());
    }

    public static Lexicon make(Class<?> cls) {
        return Lexicon.make(Sys.getModuleForClass(cls), Locale.getDefault());
    }

    static BModule module(String module) {
        try {
            return Sys.loadModule(module);
        }
        catch (ModuleNotFoundException e) {
            log.warning("Lexicon module not found: " + module);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Lexicon module failure: " + module, e);
        }
        return null;
    }

    static String lang(Context cx) {
        if (cx != null) {
            return cx.getLanguage();
        }
        return Sys.getLanguage();
    }

    public static String removeUnderscore(String s) {
        StringBuilder r = new StringBuilder(s.length());
        r.setLength(s.length());
        int current = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur == '_') continue;
            r.setCharAt(current++, cur);
        }
        return r.toString();
    }

    protected Lexicon(BModule module, String language, String country, String variant) {
        if (language == null || language.isEmpty()) {
            language = Sys.getLanguage();
        }
        if (language == null) {
            throw new RuntimeException("Invalid Nre boot sequence, Sys.lang null");
        }
        String localeKey = language;
        if (country == null) {
            country = "";
        }
        if (!country.isEmpty()) {
            localeKey = localeKey + "_" + country;
        }
        if (variant == null) {
            variant = "";
        }
        if (!variant.isEmpty()) {
            localeKey = localeKey + "_" + variant;
        }
        this.module = module;
        this.language = language;
        this.country = country;
        this.variant = variant;
        this.init(module, language, localeKey);
    }

    protected void init(BModule module, String language, String localeKey) {
        if (module == null) {
            this.moduleProps = empty;
            this.langProps = empty;
            return;
        }
        this.moduleProps = Lexicon.load(module, null);
        this.langProps = Lexicon.load(module, localeKey);
        if (this.langProps.isEmpty()) {
            this.langProps = Lexicon.load(module, language);
        }
        String extendedPropsKey = Lexicon.getCommonKey(module, localeKey);
        if (!extendedPropsModules.contains(module.getModuleName())) {
            Lexicon.loadFromModule(module, null);
            extendedPropsModules.add(module.getModuleName());
        }
        if (!extendedPropsModules.contains(extendedPropsKey)) {
            Lexicon.loadFromModule(module, localeKey);
            extendedPropsModules.add(extendedPropsKey);
        }
    }

    public Properties getModuleProperties() {
        return this.moduleProps;
    }

    public Properties getLanguageProperties() {
        return this.langProps;
    }

    public String get(String key, String def) {
        String value = this.get(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public String get(String key) {
        String value = null;
        if (this.langProps != null) {
            value = this.langProps.getProperty(key);
        }
        if (value == null && this.moduleProps != null) {
            value = this.moduleProps.getProperty(key);
        }
        if (value == null) {
            return null;
        }
        value = Lexicon.process(value, this);
        return value;
    }

    public String getText(String key) {
        return this.get(key, key);
    }

    public String getText(String key, Object ... args) {
        String value = this.get(key, null);
        if (value == null) {
            return key;
        }
        return MessageFormat.format(value, args);
    }

    public String getTextAsName(String key) {
        return SlotPath.escape(this.getText(key));
    }

    public String getHtmlSafe(String key) {
        String val = this.get(key);
        return val != null ? Encode.forHtml((String)val) : val;
    }

    public String getHtmlSafe(String key, String def) {
        String val = this.getHtmlSafe(key);
        return val != null ? val : Encode.forHtml((String)def);
    }

    public String getHtmlSafeText(String key) {
        return Encode.forHtml((String)this.getText(key));
    }

    public String getHtmlSafeText(String key, Object ... args) {
        String value = this.get(key);
        if (value == null) {
            return Encode.forHtml((String)key);
        }
        return Encode.forHtml((String)MessageFormat.format(value, args));
    }

    public String toString() {
        String ret = "Lexicon:" + this.module + ":" + this.language;
        if (!this.country.isEmpty()) {
            ret = ret + "_" + this.country;
        }
        return ret;
    }

    private static String process(String value, Lexicon lexicon) {
        if (value == null) {
            return null;
        }
        for (LexiconProcessor PROCESSOR : PROCESSORS) {
            value = PROCESSOR.format(value, lexicon);
        }
        return value;
    }

    private static Properties load(BModule module, String localeKey) {
        String key = Lexicon.getCommonKey(module, localeKey);
        Properties props = common.get(key);
        if (props == null) {
            return AccessController.doPrivileged(new LoadPrivilegedAction(key, module, localeKey));
        }
        return props;
    }

    private static void loadFromModule(BModule module, String localeKey) {
        String key = Lexicon.getCommonKey(module, localeKey);
        Properties props = common.get(key);
        if (props == null) {
            return;
        }
        try {
            InputStream[] in;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Load extended \"" + key + "\" for module " + module.getModuleName());
            }
            for (InputStream anIn : in = Lexicon.getInputStreamsFromModule(module, localeKey)) {
                props.load(anIn);
                anIn.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        common.put(key, Lexicon.trim(props));
    }

    private static String getCommonKey(BModule module, String localeKey) {
        StringBuilder s = new StringBuilder();
        s.append(module.getModuleName());
        if (localeKey != null) {
            s.append('-').append(localeKey);
        }
        return s.toString();
    }

    private static Properties trim(Properties props) {
        Properties trim = new Properties();
        props.entrySet().forEach(entry -> trim.setProperty((String)entry.getKey(), ((String)entry.getValue()).trim()));
        return trim;
    }

    public static InputStream getInputStreamFromModule(BModule module, String localeKey, boolean isDefault) throws Exception {
        for (LexiconInfo aLexRegistry : Sys.getRegistry().getLexicons(module.getModuleName(), localeKey)) {
            InputStream in;
            if (!isDefault || !aLexRegistry.isDefault() || (in = Lexicon.getInputStreamFromModule(aLexRegistry)) == null) continue;
            return in;
        }
        throw new BajaRuntimeException("No default lexicons found for " + module.getModuleName() + " for locale key " + localeKey);
    }

    public static InputStream[] getInputStreamsFromModule(BModule module, String localeKey) throws Exception {
        String m = module.getModuleName();
        ArrayList<InputStream> l = new ArrayList<InputStream>();
        for (LexiconInfo aLexRegistry : Sys.getRegistry().getLexicons(m, localeKey)) {
            InputStream in;
            if (aLexRegistry.isDefault() || (in = Lexicon.getInputStreamFromModule(aLexRegistry)) == null) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("  Adding module lexicon " + aLexRegistry.getContainerModuleName() + " to input stream list");
            }
            l.add(in);
        }
        if (l.isEmpty()) {
            throw new BajaRuntimeException("No lexicons found for " + m);
        }
        return l.toArray(new InputStream[0]);
    }

    public static InputStream getInputStreamFromModule(LexiconInfo li) throws Exception {
        PatternFilter brandMatch;
        String lexModule = li.getModuleName();
        String lexModulePath = li.getResourcePath();
        String lexContainer = li.getContainerModuleName();
        String lexBrandPattern = li.getBrandPattern();
        String brandId = null;
        try {
            brandId = Brand.getBrandId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!lexBrandPattern.isEmpty() && brandId != null && !(brandMatch = new PatternFilter(lexBrandPattern)).accept(brandId)) {
            log.warning("Lexicon loading: No brand match in module" + lexModule);
            return null;
        }
        if (lexModule == null || lexModule.isEmpty() || lexModulePath == null || lexModulePath.isEmpty() || lexContainer == null || lexContainer.isEmpty()) {
            throw new RegistryException("Unknown registry lexicon for " + lexModule);
        }
        BIFile lexFile = Lexicon.getExtendedFile(li);
        if (lexFile != null) {
            li.setLastModified(lexFile.getLastModified());
            return lexFile.getInputStream();
        }
        StringBuilder ordPath = new StringBuilder("module://");
        ordPath.append(lexContainer).append("/").append(lexModulePath);
        BOrd ord = BOrd.make(ordPath.toString());
        BIFile file = (BIFile)((Object)ord.resolve().get());
        li.setLastModified(file.getLastModified());
        return file.getInputStream();
    }

    public static InputStream getInputStream(BModule module, String localeKey) throws Exception {
        if (localeKey != null) {
            return Nre.bootEnv.read("/lexicon/" + localeKey + "/" + module.getModuleName() + ".lexicon");
        }
        ConcatenatedInputStream result = new ConcatenatedInputStream();
        boolean anyStores = false;
        for (RuntimeProfile profile : module.getRuntimeProfiles()) {
            BIFileStore store = Lexicon.getFileStore(module, profile);
            if (store == null) continue;
            anyStores = true;
            result.add(store::getInputStream);
            result.add(() -> new ByteArrayInputStream("\n".getBytes("UTF-8")));
        }
        if (!anyStores) {
            result.add(() -> new ByteArrayInputStream("\n".getBytes("UTF-8")));
        }
        return result;
    }

    protected static BIFileStore getFileStore(BModule module, RuntimeProfile profile) {
        String moduleName = module.getModuleName();
        if (BModuleScheme.isModuleDevEnabled()) {
            try {
                String body = "module://" + moduleName + "/" + module.getModulePartName(profile) + ".lexicon";
                BIFile file = (BIFile)((Object)BOrd.make(body).get());
                return file.getStore();
            }
            catch (Exception e) {
                log.log(Level.FINER, "Lexicon module scheme lookup failure for " + module, e);
            }
        }
        return module.findStore(new FilePath("module", String.format("/%s.lexicon", module.getModulePartName(profile))));
    }

    protected static BIFile getExtendedFile(LexiconInfo li) {
        String lexModule = li.getModuleName();
        String lexModulePath = li.getResourcePath();
        String lexContainer = li.getContainerModuleName();
        BModule containerModule = Lexicon.module(lexContainer);
        if (BModuleScheme.isModuleDevEnabled()) {
            try {
                String moduleName = containerModule.getModuleName();
                String body = "module://" + moduleName + "/" + lexModulePath;
                return (BIFile)((Object)BOrd.make(body).get());
            }
            catch (Exception e) {
                log.log(Level.FINER, "Lexicon module scheme lookup failure for " + li, e);
            }
        }
        return containerModule.findFile(new FilePath("module", lexModulePath));
    }

    public static void invalidateCache() {
        log.fine("Entire lexicon cache is being cleared");
        common.clear();
        extendedPropsModules.clear();
    }

    public static List<String[]> searchLexiconCache(String search) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("  Searching for Lexicon entries containing " + search);
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String key : common.keySet()) {
            Properties props = common.get(key);
            for (String propKey : props.stringPropertyNames()) {
                String value = props.getProperty(propKey);
                if (!value.contains(search)) continue;
                result.add(new String[]{key, propKey, value});
            }
        }
        return result;
    }

    public static class ConcatenatedInputStream
    extends InputStream {
        private List<InputStreamExceptionSupplier> suppliers = new ArrayList<InputStreamExceptionSupplier>();
        private Iterator<InputStreamExceptionSupplier> supplierIterator = null;
        private InputStream current = null;

        public void add(InputStreamExceptionSupplier supplier) {
            this.suppliers.add(supplier);
        }

        @Override
        public int read() throws IOException {
            while (true) {
                if (this.current != null) {
                    int result = this.current.read();
                    if (result == -1) {
                        this.current.close();
                        if (this.supplierIterator.hasNext()) {
                            this.current = this.supplierIterator.next().get();
                            continue;
                        }
                        this.current = null;
                        return -1;
                    }
                    return result;
                }
                if (this.supplierIterator == null) {
                    this.supplierIterator = this.suppliers.iterator();
                }
                if (!this.supplierIterator.hasNext()) break;
                this.current = this.supplierIterator.next().get();
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            if (this.current != null) {
                this.current.close();
            }
        }
    }

    public static interface InputStreamExceptionSupplier {
        public InputStream get() throws IOException;
    }

    private static class LoadPrivilegedAction
    implements PrivilegedAction<Properties> {
        private final String key;
        private final BModule module;
        private final String localeKey;

        private LoadPrivilegedAction(String key, BModule module, String localeKey) {
            this.key = key;
            this.module = module;
            this.localeKey = localeKey;
        }

        @Override
        public Properties run() {
            Properties props;
            block30: {
                Throwable throwable;
                InputStream in;
                block29: {
                    props = new Properties();
                    if (this.localeKey != null) {
                        try {
                            in = Lexicon.getInputStreamFromModule(this.module, this.localeKey, true);
                            throwable = null;
                            try {
                                props.load(in);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (in != null) {
                                    if (throwable != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            if ("en".equals(this.localeKey) || !log.isLoggable(Level.FINE)) break block29;
                            log.fine("Cannot load niagara default \"" + this.key + "\": " + e.getLocalizedMessage());
                        }
                    }
                }
                try {
                    in = Lexicon.getInputStream(this.module, this.localeKey);
                    throwable = null;
                    try {
                        props.load(in);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    if ("en".equals(this.localeKey) || !log.isLoggable(Level.FINE)) break block30;
                    log.log(Level.FINE, "Cannot load lexicon \"" + this.key + "\": " + e.getLocalizedMessage());
                }
            }
            props = Lexicon.trim(props);
            common.put(this.key, props);
            return props;
        }
    }

    private static class BrandLexiconTag
    extends LexiconTag {
        protected static String TAG = "brand";

        private BrandLexiconTag() {
        }

        @Override
        public String getTagName() {
            return TAG;
        }

        @Override
        public String getValue(String param, Lexicon lexicon) {
            String brandId;
            try {
                brandId = Brand.getBrandId();
            }
            catch (Exception e) {
                return null;
            }
            String[] lexArray = TextUtil.split((String)param, (char)':');
            if (lexArray.length == 3) {
                if (brandId.equalsIgnoreCase(lexArray[0].trim())) {
                    if (!lexArray[1].trim().equals(lexicon.module.getModuleName())) {
                        Lexicon brandLexicon = Lexicon.make(lexArray[1].trim());
                        return brandLexicon.getText(lexArray[2].trim());
                    }
                    return lexicon.getText(lexArray[2].trim());
                }
                return lexArray[2].trim();
            }
            if (lexArray.length == 2) {
                if (brandId.equalsIgnoreCase(lexArray[0].trim())) {
                    return lexicon.getText(lexArray[1].trim());
                }
                return lexArray[1].trim();
            }
            throw new BajaRuntimeException("Invalid parameters: " + param);
        }
    }

    private static class NestedLexiconTag
    extends LexiconTag {
        private static final String TAG = "lexicon";

        private NestedLexiconTag() {
        }

        @Override
        public String getTagName() {
            return TAG;
        }

        @Override
        public String getValue(String param, Lexicon lexicon) {
            String[] lexArray = TextUtil.split((String)param, (char)':');
            if (lexArray.length == 1) {
                return Lexicon.process(lexicon.get(lexArray[0].trim()), lexicon);
            }
            if (lexArray.length == 2) {
                Lexicon extLexicon = Lexicon.make(lexArray[0].trim(), lexicon.language, lexicon.country, lexicon.variant);
                if (extLexicon.module == null) {
                    return lexArray[1].trim();
                }
                return Lexicon.process(extLexicon.get(lexArray[1].trim()), extLexicon);
            }
            throw new BajaRuntimeException("Invalid parameters: " + param);
        }
    }

    private static abstract class LexiconTag
    extends LexiconProcessor {
        protected final String tagStart = "{" + this.getTagName() + ":";

        private LexiconTag() {
        }

        public abstract String getTagName();

        public abstract String getValue(String var1, Lexicon var2);

        @Override
        public final String format(String value, Lexicon lexicon) {
            while (value.contains(this.tagStart)) {
                int startIndex = value.indexOf(this.tagStart);
                int endIndex = value.indexOf("}", startIndex);
                StringBuilder buffer = new StringBuilder((int)((double)value.length() * 1.25));
                buffer.append(value.substring(0, startIndex));
                buffer.append(this.getValue(value.substring(startIndex + this.tagStart.length(), endIndex), lexicon));
                buffer.append(value.substring(endIndex + 1));
                value = buffer.toString();
            }
            return value;
        }
    }

    private static abstract class LexiconProcessor {
        private LexiconProcessor() {
        }

        public abstract String format(String var1, Lexicon var2);
    }
}

