/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.util.ICoalesceable;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;

public class CoalesceQueue
extends Queue {
    HashEntry[] table;
    int hashSize;
    int threshold;
    float loadFactor = 0.75f;

    public CoalesceQueue(int maxSize) {
        super(maxSize);
        this.table = new HashEntry[Math.max(16, Math.min(maxSize / 3, 101))];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
    }

    public CoalesceQueue() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public synchronized Object find(Object value) {
        HashEntry e;
        if (value instanceof ICoalesceable && (e = this.get((ICoalesceable)value)) != null) {
            return e.value;
        }
        return null;
    }

    @Override
    public synchronized Object dequeue() {
        Queue.Entry e = this.head;
        if (e == null) {
            return null;
        }
        super.dequeue();
        if (e.value instanceof ICoalesceable) {
            this.remove((ICoalesceable)e.value);
        }
        return e.value;
    }

    @Override
    public synchronized boolean enqueue(Object value) throws QueueFullException {
        ICoalesceable newc;
        HashEntry dup;
        if (value instanceof ICoalesceable && (dup = this.get(newc = (ICoalesceable)value)) != null) {
            ICoalesceable oldc = (ICoalesceable)dup.value;
            dup.value = oldc.coalesce(newc);
            return false;
        }
        return super.enqueue(value);
    }

    @Override
    Queue.Entry newEntry(Object value) {
        if (value instanceof ICoalesceable) {
            return this.put((ICoalesceable)value);
        }
        return new Queue.Entry(value);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.hashSize = 0;
        this.table = new HashEntry[this.table.length];
    }

    HashEntry get(ICoalesceable c) {
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        HashEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && ((ICoalesceable)e.value).getCoalesceKey().equals(key)) {
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    void rehash() {
        int oldCapacity = this.table.length;
        HashEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        HashEntry[] newTable = new HashEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            HashEntry old = oldTable[i];
            while (old != null) {
                HashEntry e = old;
                old = old.hashNext;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.hashNext = newTable[index];
                newTable[index] = e;
            }
        }
    }

    HashEntry put(ICoalesceable c) {
        if (this.hashSize >= this.threshold) {
            this.rehash();
            return this.put(c);
        }
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        HashEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashEntry e = new HashEntry(c);
        e.hash = hash;
        e.hashNext = tab[index];
        tab[index] = e;
        ++this.hashSize;
        return e;
    }

    Object remove(ICoalesceable c) {
        Object key = c.getCoalesceKey();
        int hash = key.hashCode();
        HashEntry[] tab = this.table;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        HashEntry e = tab[index];
        HashEntry prev = null;
        while (e != null) {
            if (e.hash == hash && ((ICoalesceable)e.value).getCoalesceKey().equals(key)) {
                if (prev != null) {
                    prev.hashNext = e.hashNext;
                } else {
                    tab[index] = e.hashNext;
                }
                --this.hashSize;
                return e.value;
            }
            prev = e;
            e = e.hashNext;
        }
        throw new IllegalStateException();
    }

    static class HashEntry
    extends Queue.Entry {
        int hash;
        HashEntry hashNext;

        HashEntry(Object v) {
            super(v);
        }
    }
}

