/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.CompUtil;
import com.tridium.util.ObjectUtil;
import java.util.stream.Stream;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="typeSpec", type="BTypeSpec", defaultValue="BTypeSpec.NULL")
public abstract class BTypeConfig
extends BVector {
    @Generated
    public static final Property typeSpec = BTypeConfig.newProperty(0, BTypeSpec.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeConfig.class);

    @Generated
    public BTypeSpec getTypeSpec() {
        return (BTypeSpec)this.get(typeSpec);
    }

    @Generated
    public void setTypeSpec(BTypeSpec v) {
        this.set(typeSpec, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract TypeInfo getTargetType();

    public BObject make() {
        BObject target = this.getTypeSpec().getInstance();
        this.syncTo(target);
        return target;
    }

    public void syncTo(BObject target) {
        if (!(target instanceof IConfigurable)) {
            throw new UnsupportedOperationException("Must override syncTo() if not using IConfigurable");
        }
        IConfigurable cfg = (IConfigurable)((Object)target);
        String[] keys = cfg.listConfig();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Property prop = this.getProperty(key);
            if (prop == null) continue;
            cfg.setConfig(key, this.get(prop));
        }
    }

    public void syncFrom(BObject target) {
        if (!(target instanceof IConfigurable)) {
            throw new UnsupportedOperationException("Must override syncFrom() if not using IConfigurable");
        }
        this.removeAll();
        IConfigurable cfg = (IConfigurable)((Object)target);
        String[] keys = cfg.listConfig();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            BValue value = cfg.getConfig(key);
            BFacets facets = cfg.getConfigFacets(key);
            this.add(SlotPath.escape(key), value, 1, facets, null);
        }
        this.updateModuleDependencies(false);
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        try {
            BObject target = this.getTypeSpec().getInstance();
            if (target instanceof IConfigurable) {
                String[] keys;
                IConfigurable cfg = (IConfigurable)((Object)target);
                for (String key : keys = cfg.listConfig()) {
                    String slotName = SlotPath.escape(key);
                    if (this.getSlot(slotName) != null) continue;
                    BValue value = cfg.getConfig(key);
                    BFacets slotFacets = cfg.getConfigFacets(key);
                    this.add(slotName, value, 1, slotFacets, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateModuleDependencies(false);
    }

    private void fwChanged(Property prop) {
        if (prop.equals(typeSpec)) {
            this.configChanged();
            this.updateModuleDependencies(false);
        }
    }

    public void configChanged() {
    }

    public final void updateModuleDependencies(boolean forceUpdate) {
        BComponentSpace space = this.getComponentSpace();
        if (!forceUpdate && (space == null || space.isProxyComponentSpace())) {
            return;
        }
        try {
            this.remove("moduleDependenciesFacets");
        }
        catch (NoSuchSlotException noSuchSlotException) {
            // empty catch block
        }
        BObject target = null;
        try {
            target = this.getTypeSpec().getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BFacets facets = BFacets.NULL;
        facets = target instanceof IConfigurable ? ObjectUtil.appendModuleDependencyFacets(facets, ((IConfigurable)((Object)target)).getModuleDependencyNames(this)) : ObjectUtil.appendModuleDependencyFacets(facets, Stream.of(this.getTypeSpec().getModuleName()));
        if (!facets.isNull()) {
            CompUtil.setOrAdd(this, "moduleDependenciesFacets", facets, 5, BFacets.NULL, null);
        }
    }

    public static interface IConfigurable {
        public String[] listConfig();

        public BValue getConfig(String var1);

        public BFacets getConfigFacets(String var1);

        public void setConfig(String var1, BValue var2);

        default public Stream<String> getModuleDependencyNames(BTypeConfig config) {
            return Stream.empty();
        }
    }
}

