/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.sys.Nre;
import com.tridium.util.EscUtil;
import com.tridium.util.FormatDenylist;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.BIEncodable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIFormatPropertyHandler;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BFormat
extends BSimple {
    public static final BFormat DEFAULT = new BFormat("");
    public static final Type TYPE = Sys.loadType(BFormat.class);
    static final Class<?>[] paramNone = new Class[0];
    static final Class<?>[] paramContext = new Class[]{Context.class};
    static final Class<?>[] paramString = new Class[]{String.class};
    static final Logger log = Logger.getLogger("sys.formatter");
    private static final int CLASS_CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.baja.formatCacheSize", "Workstation".equals(Nre.getHostModel()) ? 2048 : 64));
    private static final int METHOD_CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.baja.formatMethodCacheSize", "Workstation".equals(Nre.getHostModel()) ? 1024 : 64));
    private static final Map<Class<?>, Map<String, Optional<Method>>> classToMethodCache = Collections.synchronizedMap(new CacheMap(CLASS_CACHE_SIZE));
    String format;
    Object[] segments;
    private int hashCode = -1;
    private static final BFormat IDENTITY = new BFormat("%.%");

    public static String format(String format, Object obj) {
        return BFormat.make(format).format(obj, null);
    }

    public static String format(String format, Object obj, Context cx) {
        return BFormat.make(format).format(obj, cx);
    }

    public static String getEncodedPattern(BIEncodable enc) throws IOException {
        StringBuilder result = new StringBuilder();
        result.append("%decodeFromString(");
        result.append(enc.getType().getModule().getModuleName());
        result.append(':');
        result.append(enc.getType().getTypeName());
        result.append(':');
        result.append(SlotPath.escape(enc.encodeToString()));
        result.append(")%");
        return result.toString();
    }

    public static String getLexiconPattern(String module, String key, String[] argFormatStrings) {
        StringBuilder result = new StringBuilder();
        result.append("%lexicon(");
        result.append(module);
        result.append(':');
        result.append(key);
        if (argFormatStrings != null) {
            for (String argFormatString : argFormatStrings) {
                result.append(':');
                result.append(SlotPath.escape(argFormatString));
            }
        }
        result.append(")%");
        return result.toString();
    }

    public static BFormat make(String format) {
        if (format.isEmpty()) {
            return DEFAULT;
        }
        if ("%.%".equals(format)) {
            return IDENTITY;
        }
        return (BFormat)new BFormat(format).intern();
    }

    private BFormat(String format) {
        this.format = format;
    }

    public final String getFormat() {
        return this.format;
    }

    public final String format(Object obj) {
        return this.format(obj, null);
    }

    public final String format(Object obj, Context cx) {
        Object[] segments;
        StringBuilder s = new StringBuilder();
        for (Object segment : segments = this.parse()) {
            if (segment instanceof String) {
                s.append(segment);
                continue;
            }
            Call call = (Call)segment;
            try {
                s.append(call.eval(obj, obj, cx));
            }
            catch (Throwable e) {
                log.log(Level.FINE, "Could not format object", e);
                s.append(call.toErrorString(obj, obj, cx));
            }
        }
        return s.toString();
    }

    protected static Object[] parse(String format) {
        try {
            return BFormat.doParse(format);
        }
        catch (Exception e) {
            return new Object[]{"ERROR " + format};
        }
    }

    private static Object[] doParse(String format) throws Exception {
        ArrayList<Object> acc = new ArrayList<Object>();
        int len = format.length();
        StringBuilder cur = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = format.charAt(i);
            if (c != '%') {
                cur.append(c);
                continue;
            }
            if ((c = format.charAt(++i)) == '%') {
                cur.append('%');
                continue;
            }
            String str = cur.toString();
            if (str.length() > 0) {
                acc.add(str);
            }
            cur.setLength(0);
            Call head = null;
            Call tail = null;
            int firstParen = -1;
            int parenCount = 0;
            while (parenCount > 0 || format.charAt(i) != '%' && format.charAt(i) != '?') {
                if ((c = format.charAt(i++)) == '(') {
                    if (firstParen < 0) {
                        firstParen = cur.length();
                    }
                    ++parenCount;
                }
                if (c == ')') {
                    --parenCount;
                }
                if (c != '.' || parenCount > 0) {
                    cur.append(c);
                    continue;
                }
                tail = BFormat.parseCall(tail, cur.toString(), firstParen);
                if (head == null) {
                    head = tail;
                }
                cur.setLength(0);
                firstParen = -1;
            }
            tail = BFormat.parseCall(tail, cur.toString(), firstParen);
            if (head == null) {
                head = tail;
            }
            cur.setLength(0);
            if (format.charAt(i) == '?') {
                Call errHead = null;
                Call errTail = null;
                firstParen = -1;
                parenCount = 0;
                cur.setLength(0);
                ++i;
                while (parenCount > 0 || format.charAt(i) != '%') {
                    if ((c = format.charAt(i++)) == '(') {
                        if (firstParen < 0) {
                            firstParen = cur.length();
                        }
                        ++parenCount;
                    }
                    if (c == ')') {
                        --parenCount;
                    }
                    if (c != '.' || parenCount > 0) {
                        cur.append(c);
                        continue;
                    }
                    errTail = BFormat.parseCall(errTail, cur.toString(), firstParen);
                    if (errHead == null) {
                        errHead = errTail;
                    }
                    cur.setLength(0);
                    firstParen = -1;
                }
                errTail = BFormat.parseCall(errTail, cur.toString(), firstParen);
                if (errHead == null) {
                    errHead = errTail;
                }
                cur.setLength(0);
                head.error = errHead;
                Call cursor = head;
                while (cursor != tail) {
                    cursor = cursor.next;
                    cursor.error = head.error;
                }
            }
            acc.add(head);
        }
        String str = cur.toString();
        if (str.length() > 0) {
            acc.add(str);
        }
        return acc.toArray();
    }

    public Object[] parse() {
        if (this.segments == null) {
            this.segments = BFormat.parse(this.format);
        }
        return this.segments;
    }

    static Call parseCall(Call tail, String id, int firstParen) throws IOException {
        if (id.length() == 0) {
            return new IdentityCall(tail, id);
        }
        if (firstParen > 0) {
            if (id.equals("time()")) {
                return new TimeCall(tail, id);
            }
            if (id.equals("user()")) {
                return new UserCall(tail, id);
            }
            if (id.equals("sys()")) {
                return new SysCall(tail, id);
            }
            if (id.startsWith("escape(")) {
                return new EscapeCall(tail, id);
            }
            if (id.startsWith("unescape(")) {
                return new UnescapeCall(tail, id);
            }
            String arg = id.substring(firstParen + 1, id.length() - 1);
            if (id.startsWith("lexicon(")) {
                return new LexiconCall(tail, id, arg);
            }
            if (id.startsWith("substring(")) {
                return new SubstringCall(tail, id, arg);
            }
            if (id.startsWith("decodeFromString(")) {
                return new DecodeFromStringCall(tail, id, arg);
            }
        }
        return new ReflectCall(tail, id);
    }

    public static boolean evaluatingFormatContainsErrors(BFormat format, Object obj, Context cx) {
        try {
            Object[] segments;
            for (Object segment : segments = BFormat.doParse(format.format)) {
                if (!(segment instanceof Call)) continue;
                Call call = (Call)segment;
                call.eval(obj, obj, cx);
                while (call != null) {
                    if (call.getEvalFailed() || call.errorOccurred) {
                        return true;
                    }
                    call = call.next;
                }
            }
        }
        catch (Throwable t) {
            return true;
        }
        return false;
    }

    public void dump() {
        System.out.println("BFormat: " + this.format);
        for (int i = 0; i < this.parse().length; ++i) {
            Object seg = this.segments[i];
            if (seg instanceof String) {
                System.out.println(" [" + i + "] \"" + seg + "\"");
                continue;
            }
            if (seg instanceof Call) {
                System.out.println(" [" + i + "] " + seg + " " + TextUtil.getClassName(seg.getClass()));
                Call call = (Call)seg;
                if (call.error == null) continue;
                System.out.println("     - err: " + seg + " " + TextUtil.getClassName(seg.getClass()));
                continue;
            }
            System.out.println(" [" + i + "] " + seg + " " + TextUtil.getClassName(seg.getClass()));
        }
    }

    private static boolean hasPermission(BComplex complex, Slot slot, Context cx) {
        if (!complex.getType().is(BIProtected.TYPE)) {
            return true;
        }
        BPermissions permissions = ((BIProtected)((Object)complex)).getPermissions(cx);
        if (slot == null) {
            return permissions.hasOperatorRead();
        }
        if (Flags.isOperator(complex, slot)) {
            if (slot.isAction()) {
                return permissions.hasOperatorInvoke();
            }
            return permissions.hasOperatorRead() && BFormat.checkProtectedSlot(complex, slot, cx);
        }
        if (slot.isAction()) {
            return permissions.hasAdminInvoke();
        }
        return permissions.hasAdminRead() && BFormat.checkProtectedSlot(complex, slot, cx);
    }

    private static boolean checkProtectedSlot(BComplex complex, Slot slot, Context cx) {
        BValue child;
        if (slot.isProperty() && (child = complex.get((Property)slot)).getType().is(BIProtected.TYPE)) {
            BPermissions childPermissions = ((BIProtected)((Object)child)).getPermissions(cx);
            return childPermissions.hasOperatorRead();
        }
        return true;
    }

    private static String makeCacheKey(String methodName, Class<?>[] methodParams) {
        StringJoiner sj = new StringJoiner(":");
        sj.add(methodName);
        for (Class<?> param : methodParams) {
            sj.add(param.getName());
        }
        return sj.toString();
    }

    private static void invalidateCache(Class<?> cls) {
        classToMethodCache.computeIfPresent(cls, (c, m) -> Collections.synchronizedMap(new CacheMap(METHOD_CACHE_SIZE)));
    }

    private static Object reflect(Object obj, String name, Class<?>[] params, Object arg) throws Throwable {
        Class<?> cls = obj.getClass();
        try {
            String cacheKey = BFormat.makeCacheKey(name, params);
            Map methodMap = classToMethodCache.computeIfAbsent(cls, c -> Collections.synchronizedMap(new CacheMap(METHOD_CACHE_SIZE)));
            methodMap.computeIfAbsent(cacheKey, c -> {
                try {
                    if (FormatDenylist.isDenied(cls, name, params)) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Format attempted to call a denied method: " + cls.getName() + '.' + name);
                        }
                        return Optional.empty();
                    }
                    Method method = cls.getMethod(name, params);
                    if (method.getReturnType().equals(Void.TYPE)) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Format attempted to call a denied method that returns void: " + cls.getName() + '.' + name);
                        }
                        return Optional.empty();
                    }
                    return Optional.of(method);
                }
                catch (NoSuchMethodException e) {
                    return Optional.empty();
                }
            });
            Optional method = methodMap.getOrDefault(cacheKey, Optional.empty());
            if (method.isPresent()) {
                Object[] objectArray;
                if (params.length == 0) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = arg;
                }
                Object[] args = objectArray;
                return ((Method)method.get()).invoke(obj, args);
            }
            return null;
        }
        catch (Exception e) {
            BFormat.invalidateCache(cls);
            throw e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
        }
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BFormat) {
            BFormat x = (BFormat)obj;
            return this.format.equals(x.format);
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.format);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BFormat.make(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.format;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return BFormat.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static class UnescapeCall
    extends Call {
        UnescapeCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) {
            return EscUtil.slot.unescape(this.toString(obj, cx));
        }
    }

    static class EscapeCall
    extends Call {
        EscapeCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) {
            return EscUtil.slot.escape(this.toString(obj, cx));
        }
    }

    static class SubstringCall
    extends Call {
        String[] args;

        SubstringCall(Call prev, String id, String arg) {
            super(prev, id);
            this.args = TextUtil.splitAndTrim((String)arg, (char)',');
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            int i;
            String s = this.toString(obj, cx);
            s = this.args.length == 1 ? ((i = Integer.parseInt(this.args[0])) >= 0 ? s.substring(i) : s.substring(s.length() + i)) : s.substring(Integer.parseInt(this.args[0]), Integer.parseInt(this.args[1]));
            return this.chain(s, errorBase, cx);
        }
    }

    static class DecodeFromStringCall
    extends Call {
        BObject obj;

        DecodeFromStringCall(Call prev, String id, String arg) throws IOException {
            super(prev, id);
            int colon = arg.indexOf(58);
            String module = arg.substring(0, colon);
            arg = arg.substring(colon + 1);
            colon = arg.indexOf(58);
            String type = arg.substring(0, colon);
            BIEncodable enc = (BIEncodable)((Object)Sys.getType(module + ':' + type).getInstance());
            this.obj = enc.decodeFromString(SlotPath.unescape(arg.substring(colon + 1)));
        }

        @Override
        Object eval(Object ignored, Object errorBase, Context cx) {
            return this.obj;
        }
    }

    static class LexiconCall
    extends Call {
        String module;
        String key;
        String[] argFormats;

        LexiconCall(Call prev, String id, String arg) {
            super(prev, id);
            int colon = arg.indexOf(58);
            this.module = arg.substring(0, colon);
            arg = arg.substring(colon + 1);
            colon = arg.indexOf(58);
            if (colon >= 0) {
                this.key = arg.substring(0, colon);
                this.argFormats = TextUtil.split((String)arg.substring(colon + 1), (char)':');
            } else {
                this.key = arg;
                this.argFormats = null;
            }
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            if (this.argFormats == null) {
                return this.chain(Lexicon.make(this.module, cx).getText(this.key, obj), errorBase, cx);
            }
            Object[] args = new Object[this.argFormats.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = BFormat.format(SlotPath.unescape(this.argFormats[i]), obj, cx);
            }
            return this.chain(Lexicon.make(this.module, cx).getText(this.key, args), errorBase, cx);
        }
    }

    static class UserCall
    extends Call {
        UserCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            if (obj instanceof BComponent) {
                String username;
                BComponent comp = (BComponent)obj;
                Context sessionCx = comp.getSession().getSessionContext();
                if (sessionCx != null) {
                    username = ((BFacets)sessionCx).gets("username", null);
                } else if (cx.getUser() != null) {
                    username = cx.getUser().getUsername();
                } else {
                    throw new BajaRuntimeException("Username unavailable");
                }
                if (username != null && username.length() > 0) {
                    return this.chain(username, errorBase, cx);
                }
            }
            return this.chain(null, errorBase, cx);
        }
    }

    static class SysCall
    extends Call {
        SysCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            return this.chain(new Sys(), errorBase, cx);
        }
    }

    static class TimeCall
    extends Call {
        TimeCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            return this.chain(Clock.time(), errorBase, cx);
        }
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public CacheMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    public static class ReflectCall
    extends Call {
        ReflectCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        public Object eval(Object obj, Object errorBase, Context cx) throws Throwable {
            Property prop;
            String getId;
            Object r;
            BComplex complex;
            if (obj instanceof BPassword || obj instanceof BAbstractAuthenticator || obj instanceof BAbstractPasswordEncoder) {
                return this.toErrorString(obj, errorBase, cx);
            }
            BComplex bComplex = complex = obj instanceof BComplex ? (BComplex)obj : null;
            if (complex != null) {
                if (!BFormat.hasPermission(complex, null, cx)) {
                    return this.toErrorString(obj, errorBase, cx);
                }
                Property prop2 = complex.getProperty(this.id);
                if (prop2 == null) {
                    Slot slot;
                    String slotName = this.id;
                    if (this.id.startsWith("get")) {
                        slotName = TextUtil.decapitalize((String)this.id.substring(3));
                    } else if (this.id.startsWith("do")) {
                        slotName = TextUtil.decapitalize((String)this.id.substring(2));
                    } else if (this.id.startsWith("fire")) {
                        slotName = TextUtil.decapitalize((String)this.id.substring(4));
                    }
                    if (slotName != null && (slot = complex.getSlot(slotName)) != null && slot.isFrozen()) {
                        Class<?> objCls;
                        if (!BFormat.hasPermission(complex, slot, cx)) {
                            return this.toErrorString(obj, errorBase, cx);
                        }
                        if (slot.isAction() && !FormatDenylist.isExcludedFromDenylist(objCls = obj.getClass(), slotName, null) && !slotName.equals(this.id) && !FormatDenylist.isExcludedFromDenylist(objCls, this.id, null)) {
                            String result = this.toErrorString(obj, errorBase, cx);
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Format attempted to call a denied action: " + objCls.getName() + '.' + this.id);
                            }
                            return result;
                        }
                    }
                }
                if (prop2 != null) {
                    if (!BFormat.hasPermission(complex, prop2, cx)) {
                        return this.toErrorString(obj, errorBase, cx);
                    }
                    cx = new BasicContext(cx, complex.getSlotFacets(prop2));
                    if (this.next == null) {
                        return complex.get(prop2).toString(cx);
                    }
                }
            }
            if ((r = BFormat.reflect(obj, getId = "get" + TextUtil.capitalize((String)this.id), paramContext, cx)) != null) {
                return this.chain(r, errorBase, cx);
            }
            r = BFormat.reflect(obj, getId, paramNone, null);
            if (r != null) {
                return this.chain(r, errorBase, cx);
            }
            r = BFormat.reflect(obj, this.id, paramContext, cx);
            if (r != null) {
                return this.chain(r, errorBase, cx);
            }
            r = BFormat.reflect(obj, this.id, paramNone, null);
            if (r != null) {
                return this.chain(r, errorBase, cx);
            }
            r = BFormat.reflect(obj, "get", paramString, this.id);
            if (r != null) {
                return this.chain(r, errorBase, cx);
            }
            r = BFormat.reflect(obj, "getFormatValue", paramString, this.id);
            if (r != null) {
                return this.chain(r, errorBase, cx);
            }
            if (complex != null && obj instanceof BIFormatPropertyHandler && (prop = ((BIFormatPropertyHandler)obj).getFormatPropertyByName(this.id)) != null) {
                if (!BFormat.hasPermission(complex, prop, cx)) {
                    return this.toErrorString(obj, errorBase, cx);
                }
                cx = new BasicContext(cx, complex.getSlotFacets(prop));
                BValue value = complex.get(prop);
                if (value != null) {
                    if (this.next == null) {
                        return value.toString(cx);
                    }
                    return this.chain(value, errorBase, cx);
                }
            }
            this.evalFailed = true;
            return this.toErrorString(obj, errorBase, cx);
        }
    }

    static class IdentityCall
    extends Call {
        IdentityCall(Call prev, String id) {
            super(prev, id);
        }

        @Override
        Object eval(Object obj, Object errorBase, Context cx) {
            if (obj instanceof BObject) {
                return ((BObject)obj).toString(cx);
            }
            return obj;
        }
    }

    public static abstract class Call {
        String id;
        Call next;
        Call error = null;
        boolean evalFailed = false;
        boolean errorOccurred;

        Call(Call prev, String id) {
            if (prev != null) {
                prev.next = this;
            }
            this.id = id;
        }

        public final String toString() {
            if (this.next == null) {
                return this.id;
            }
            return this.id + "." + this.next;
        }

        String toString(Object obj, Context cx) {
            if (obj instanceof BObject) {
                return ((BObject)obj).toString(cx);
            }
            return String.valueOf(obj);
        }

        String toErrorString(Object obj, Object errorBase, Context cx) {
            this.errorOccurred = true;
            if (this.error != null) {
                try {
                    return this.error.eval(errorBase, errorBase, cx).toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String type = obj == null ? "null" : (obj instanceof BObject ? ((BObject)obj).getType().toString() : TextUtil.getClassName(obj.getClass()));
            return "%err:" + type + ":" + this.id + "%";
        }

        abstract Object eval(Object var1, Object var2, Context var3) throws Throwable;

        final Object chain(Object base, Object errorBase, Context cx) throws Throwable {
            if (this.next != null) {
                return this.next.eval(base, errorBase, cx);
            }
            return this.toString(base, cx);
        }

        public boolean getEvalFailed() {
            return this.evalFailed;
        }
    }
}

