/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BBitSet
extends BSimple {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final BBitSet EMPTY;
    public static final BBitSet DEFAULT;
    public static final Type TYPE;
    private byte[] bits;
    private int hashCode = 0;

    public static BBitSet make(BBitSet orig, int index, boolean state) {
        if (orig.getBit(index) == state) {
            return orig;
        }
        int byteIndex = index >> 3;
        int bitMask = 1 << index % 8;
        int len = Math.max(orig.bits.length, byteIndex + 1);
        byte[] bits = new byte[len];
        System.arraycopy(orig.bits, 0, bits, 0, orig.bits.length);
        if (state) {
            int n = byteIndex;
            bits[n] = (byte)(bits[n] | bitMask);
        } else {
            int n = byteIndex;
            bits[n] = (byte)(bits[n] & ~bitMask);
        }
        return (BBitSet)new BBitSet(bits).intern();
    }

    private BBitSet(byte[] bits) {
        this.bits = bits;
    }

    public boolean getBit(int index) {
        int byteIndex = index >> 3;
        int bitMask = 1 << index % 8;
        if (byteIndex >= this.bits.length) {
            return false;
        }
        return (this.bits[byteIndex] & bitMask) != 0;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int h = 31;
            byte[] v = this.bits;
            for (int i = 0; i < v.length; ++i) {
                h = 31 * h + v[i];
            }
            this.hashCode = h;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BBitSet) {
            BBitSet x = (BBitSet)obj;
            int min = Math.min(this.bits.length, x.bits.length);
            for (int i = 0; i < min; ++i) {
                if (this.bits[i] == x.bits[i]) continue;
                return false;
            }
            BBitSet more = min == this.bits.length ? x : this;
            for (int i = min; i < more.bits.length; ++i) {
                if (more.bits[i] == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return "0x" + this.encodeToString();
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        StringBuilder s = new StringBuilder(this.bits.length * 2 + 2);
        boolean nonzero = false;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            int b = this.bits[i] & 0xFF;
            if (!nonzero) {
                if (b == 0) continue;
                nonzero = true;
            }
            if (b < 16) {
                s.append('0');
            } else {
                s.append(hexChars[b >> 4 & 0xF]);
            }
            s.append(hexChars[b & 0xF]);
        }
        if (!nonzero) {
            return "00";
        }
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            byte[] bits = new byte[s.length() / 2];
            for (int i = 0; i < s.length(); i += 2) {
                int hi = TextUtil.hexCharToInt((char)s.charAt(i));
                int lo = TextUtil.hexCharToInt((char)s.charAt(i + 1));
                bits[bits.length - i / 2 - 1] = (byte)(hi << 4 | lo);
            }
            return new BBitSet(bits).intern();
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid BBitSet: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = EMPTY = (BBitSet)new BBitSet(new byte[0]).intern();
        TYPE = Sys.loadType(BBitSet.class);
    }
}

