/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserService;

public final class UserMonitor {
    private BComponent comp;
    private UserSubscriber subscriber = new UserSubscriber();

    UserMonitor(BComponent comp) {
        if (comp.getTopic("userEvent") == null) {
            throw new BajaRuntimeException("Component must implement userEvent Topic!");
        }
        this.comp = comp;
    }

    void fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 13: {
                this.fwDecendantsStarted();
                break;
            }
            case 14: {
                this.fwDecendantsStopped();
                break;
            }
            case 3: {
                this.fwAdded((Property)a, (Context)b);
                break;
            }
            case 4: {
                this.fwRemoved((Property)a, (BValue)b, (Context)c);
                break;
            }
            case 5: {
                this.fwRenamed((Property)a, (String)b, (Context)c);
                break;
            }
            case 2: {
                this.fwChanged((Property)a, (Context)b);
            }
        }
    }

    void setModified(BUser user) {
        user.updateVersion();
        this.fireUserEvent(new BUserEvent(2, user));
    }

    private void fwDecendantsStarted() {
        this.subscribeToAllUsers();
    }

    private void fwDecendantsStopped() {
        this.subscriber.unsubscribeAll();
    }

    private void fwAdded(Property prop, Context cx) {
        if (prop.getType().is(BUser.TYPE)) {
            BUser user = (BUser)this.comp.get(prop);
            if (user.getParent() instanceof BUserService && user.getAuthenticator() instanceof BPasswordAuthenticator) {
                ((BPasswordAuthenticator)user.getAuthenticator()).convertToPbkdf2Password();
            }
            if (!this.comp.isRunning()) {
                return;
            }
            this.subscriber.subscribe(user, 10);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeAdded(user));
        }
    }

    private void fwRemoved(Property prop, BValue oldValue, Context cx) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (prop.getType().is(BUser.TYPE)) {
            BUser user = (BUser)oldValue;
            this.subscriber.unsubscribe(user);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeRemoved(user, prop.getName()));
        }
    }

    private void fwRenamed(Property prop, String oldName, Context cx) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (prop.getType().is(BUser.TYPE)) {
            BUser user = (BUser)this.comp.get(prop);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeRenamed(user, oldName));
        }
    }

    private void fwChanged(Property prop, Context cx) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (prop.getType().is(BUser.TYPE)) {
            BUser user = (BUser)this.comp.get(prop);
            if (user.getParent() instanceof BUserService && user.getAuthenticator() instanceof BPasswordAuthenticator) {
                ((BPasswordAuthenticator)user.getAuthenticator()).convertToPbkdf2Password();
            }
            this.subscriber.subscribe(user, 10);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeModified(user));
        }
    }

    private void subscribeToAllUsers() {
        this.subscriber.unsubscribeAll();
        SlotCursor<Property> c = this.comp.getProperties();
        while (c.next(BUser.class)) {
            BUser user = (BUser)c.get();
            this.subscriber.subscribe(user, 10);
        }
    }

    private void cleanupSubscriptions() {
        BComponent[] comps = this.subscriber.getSubscriptions();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i].isMounted()) continue;
            this.subscriber.unsubscribe(comps[i]);
        }
    }

    private void fireUserEvent(BUserEvent event) {
        this.comp.fire(this.comp.getTopic("userEvent"), event);
    }

    private class UserSubscriber
    extends Subscriber {
        private UserSubscriber() {
        }

        @Override
        public void event(BComponentEvent event) {
            int eid = event.getId();
            BUser user = this.getUser(event);
            if (user == null) {
                return;
            }
            switch (eid) {
                case 0: 
                case 1: {
                    if (event.getSlot() == BUser.version) break;
                }
                case 2: 
                case 3: 
                case 6: {
                    BUserEvent evt = new BUserEvent(2, user);
                    user.updateVersion();
                    UserMonitor.this.fireUserEvent(evt);
                }
            }
        }

        private BUser getUser(BComponentEvent event) {
            BComplex user;
            BComponent src = event.getSourceComponent();
            if (src instanceof BUser) {
                return (BUser)src;
            }
            for (user = src.getParent(); user != null && !(user instanceof BUser); user = user.getParent()) {
            }
            return (BUser)user;
        }
    }
}

