/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import java.util.ArrayList;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypeProperty;
import javax.baja.user.BUserService;
import javax.baja.user.UserMonitor;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="defaultPrototype", type="BUser", defaultValue="makeDefaultPrototype()"), @NiagaraProperty(name="alternateDefaultPrototype", type="String", defaultValue="defaultPrototype", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:UserPrototypeFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"webEditors:UserPrototypeEditor\"")})})
@NiagaraTopic(name="userEvent", eventType="BUserEvent")
public class BUserPrototypes
extends BComponent
implements IPropertyValidator {
    @Generated
    public static final Property defaultPrototype = BUserPrototypes.newProperty(0, BUserPrototypes.makeDefaultPrototype(), null);
    @Generated
    public static final Property alternateDefaultPrototype = BUserPrototypes.newProperty(0, "defaultPrototype", BFacets.make(BFacets.make("fieldEditor", "workbench:UserPrototypeFE"), BFacets.make("uxFieldEditor", "webEditors:UserPrototypeEditor")));
    @Generated
    public static final Topic userEvent = BUserPrototypes.newTopic(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUserPrototypes.class);
    private PrototypeSubscriber subscriber = new PrototypeSubscriber();
    private UserMonitor monitor = new UserMonitor(this);
    private static final BIcon icon = BIcon.std("profile.png");

    @Generated
    public BUser getDefaultPrototype() {
        return (BUser)this.get(defaultPrototype);
    }

    @Generated
    public void setDefaultPrototype(BUser v) {
        this.set(defaultPrototype, (BValue)v, null);
    }

    @Generated
    public String getAlternateDefaultPrototype() {
        return this.getString(alternateDefaultPrototype);
    }

    @Generated
    public void setAlternateDefaultPrototype(String v) {
        this.setString(alternateDefaultPrototype, v, null);
    }

    @Generated
    public void fireUserEvent(BUserEvent event) {
        this.fire(userEvent, event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BUser makeDefaultPrototype() {
        BUser proto = new BUser();
        Property[] localProps = new Property[]{BUser.permissions, BUser.roles, BUser.navFile};
        for (int i = 0; i < localProps.length; ++i) {
            proto.setFlags(localProps[i], 0x10000000 | proto.getFlags(localProps[i]));
        }
        return proto;
    }

    public String[] getPrototypeNames() {
        ArrayList<String> protos = new ArrayList<String>();
        SlotCursor<Property> c = this.getProperties();
        while (c.next(BUser.class)) {
            if (c.property() == defaultPrototype) continue;
            protos.add(c.property().getName());
        }
        return protos.toArray(new String[0]);
    }

    public BComponent[] getPrototypes() {
        ArrayList<BComponent> protos = new ArrayList<BComponent>();
        SlotCursor<Property> c = this.getProperties();
        while (c.next()) {
            BValue prot = c.get();
            if (!(prot instanceof BUser) && !(prot instanceof BUserPrototype)) continue;
            protos.add((BComponent)prot);
        }
        return protos.toArray(new BComponent[0]);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public final IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (this.isRunning() && context != null && context.getUser() != null) {
            return this;
        }
        return null;
    }

    @Override
    public final void validateSet(Validatable validatable, Context context) {
        if (this.isRunning() && context != null && context.getUser() != null) {
            Property[] props;
            for (Property prop : props = validatable.getModifiedProperties()) {
                String oldRoles = "";
                BValue existing = validatable.getExistingValue(prop);
                if (existing instanceof BUser || existing instanceof BUserPrototype) {
                    oldRoles = existing instanceof BUserPrototype ? ((BUserPrototype)existing).getRoles().getValue().toString() : ((BUser)existing).getRoles();
                }
                BUserPrototypes.checkRoleChange(validatable.getProposedValue(prop), oldRoles, context);
            }
        }
    }

    @Override
    public final void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (this.isRunning()) {
            BUserPrototypes.checkRoleChange(value, "", context);
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    @Override
    public final void checkRename(Property property, String newName, Context context) {
        if (this.isRunning()) {
            BUserPrototypes.checkRoleChange(this.get(property), "", context);
        }
        super.checkRename(property, newName, context);
    }

    static void checkRoleChange(BValue value, String oldRoles, Context context) {
        if (context != null && context != Context.decoding && context.getUser() != null && (value instanceof BUser || value instanceof BUserPrototype)) {
            String newRoles = value instanceof BUserPrototype ? ((BUserPrototype)value).getRoles().getValue().toString() : ((BUser)value).getRoles();
            BUser.checkRoleChange(context.getUser(), oldRoles, newRoles);
        }
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (this.monitor != null) {
            this.monitor.fw(x, a, b, c, d);
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public void added(Property property, Context context) {
        BValue added = this.get(property);
        if (this.isRunning() && (added instanceof BUser || added instanceof BUserPrototype)) {
            this.subscribePrototype((BComponent)added);
        }
    }

    @Override
    public void started() throws Exception {
        BComponent[] prototypes = this.getPrototypes();
        for (int i = 0; i < prototypes.length; ++i) {
            this.subscribePrototype(prototypes[i]);
        }
        super.started();
    }

    private void subscribePrototype(BComponent prototype) {
        this.subscriber.subscribe(prototype);
        SlotCursor<Property> properties = prototype.getProperties();
        while (properties.next()) {
            BValue bObject = properties.get();
            if (!(bObject instanceof BComponent)) continue;
            this.subscriber.subscribe((BComponent)bObject);
        }
    }

    private class PrototypeSubscriber
    extends Subscriber {
        private PrototypeSubscriber() {
        }

        @Override
        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                BComponent source;
                BComponent prototype = null;
                if (source instanceof BUser || source instanceof BUserPrototype) {
                    prototype = source;
                } else {
                    for (source = event.getSourceComponent(); null != source && !(source instanceof BUser) && !(source instanceof BUserPrototype); source = (BComponent)source.getParent()) {
                    }
                    if (source instanceof BUser || source instanceof BUserPrototype) {
                        prototype = source;
                    } else {
                        return;
                    }
                }
                String prototypeName = prototype.getName();
                BUserService userService = (BUserService)Sys.getService(BUserService.TYPE);
                BUser[] users = userService.getChildren(BUser.class);
                for (int i = 0; i < users.length; ++i) {
                    BUser user = users[i];
                    BAuthenticationScheme scheme = userService.getAuthenticationSchemeForUser(user);
                    if (!user.getPrototypeName().equals(prototypeName) || !scheme.supportsRemoteUsers()) continue;
                    if (prototype instanceof BUser) {
                        BUser userProto = (BUser)prototype.newCopy(true);
                        String name = user.getName();
                        userProto.setAuthenticator((BAbstractAuthenticator)user.getAuthenticator().newCopy());
                        userProto.setAuthenticationSchemeName(scheme.getName());
                        userProto.setPrototypeName(prototypeName);
                        userService.set(name, (BValue)userProto);
                        continue;
                    }
                    if (!(prototype instanceof BUserPrototype)) continue;
                    SlotCursor<Property> c = prototype.getProperties();
                    while (c.next(BUserPrototypeProperty.class)) {
                        BUserPrototypeProperty prop = (BUserPrototypeProperty)c.get();
                        Slot userSlot = user.getSlot(prop.getName());
                        if (userSlot == null) continue;
                        if (prop.getOverridable()) {
                            user.setFlags(userSlot, user.getFlags(userSlot) & 0xFFFFFFFE);
                            continue;
                        }
                        user.setFlags(userSlot, user.getFlags(userSlot) | 1);
                    }
                }
            }
        }
    }
}

