/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraEnum(range={@Range(value="preferShortest"), @Range(value="useFirst")})
public final class BAutoLogoffSettingsMergeMode
extends BFrozenEnum {
    @Generated
    public static final int PREFER_SHORTEST = 0;
    @Generated
    public static final int USE_FIRST = 1;
    @Generated
    public static final BAutoLogoffSettingsMergeMode preferShortest = new BAutoLogoffSettingsMergeMode(0);
    @Generated
    public static final BAutoLogoffSettingsMergeMode useFirst = new BAutoLogoffSettingsMergeMode(1);
    @Generated
    public static final BAutoLogoffSettingsMergeMode DEFAULT = preferShortest;
    @Generated
    public static final Type TYPE = Sys.loadType(BAutoLogoffSettingsMergeMode.class);

    @Generated
    public static BAutoLogoffSettingsMergeMode make(int ordinal) {
        return (BAutoLogoffSettingsMergeMode)preferShortest.getRange().get(ordinal, false);
    }

    @Generated
    public static BAutoLogoffSettingsMergeMode make(String tag) {
        return (BAutoLogoffSettingsMergeMode)preferShortest.getRange().get(tag);
    }

    @Generated
    private BAutoLogoffSettingsMergeMode(int ordinal) {
        super(ordinal);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAutoLogoffSettings getMergedValue(BAutoLogoffSettings currentAutoLogoffSettings, BAutoLogoffSettings proposedAutoLogoffSettings) {
        if (currentAutoLogoffSettings == null || proposedAutoLogoffSettings == null) {
            throw new IllegalArgumentException("currentAutoLogoffSettings and proposedAutoLogoffSettings cannot be null");
        }
        switch (this.getOrdinal()) {
            case 0: {
                return (BAutoLogoffSettings)this.getShortestAutoLogoffSettings(currentAutoLogoffSettings, proposedAutoLogoffSettings).newCopy();
            }
        }
        return (BAutoLogoffSettings)currentAutoLogoffSettings.newCopy();
    }

    private BAutoLogoffSettings getShortestAutoLogoffSettings(BAutoLogoffSettings autoLogoffSettings1, BAutoLogoffSettings autoLogoffSettings2) {
        if (!autoLogoffSettings1.getAutoLogoffEnabled()) {
            return autoLogoffSettings2;
        }
        if (!autoLogoffSettings2.getAutoLogoffEnabled()) {
            return autoLogoffSettings1;
        }
        if (autoLogoffSettings1.getUseDefaultAutoLogoffPeriod() && autoLogoffSettings2.getUseDefaultAutoLogoffPeriod()) {
            return autoLogoffSettings1;
        }
        if (autoLogoffSettings1.getUseDefaultAutoLogoffPeriod()) {
            BUserService userService = BUserService.getService();
            if (userService.getDefaultAutoLogoffPeriod().compareTo(autoLogoffSettings2.getAutoLogoffPeriod()) <= 0) {
                return autoLogoffSettings1;
            }
            return autoLogoffSettings2;
        }
        if (autoLogoffSettings2.getUseDefaultAutoLogoffPeriod()) {
            BUserService userService = BUserService.getService();
            if (userService.getDefaultAutoLogoffPeriod().compareTo(autoLogoffSettings1.getAutoLogoffPeriod()) <= 0) {
                return autoLogoffSettings2;
            }
            return autoLogoffSettings1;
        }
        if (autoLogoffSettings1.getAutoLogoffPeriod().compareTo(autoLogoffSettings2.getAutoLogoffPeriod()) <= 0) {
            return autoLogoffSettings1;
        }
        return autoLogoffSettings2;
    }
}

