/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Map;
import javax.baja.log.Log;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class UnitDifferentialConverter {
    static Map<String, BUnit> byDifferential = new HashMap<String, BUnit>();
    static Map<String, BUnit> byAbsolute = new HashMap<String, BUnit>();
    private static UnitDifferentialConverter INSTANCE = new UnitDifferentialConverter();

    private UnitDifferentialConverter() {
        try {
            XElem root = null;
            try {
                root = AccessController.doPrivileged(() -> XParser.make((InputStream)Nre.bootEnv.read("/defaults/unitDifferentialConversion.xml")).parse());
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            XElem[] converts = root.elems();
            for (int i = 0; i < converts.length; ++i) {
                XElem x = converts[i];
                try {
                    BUnit differential = UnitDatabase.getUnit(x.get("differential"));
                    BUnit absolute = UnitDatabase.getUnit(x.get("absolute"));
                    byDifferential.put(differential.getUnitName(), absolute);
                    byAbsolute.put(absolute.getUnitName(), differential);
                    continue;
                }
                catch (Exception e) {
                    Log.getLog("sys.unitConversion").warning("Parsing convert [line " + x.line() + "]", e);
                }
            }
        }
        catch (Exception e) {
            Log.getLog("sys.unitConversion").error("Error parsing unitDifferentialConversion.xml", e);
        }
    }

    public BUnit getDifferential(BUnit absolute) {
        BUnit differential = byAbsolute.get(absolute.getUnitName());
        if (differential != null) {
            return differential;
        }
        return absolute;
    }

    public BUnit getAbsolute(BUnit differential) {
        BUnit absolute = byDifferential.get(differential.getUnitName());
        if (absolute != null) {
            return absolute;
        }
        return differential;
    }

    public static UnitDifferentialConverter getInstance() {
        return INSTANCE;
    }
}

