/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;

public interface Tags
extends Iterable<Tag> {
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public boolean contains(Id id) {
        return this.get(id).isPresent();
    }

    public boolean isMulti(Id var1);

    public boolean set(Tag var1);

    default public boolean set(Id id, BIDataValue value) {
        return this.set(new Tag(id, value));
    }

    public boolean setMulti(Id var1, Collection<? extends BIDataValue> var2);

    public boolean addMulti(Id var1, Collection<? extends BIDataValue> var2);

    default public boolean addMulti(Tag tag) {
        return this.addMulti(tag.getId(), Collections.singletonList(tag.getValue()));
    }

    default public boolean addMulti(Id id, BIDataValue value) {
        return this.addMulti(new Tag(id, value));
    }

    default public boolean merge(Collection<Tag> tags) {
        if (tags.isEmpty()) {
            return false;
        }
        Map grouped = tags.stream().collect(Collectors.groupingBy(Tag::getId, Collectors.mapping(Tag::getValue, Collectors.toList())));
        boolean changed = false;
        for (Map.Entry entry : grouped.entrySet()) {
            Id id = entry.getKey();
            List values = entry.getValue();
            if (this.isMulti(id) || values.size() > 1) {
                changed |= this.addMulti(id, values);
                continue;
            }
            changed |= this.set(id, (BIDataValue)values.get(0));
        }
        return changed;
    }

    public boolean remove(Id var1, BIDataValue var2);

    default public boolean removeAll(Id id) {
        boolean changed = false;
        for (Tag t : this.filter(it -> it.getId().equals(id))) {
            changed |= this.remove(t);
        }
        return changed;
    }

    default public boolean remove(Tag tag) {
        return this.remove(tag.getId(), tag.getValue());
    }

    public Collection<Tag> filter(Predicate<Tag> var1);

    default public Collection<Tag> getAll() {
        return this.filter(Objects::nonNull);
    }

    public Optional<BIDataValue> get(Id var1);

    default public Collection<BIDataValue> getValues(Id id) {
        return this.getAll().stream().filter((? super T tag) -> tag.getId().equals(id)).map(Tag::getValue).collect(Collectors.toList());
    }

    default public Collection<Tag> getInDictionary(String dictionary) {
        return this.getAll().parallelStream().filter((? super T tag) -> tag.getId().getDictionary().equals(dictionary)).collect(Collectors.toList());
    }

    @Override
    default public Iterator<Tag> iterator() {
        return this.getAll().iterator();
    }
}

