/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.naming.SlotPath;

public final class Id
implements Comparable<Id> {
    public static final String NO_DICT = "";
    public static final char DICT_SEP = ':';
    private final String dictionary;
    private final String name;
    private static final Map<String, String> dictionaries = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> names = new ConcurrentHashMap<String, String>();

    public static Id newId(String qname) {
        Objects.requireNonNull(qname);
        int sepIdx = qname.indexOf(58);
        if (sepIdx == 0) {
            throw new IllegalArgumentException(String.format("qname cannot start with '%c'. %s", Character.valueOf(':'), qname));
        }
        String dictionary = NO_DICT;
        String name = qname;
        if (sepIdx > 0) {
            dictionary = qname.substring(0, sepIdx);
            name = qname.substring(sepIdx + 1);
        }
        return new Id(dictionary, name);
    }

    public static Id newId(String dictionary, String name) {
        return new Id(dictionary, name);
    }

    private Id(String dictionary, String name) {
        Id.verifyTagId(dictionary, name);
        this.dictionary = dictionaries.computeIfAbsent(dictionary, v -> dictionary);
        this.name = names.computeIfAbsent(name, v -> name);
    }

    public static void verifyTagId(String dictionary, String name) {
        Objects.requireNonNull(dictionary);
        Objects.requireNonNull(name);
        if (dictionary.indexOf(58) >= 0) {
            throw new IllegalArgumentException(String.format("dictionary name cannot contain '%c'. %s ", Character.valueOf(':'), dictionary));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("tag name is empty.");
        }
        if (name.indexOf(58) >= 0) {
            throw new IllegalArgumentException(String.format("tag name cannot contain '%c'. %s", Character.valueOf(':'), name));
        }
    }

    public String getDictionary() {
        return this.dictionary;
    }

    public boolean hasDictionary() {
        return !NO_DICT.equals(this.dictionary);
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        return this.hasDictionary() ? this.dictionary + ':' + this.name : this.name;
    }

    public String toString() {
        return this.getQName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Id tagId = (Id)o;
        if (!this.name.equals(tagId.name)) {
            return false;
        }
        return this.dictionary.equals(tagId.dictionary);
    }

    public int hashCode() {
        int result = this.dictionary.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public int compareTo(Id o) {
        Objects.requireNonNull(o, "cannot compare null tag");
        if (this.equals(o)) {
            return 0;
        }
        int result = this.dictionary.compareTo(o.dictionary);
        if (result == 0) {
            result = this.name.compareTo(o.name);
        }
        return result;
    }

    public static String idToFacetKey(Id id) {
        return SlotPath.escape(id.getQName());
    }

    public static String idToFacetKey(String id) {
        return SlotPath.escape(Id.newId(id).getQName());
    }

    public static Id facetKeyToId(String facetKey) {
        return Id.newId(SlotPath.unescape(facetKey));
    }
}

