/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public abstract class TypeSubscriber {
    private List<Type> subscriptions = new ArrayList<Type>();
    private BComponentSpace space;
    private BComponentEventMask mask = BComponentEventMask.SELF_EVENTS;

    protected TypeSubscriber(BComponentSpace space) {
        this.space = space;
    }

    public final synchronized boolean isSubscribed(Type t) {
        return this.subscriptions.contains(t);
    }

    public final synchronized boolean isSubscribed(Type[] t) {
        for (int i = 0; i < t.length; ++i) {
            if (this.isSubscribed(t[i])) continue;
            return false;
        }
        return true;
    }

    public final int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    public final synchronized Type[] getSubscriptions() {
        return this.subscriptions.toArray(new Type[0]);
    }

    public final synchronized void subscribe(Type t, Context cx) {
        if (!t.is(BComponent.TYPE)) {
            throw new InvalidParameterException(t + " is not a BComponent type");
        }
        this.subscribe(new Type[]{t}, cx);
    }

    public final synchronized void subscribe(Type[] t, Context cx) {
        int i;
        if (t.length == 0) {
            return;
        }
        for (i = 0; i < t.length; ++i) {
            if (t[i].is(BComponent.TYPE)) continue;
            throw new InvalidParameterException(t[i] + " is not a BComponent type");
        }
        this.updateSpaceSubscription(t, true);
        for (i = 0; i < t.length; ++i) {
            if (this.subscriptions.contains(t[i])) {
                return;
            }
            this.subscriptions.add(t[i]);
            try {
                this.subscribed(t[i], cx);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public final synchronized void unsubscribe(Type t) {
        this.unsubscribe(t, null);
    }

    public final synchronized void unsubscribe(Type t, Context cx) {
        this.unsubscribe(new Type[]{t}, cx);
    }

    public final synchronized void unsubscribe(Type[] t, Context cx) {
        if (t.length == 0) {
            return;
        }
        this.updateSpaceSubscription(t, false);
        for (int i = 0; i < t.length; ++i) {
            this.subscriptions.remove(t[i]);
            try {
                this.unsubscribed(t[i], cx);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public final synchronized void unsubscribeAll() {
        this.unsubscribe(this.getSubscriptions(), null);
    }

    private void updateSpaceSubscription(Type[] t, boolean subscribe) {
        if (this.space != null) {
            if (subscribe) {
                this.space.subscribe(t, this);
            } else {
                this.space.unsubscribe(t, this);
            }
        }
    }

    public final BComponentEventMask getMask() {
        return this.mask;
    }

    public final synchronized void setMask(BComponentEventMask mask) {
        this.mask = mask;
        if (this.space != null && !this.subscriptions.isEmpty()) {
            this.space.updateSubscription(this.getSubscriptions(), this);
        }
    }

    public abstract void event(BComponentEvent var1);

    protected void subscribed(Type t, Context cx) {
    }

    protected void unsubscribed(Type t, Context cx) {
    }

    public void spy(SpyWriter out) {
        out.startTable(true);
        Type[] t = this.getSubscriptions();
        out.trTitle("Subscriptions (" + t.length + " Types)", 1);
        for (int i = 0; i < t.length; ++i) {
            out.tr(t[i].getTypeSpec().toString());
        }
        out.endTable();
    }
}

