/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.module.NModule;
import com.tridium.sys.station.Station;
import java.io.File;
import java.net.InetAddress;
import java.util.Optional;
import javax.baja.license.LicenseException;
import javax.baja.license.LicenseManager;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.security.HsmManager;
import javax.baja.registry.Registry;
import javax.baja.security.Auditor;
import javax.baja.security.SecurityAuditor;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BModule;
import javax.baja.sys.BStation;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;

public final class Sys {
    public static String getLanguage() {
        return Nre.language;
    }

    public static void setLanguage(String language) {
        if (language == null) {
            throw new NullPointerException();
        }
        Nre.language = language;
    }

    public static File getNiagaraUserHome() {
        return Nre.niagaraUserHome;
    }

    public static File getNiagaraSharedUserHome() {
        return Nre.niagaraSharedUserHome;
    }

    public static File getNiagaraDevHome() {
        return Nre.getNiagaraDevHome();
    }

    public static File getCredentialsHome() {
        return Nre.credentialsHome;
    }

    public static File getStationHome() {
        return Nre.stationHome;
    }

    public static File getProtectedStationHome() {
        return Nre.protectedStationHome;
    }

    @Deprecated
    public static InetAddress getLocalHost() {
        return NreLib.getLocalHost();
    }

    public static InetAddress getLocalHost(InetAddress hintAddress) {
        return NreLib.getLocalHost(hintAddress);
    }

    public static String getHostName() {
        return NreLib.getHostName();
    }

    public static BStation getStation() {
        return Station.station;
    }

    public static boolean isStation() {
        return Station.station != null;
    }

    public static boolean isStationStarted() {
        return Station.stationStarted;
    }

    public static boolean atSteadyState() {
        return Station.atSteadyState;
    }

    public static Registry getRegistry() {
        return Nre.getRegistryManager();
    }

    public static LicenseManager getLicenseManager() {
        NLicenseManager lm = Nre.getLicenseManager();
        if (!lm.getClass().getName().equals("com.tridium.sys.license.NodeLockedLicenseManager") && !lm.getClass().getName().equals("com.tridium.sys.license.subscription.SubscriptionLicenseManager")) {
            throw new LicenseException();
        }
        return lm;
    }

    public static String getHostId() {
        return NreLib.getHostId();
    }

    public static HsmManager getHsmManager() {
        return Nre.getHsmManager();
    }

    public static BModule getBajaModule() {
        return BBoolean.TYPE.getModule();
    }

    public static Version getBajaVersion() {
        return Sys.getBajaModule().getVendorVersion(RuntimeProfile.rt);
    }

    public static String getBajaVendor() {
        return Sys.getBajaModule().getVendor(RuntimeProfile.rt);
    }

    public static BModule getModuleForClass(Class<?> cls) {
        NModule module = Nre.getModuleManager().getModuleForClass(cls);
        if (module != null) {
            return module.bmodule();
        }
        return null;
    }

    public static BModule loadModule(String moduleName) throws ModuleNotFoundException, ModuleException {
        NModule[] moduleParts = Nre.getModuleManager().loadModuleParts(moduleName);
        if (moduleParts.length == 0) {
            throw new ModuleNotFoundException(moduleName);
        }
        return moduleParts[0].bmodule();
    }

    public static Class<?> loadClass(String module, String classname) throws ClassNotFoundException, ModuleException {
        return Sys.loadModule(module).loadClass(classname);
    }

    public static Object newInstance(String module, String classname) throws ClassNotFoundException, ModuleException, InstantiationException, IllegalAccessException {
        return Sys.loadClass(module, classname).newInstance();
    }

    public static BComponent getService(Type type) throws ServiceNotFoundException {
        return Nre.getServiceManager().getService(type.getTypeSpec().toString(null));
    }

    public static Optional<BIService> findService(Type type) {
        return Nre.getServiceManager().findService(type.getTypeSpec().toString(null));
    }

    public static BComponent[] getServices(Type type) throws ServiceNotFoundException {
        return Nre.getServiceManager().getServices(type.toString());
    }

    public static Type getType(int id) throws TypeNotFoundException {
        return Nre.getSchemaManager().getType(id);
    }

    public static Type getType(Class<?> cls) throws TypeNotFoundException {
        return Nre.getSchemaManager().getType(cls);
    }

    public static Type getType(String typeSpec) throws ModuleException, TypeException {
        return BTypeSpec.make(typeSpec).getResolvedType();
    }

    public static Type[] getTypes() {
        return Nre.getSchemaManager().getTypes();
    }

    public static Type loadType(Class<?> cls) {
        return Nre.getSchemaManager().load(cls);
    }

    public static Auditor getAuditor() {
        return Nre.auditor;
    }

    public static void setAuditor(Auditor auditor) {
        Nre.auditor = auditor;
    }

    public static SecurityAuditor getSecurityAuditor() {
        return Nre.getSecurityAuditor();
    }
}

