/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.HashMap;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public final class Flags {
    public static final int READONLY = 1;
    public static final int TRANSIENT = 2;
    public static final int HIDDEN = 4;
    public static final int SUMMARY = 8;
    public static final int ASYNC = 16;
    public static final int NO_RUN = 32;
    public static final int DEFAULT_ON_CLONE = 64;
    public static final int CONFIRM_REQUIRED = 128;
    public static final int OPERATOR = 256;
    public static final int EXECUTE_ON_CHANGE = 512;
    public static final int FAN_IN = 1024;
    public static final int NO_AUDIT = 2048;
    public static final int COMPOSITE = 4096;
    public static final int REMOVE_ON_CLONE = 8192;
    public static final int METADATA = 16384;
    public static final int LINK_TARGET = 32768;
    public static final int NON_CRITICAL = 65536;
    public static final int USER_DEFINED_1 = 0x10000000;
    public static final int USER_DEFINED_2 = 0x20000000;
    public static final int USER_DEFINED_3 = 0x40000000;
    public static final int USER_DEFINED_4 = Integer.MIN_VALUE;
    private static final Flag[] FLAGS = new Flag[]{new Flag(1, 'r', "readonly"), new Flag(2, 't', "transient"), new Flag(4, 'h', "hidden"), new Flag(8, 's', "summary"), new Flag(16, 'a', "async"), new Flag(32, 'n', "noRun"), new Flag(64, 'd', "defaultOnClone"), new Flag(128, 'c', "confirmRequired"), new Flag(256, 'o', "operator"), new Flag(512, 'x', "executeOnChange"), new Flag(1024, 'f', "fanIn"), new Flag(2048, 'A', "noAudit"), new Flag(4096, 'p', "composite"), new Flag(8192, 'R', "removeOnClone"), new Flag(16384, 'm', "metadata"), new Flag(65536, 'N', "nonCritical"), new Flag(32768, 'L', "linkTarget"), new Flag(0x10000000, '1', "userDefined1"), new Flag(0x20000000, '2', "userDefined2"), new Flag(0x40000000, '3', "userDefined3"), new Flag(Integer.MIN_VALUE, '4', "userDefined4")};
    private static final IntHashMap byBit = new IntHashMap();
    private static final HashMap<String, Flag> byName = new HashMap();
    private static final Flag[] bySymbol = new Flag[128];

    public static Flag[] getFlags() {
        return (Flag[])FLAGS.clone();
    }

    public static Flag getByBit(int bit) {
        return (Flag)byBit.get(bit);
    }

    public static Flag getByName(String name) {
        return byName.get(name);
    }

    public static Flag getBySymbol(char symbol) {
        if (symbol < '\u0080') {
            return bySymbol[symbol];
        }
        return null;
    }

    public static boolean has(BComplex comp, Slot slot, int flags) {
        return Flags.hasAll(comp, slot, flags);
    }

    public static boolean hasAny(BComplex comp, Slot slot, int ... flags) {
        if (flags.length == 0) {
            return true;
        }
        return (comp.getFlags(slot) & Flags.collect(flags)) != 0;
    }

    public static boolean hasAll(BComplex comp, Slot slot, int ... flags) {
        if (flags.length == 0) {
            return true;
        }
        int flagsToCheck = Flags.collect(flags);
        return (comp.getFlags(slot) & flagsToCheck) == flagsToCheck;
    }

    public static void add(BComponent comp, Slot slot, Context cx, int ... flags) {
        comp.setFlags(slot, Flags.add(comp.getFlags(slot), flags), cx);
    }

    public static int add(int flags, int ... flagsToAdd) {
        return flags | Flags.collect(flagsToAdd);
    }

    public static void remove(BComponent comp, Slot slot, Context cx, int ... flags) {
        comp.setFlags(slot, Flags.remove(comp.getFlags(slot), flags), cx);
    }

    public static int remove(int flags, int ... flagsToRemove) {
        return flags & ~Flags.collect(flagsToRemove);
    }

    private static int collect(int ... flags) {
        int result = 0;
        for (int flag : flags) {
            result |= flag;
        }
        return result;
    }

    public static boolean isTransient(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 2) != 0;
    }

    public static boolean isReadonly(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 1) != 0;
    }

    public static boolean isHidden(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 4) != 0;
    }

    public static boolean isSummary(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 8) != 0;
    }

    public static boolean isAsync(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x10) != 0;
    }

    public static boolean isNoRun(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x20) != 0;
    }

    public static boolean isDefaultOnClone(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x40) != 0;
    }

    public static boolean isConfirmRequired(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x80) != 0;
    }

    public static boolean isOperator(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x100) != 0;
    }

    public static boolean isAdmin(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x100) == 0;
    }

    public static boolean isExecuteOnChange(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x200) != 0;
    }

    public static boolean isFanIn(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x400) != 0;
    }

    public static boolean isNoAudit(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x800) != 0;
    }

    public static boolean isComposite(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x1000) != 0;
    }

    public static boolean isRemoveOnClone(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x2000) != 0;
    }

    public static boolean isMetadata(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x4000) != 0;
    }

    public static boolean isLinkTarget(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x8000) != 0;
    }

    public static boolean isNonCritical(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x10000) != 0;
    }

    public static boolean isUserDefined1(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x10000000) != 0;
    }

    public static boolean isUserDefined2(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x20000000) != 0;
    }

    public static boolean isUserDefined3(BComplex object, Slot slot) {
        return (object.getFlags(slot) & 0x40000000) != 0;
    }

    public static boolean isUserDefined4(BComplex object, Slot slot) {
        return (object.getFlags(slot) & Integer.MIN_VALUE) != 0;
    }

    public static void setAllReadonly(BComponent c, boolean readonly, Context cx) {
        Context tx = Transaction.start(c, cx);
        Property[] props = c.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            BValue val = c.get(prop);
            if (val instanceof BComponent) continue;
            int flags = c.getFlags(prop);
            if (readonly) {
                if ((flags & 1) != 0) continue;
                c.setFlags(prop, flags | 1, tx);
                continue;
            }
            if ((flags & 1) == 0 || !prop.isDynamic() && (prop.getDefaultFlags() & 1) != 0) continue;
            c.setFlags(prop, flags & 0xFFFFFFFE, tx);
        }
        try {
            Transaction.end(c, tx);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("setAllReadonly failed", e);
        }
    }

    public static String encodeToString(int flags) {
        StringBuilder s = new StringBuilder(32);
        for (int i = 0; i < FLAGS.length; ++i) {
            if ((Flags.FLAGS[i].mask & flags) == 0) continue;
            s.append(Flags.FLAGS[i].symbol);
        }
        return s.toString();
    }

    public static int decodeFromString(String flagsStr) {
        int flags = 0;
        for (int i = 0; i < flagsStr.length(); ++i) {
            Flag flag = Flags.getBySymbol(flagsStr.charAt(i));
            if (flag == null) continue;
            flags |= flag.mask;
        }
        return flags;
    }

    public static String toDisplayString(int flags, Context cx) {
        if (flags == 0) {
            return Lexicon.make(Sys.getBajaModule(), cx).getText("flag.none");
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < FLAGS.length; ++i) {
            Flag flag = FLAGS[i];
            if ((flag.mask & flags) == 0) continue;
            if (s.length() > 0) {
                s.append(',').append(' ');
            }
            s.append(flag.getDisplayName(cx));
        }
        return s.toString();
    }

    static {
        for (int i = 0; i < FLAGS.length; ++i) {
            Flag flag = FLAGS[i];
            byBit.put(flag.mask, (Object)flag);
            byName.put(flag.name, flag);
            Flags.bySymbol[flag.symbol] = flag;
        }
    }

    public static class Flag {
        String name;
        char symbol;
        int mask;
        String lexKey;

        Flag(int mask, char symbol, String name) {
            this.mask = mask;
            this.symbol = symbol;
            this.name = name;
            this.lexKey = "flag." + name;
        }

        public int getMask() {
            return this.mask;
        }

        public char getSymbol() {
            return this.symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName(Context cx) {
            return Lexicon.make(Sys.getBajaModule(), cx).getText(this.lexKey);
        }

        public String toString() {
            return this.name;
        }
    }
}

