/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.module.BModulePaletteNode;
import com.tridium.sys.module.BModuleTypesContainer;
import com.tridium.sys.module.NModule;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.space.BISpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModuleDirectory;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleIncompatibleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
public final class BModule
extends BFileSpace
implements BIComparable {
    @Generated
    public static final Type TYPE = Sys.loadType(BModule.class);
    private static final BIcon ICON = BIcon.std("module.png");
    private static final BIcon SYNTH_ICON = BIcon.make(BIcon.std("syntheticModule.png"), BIcon.std("badges/beaker.png"));
    private final Map<RuntimeProfile, NModule> nModulesByProfile = new TreeMap<RuntimeProfile, NModule>();
    private final Map<RuntimeProfile, BZipSpace> zipSpaceByRuntimeProfile = new HashMap<RuntimeProfile, BZipSpace>();
    private final Map<String, BModuleDirectory> rootDirsByRootDirName = new TreeMap<String, BModuleDirectory>();
    private final Map<String, BZipSpace> zipSpaceByRootDirName = new TreeMap<String, BZipSpace>();
    private final Map<String, RuntimeProfile> runtimeProfileByFilePathBody = new TreeMap<String, RuntimeProfile>();
    private String moduleName = null;
    private BOrd ordInSession = null;
    private FilePath rootFilePath = null;
    private String preferredSymbol = null;
    private String description = null;
    private Lexicon lexicon;
    private boolean isSynthetic = true;
    private boolean isTransient = true;
    private final Map<String, Lexicon> lexiconsByLanguage = new HashMap<String, Lexicon>();
    private final Map<String, RuntimeProfile> typeKeyByName = new HashMap<String, RuntimeProfile>();
    private Optional<BModulePaletteNode> paletteNode = null;
    private boolean inInitNavChildren = false;
    private BIFile[] files = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BModule() {
        super(null);
    }

    public static Optional<BModule> getModule(BISpace space) {
        if (space == null) {
            return Optional.empty();
        }
        if (space instanceof BModule) {
            return Optional.of((BModule)space);
        }
        if (space instanceof BZipSpace) {
            return ((BZipSpace)space).getModule();
        }
        return Optional.empty();
    }

    public static boolean isModuleFileSpace(BISpace space) {
        return space != null && (space instanceof BModule || space instanceof BZipSpace && ((BZipSpace)space).isModule());
    }

    public FilePath getRootFilePath() {
        return this.rootFilePath;
    }

    public final boolean hasPalette() {
        this.initNavChildren();
        return this.paletteNode.isPresent();
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final String getPreferredSymbol() {
        return this.preferredSymbol;
    }

    public final Version getBajaVersion(RuntimeProfile profile) {
        return this.nModulesByProfile.get(profile).getBajaVersion();
    }

    public final String getVendor(RuntimeProfile profile) {
        return this.nModulesByProfile.get(profile).getVendor();
    }

    public final Version getVendorVersion(RuntimeProfile profile) {
        return this.nModulesByProfile.containsKey(profile) ? this.nModulesByProfile.get(profile).getVendorVersion() : null;
    }

    public static Version getClassVersion(Class<?> cls) {
        NModule module = AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(cls);
        return module == null ? null : module.getVendorVersion();
    }

    public static String getClassVendor(Class<?> cls) {
        NModule module = AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(cls);
        return module == null ? null : module.getVendor();
    }

    public BModule checkBajaVersion(Version bajaVersion, RuntimeProfile profile) throws ModuleIncompatibleException {
        this.nModulesByProfile.get(profile).checkBajaVersion(bajaVersion);
        return this;
    }

    public BModule checkVendor(String vendor, Version vendorVersion, RuntimeProfile profile) throws ModuleIncompatibleException {
        this.nModulesByProfile.get(profile).checkVendor(vendor, vendorVersion);
        return this;
    }

    public final String getDescription() {
        return this.description;
    }

    public RuntimeProfile getRuntimeProfile(FilePath path) {
        return this.runtimeProfileByFilePathBody.get(path.getBody());
    }

    public ModuleInfo getModuleInfo(RuntimeProfile profile) {
        return Sys.getRegistry().getModule(this.moduleName, profile);
    }

    public ModuleInfo[] getAllModuleInfo() {
        return Sys.getRegistry().getModules(this.moduleName);
    }

    public final Type getType(String typeName) throws TypeException {
        if (this.typeKeyByName.containsKey(typeName)) {
            return this.nModulesByProfile.get(this.typeKeyByName.get(typeName)).getType(typeName);
        }
        throw new TypeNotFoundException(this.moduleName + ":" + typeName);
    }

    public final Class<?> loadClass(String name) throws ClassNotFoundException {
        for (NModule module : this.nModulesByProfile.values()) {
            if (!Nre.supportsProfile(module.getRuntimeProfile())) continue;
            try {
                return module.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(String.format("%s:%s", this.moduleName, name));
    }

    public final URL getResource(String path) {
        for (NModule module : this.nModulesByProfile.values()) {
            URL result;
            if (!Nre.supportsProfile(module.getRuntimeProfile()) || (result = module.getResource(path)) == null) continue;
            return result;
        }
        return null;
    }

    public boolean isSynthetic(RuntimeProfile profile) {
        return this.nModulesByProfile.get(profile).isSynthetic();
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isTransient(RuntimeProfile profile) {
        return this.nModulesByProfile.get(profile).isTransient();
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lexicon getLexicon(String lang) {
        Map<String, Lexicon> map = this.lexiconsByLanguage;
        synchronized (map) {
            Lexicon lexicon = this.lexiconsByLanguage.get(lang);
            if (lexicon == null) {
                lexicon = Lexicon.make(this, lang);
                this.lexiconsByLanguage.put(lang, lexicon);
            }
            return lexicon;
        }
    }

    public String getModulePartName(RuntimeProfile profile) {
        return this.nModulesByProfile.get(profile).getModulePartName();
    }

    public List<RuntimeProfile> getRuntimeProfiles() {
        return this.nModulesByProfile.values().stream().map(NModule::getRuntimeProfile).collect(Collectors.toList());
    }

    public void addModulePart(Object modulePartObj) {
        NModule modulePart = (NModule)modulePartObj;
        RuntimeProfile profile = modulePart.getRuntimeProfile();
        this.clearNavChildren();
        if (this.moduleName == null) {
            this.rootFilePath = new FilePath(BModuleScheme.INSTANCE.getId(), String.format("//%s", modulePart.getModuleName()));
            this.ordInSession = BOrd.make(this.rootFilePath);
            this.moduleName = modulePart.getModuleName();
            this.description = modulePart.getDescription();
            this.preferredSymbol = modulePart.getPreferredSymbol();
        } else if (!modulePart.getModuleName().equals(this.moduleName)) {
            throw new IllegalArgumentException();
        }
        this.nModulesByProfile.put(profile, modulePart);
        if (!modulePart.isTransient()) {
            this.isTransient = false;
            BZipSpace zipSpace = new BZipSpace(this, modulePart.getZipFile());
            this.zipSpaceByRuntimeProfile.put(profile, zipSpace);
            modulePart.moduleFile.addReopenHandler(zip -> zipSpace.fw(9900, zip, null, null, null));
            Enumeration<? extends ZipEntry> entries = modulePart.getZipFile().entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName().replace('\\', '/');
                FilePath path = this.getRootFilePath().merge(name);
                if (path.depth() > 1) {
                    BModuleDirectory root = this.rootDirsByRootDirName.get(path.nameAt(0));
                    if (root == null) {
                        root = new BModuleDirectory(this, this.getRootFilePath().merge(path.nameAt(0)), this);
                        this.rootDirsByRootDirName.put(path.nameAt(0), root);
                    }
                    root.addFile(path, zipSpace);
                    continue;
                }
                if (path.depth() != 1 || name.endsWith(".class") || name.endsWith(".properties") || name.startsWith("META-INF/") || name.startsWith("meta-inf/")) continue;
                this.zipSpaceByRootDirName.put(path.getName(), zipSpace);
                this.runtimeProfileByFilePathBody.put(path.getBody(), profile);
            }
        }
        if (!modulePart.isSynthetic()) {
            this.isSynthetic = false;
        }
        for (String typeName : modulePart.getTypeList()) {
            this.typeKeyByName.put(typeName, modulePart.getRuntimeProfile());
        }
    }

    @Override
    public BHost getHost() {
        return BModuleSpace.INSTANCE.getHost();
    }

    @Override
    public BISession getSession() {
        return BModuleSpace.INSTANCE.getSession();
    }

    @Override
    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    @Override
    protected BOrd appendFilePathToOrd(BOrd baseOrd, FilePath filePath) {
        if (baseOrd == null) {
            return null;
        }
        if (baseOrd.toString().isEmpty()) {
            return BOrd.make(filePath);
        }
        return BOrd.make(baseOrd, filePath);
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        if (path.depth() == 0) {
            return null;
        }
        if (path.depth() == 1) {
            if (this.rootDirsByRootDirName.containsKey(path.getName())) {
                return this.rootDirsByRootDirName.get(path.getName());
            }
            if (this.zipSpaceByRootDirName.containsKey(path.getName())) {
                return this.zipSpaceByRootDirName.get(path.getName()).findStore(path);
            }
            return null;
        }
        BIDirectory parent = this.findDirectory(path.getParent());
        if (parent != null) {
            return ((BModuleDirectory)parent).getChildStore(path.getName());
        }
        return null;
    }

    @Override
    public BIFile getChild(BIFile parent, String childName) {
        if (parent.getStore() instanceof BModuleDirectory) {
            return (BIFile)((BModuleDirectory)parent.getStore()).getNavChild(childName);
        }
        BZipSpace zipSpace = this.findZipSpace(parent.getFilePath());
        return zipSpace == null ? null : zipSpace.getChild(parent, childName);
    }

    @Override
    public BIFile[] getChildren(BIFile parent) {
        if (parent.getStore() instanceof BModuleDirectory) {
            return ((BModuleDirectory)parent.getStore()).listFiles();
        }
        BZipSpace zipSpace = this.findZipSpace(parent.getFilePath());
        return zipSpace == null ? new BIFile[]{} : zipSpace.getChildren(parent);
    }

    @Override
    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        throw new IOException("BModule file space is readonly");
    }

    @Override
    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        throw new IOException("BModule file space is readonly");
    }

    @Override
    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        throw new IOException("BModule file space is readonly");
    }

    @Override
    public void delete(FilePath path, Context cx) throws IOException {
        throw new IOException("BModule file space is readonly");
    }

    @Override
    public int compareTo(Object other) {
        return this.getModuleName().compareTo(((BModule)other).getModuleName());
    }

    @Override
    public BIFile[] listFiles() {
        this.initNavChildren();
        return this.files;
    }

    @Override
    public String getNavName() {
        return this.moduleName;
    }

    @Override
    public BINavNode getNavParent() {
        return BModuleSpace.INSTANCE;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        this.initNavChildren();
        return super.getNavChild(navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.initNavChildren();
        return super.getNavChildren();
    }

    @Override
    public String toString(Context cx) {
        return "Module \"" + this.moduleName + "\" ";
    }

    @Override
    public final Lexicon getLexicon() {
        if (this.lexicon == null || !this.lexicon.language.equals(Sys.getLanguage())) {
            this.lexicon = this.getLexicon(Sys.getLanguage());
        }
        return this.lexicon;
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 405) {
            return this.nModulesByProfile.values().toArray(new NModule[0]);
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public BIcon getIcon() {
        return this.isSynthetic() ? SYNTH_ICON : ICON;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("Module", 2);
        out.prop((Object)"Module Name", this.getModuleName());
        out.prop((Object)"Preferred Symbol", this.getPreferredSymbol());
        out.prop((Object)"Description", this.getDescription());
        out.prop((Object)"Synthetic", this.isSynthetic());
        out.prop((Object)"Transient", this.isTransient());
        out.endProps();
        out.startProps();
        out.trTitle("Module Parts", 4);
        out.w("<tr>").th("Part Name").th("Runtime Profile").th("Vendor").th("Version").th("Release Date").w("</tr>\n");
        this.nModulesByProfile.values().stream().forEach(m -> out.tr(m.getModulePartName(), m.getRuntimeProfile(), m.getVendor(), m.getVendorVersion(), m.getReleaseDate().map(millis -> BAbsTime.make(millis).toDateString(null)).orElse("Unreleased")));
        out.endProps();
        super.spy(out);
    }

    @Override
    protected void clearNavChildren() {
        this.paletteNode = null;
        this.files = null;
        super.clearNavChildren();
    }

    private synchronized void initNavChildren() {
        if (this.inInitNavChildren) {
            return;
        }
        if (this.files == null) {
            try {
                this.inInitNavChildren = true;
                TreeMap accum = new TreeMap();
                ArrayList accumPalettes = new ArrayList();
                this.zipSpaceByRuntimeProfile.values().forEach(zipSpace -> {
                    for (BIFile file : zipSpace.listFiles()) {
                        if (file.getFileName().equals("module.palette")) {
                            if (this.paletteNode != null) continue;
                            accumPalettes.add(file);
                            continue;
                        }
                        accum.put(file.getFileName(), file);
                        if (super.getNavChild(file.getNavName()) != null) continue;
                        this.addNavChild(file);
                    }
                });
                if (!accumPalettes.isEmpty()) {
                    this.paletteNode = Optional.of(BModulePaletteNode.make(this, accumPalettes.toArray(new BIFile[0]), BOrd.make(this.ordInSession + "/module.palette")));
                    this.addNavChild(this.paletteNode.get());
                } else {
                    this.paletteNode = Optional.empty();
                }
                this.addNavChild(BModuleTypesContainer.get(this));
                this.files = (BIFile[])accum.values().stream().sorted(Comparator.comparing(BIFile::getFileName)).toArray(BIFile[]::new);
            }
            finally {
                this.inInitNavChildren = false;
            }
        }
    }

    private BZipSpace findZipSpace(FilePath path) {
        if (path.depth() == 1) {
            return this.zipSpaceByRootDirName.get(path.nameAt(0));
        }
        return this.rootDirsByRootDirName.get(path.nameAt(0)).findZipSpace(path);
    }

    private BIDirectory findDirectory(FilePath path) {
        if (path.depth() == 0) {
            return this;
        }
        if (path.depth() == 1) {
            return this.rootDirsByRootDirName.get(path.nameAt(0));
        }
        return this.rootDirsByRootDirName.get(path.nameAt(0)).findDirectory(path);
    }
}

