/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import javax.baja.util.BNullConverter;

@NiagaraType
@NiagaraProperty(name="converter", type="BConverter", defaultValue="new BNullConverter()")
public class BConversionLink
extends BLink {
    @Generated
    public static final Property converter = BConversionLink.newProperty(0, new BNullConverter(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConversionLink.class);

    @Generated
    public BConverter getConverter() {
        return (BConverter)this.get(converter);
    }

    @Generated
    public void setConverter(BConverter v) {
        this.set(converter, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BConversionLink() {
    }

    public BConversionLink(BOrd sourceOrd, String sourceSlot, String targetSlot, boolean enabled, BConverter converter) {
        super(sourceOrd, sourceSlot, targetSlot, enabled);
        this.setConverter(converter);
    }

    public BConversionLink(BComponent source, Slot sourceSlot, Slot targetSlot, BConverter converter) {
        super(source, sourceSlot, targetSlot);
        this.setConverter(converter);
    }

    @Override
    public void propagate(BValue arg) {
        if (this.getTargetComponent() == this.getSourceComponent() && this.getTargetSlot() == this.getSourceSlot()) {
            System.out.println("WARNING: Infinite link: " + this);
            return;
        }
        Slot sourceSlot = this.getSourceSlot();
        Slot targetSlot = this.getTargetSlot();
        if (sourceSlot.isAction()) {
            if (targetSlot.asAction().getParameterType() != null) {
                arg = (BValue)this.getConverter().convert(arg, targetSlot.asAction().getParameterDefault());
            }
            if (targetSlot.isAction()) {
                this.propagateActionToAction(arg);
                return;
            }
            if (targetSlot.isTopic()) {
                this.propagateActionToTopic(arg);
                return;
            }
        } else if (sourceSlot.isTopic()) {
            if (targetSlot.isAction()) {
                this.propagateTopicToAction(arg);
                return;
            }
            if (targetSlot.isTopic()) {
                this.propagateTopicToTopic(arg);
                return;
            }
        } else if (sourceSlot.isProperty()) {
            if (targetSlot.isAction()) {
                this.propagatePropertyToAction();
                return;
            }
            if (targetSlot.isProperty()) {
                this.propagatePropertyToProperty();
                return;
            }
        }
        throw new IllegalStateException("Invalid link config");
    }

    @Override
    public void propagatePropertyToAction() {
        Slot targetSlot = this.getTargetSlot();
        Action targetAction = targetSlot.asAction();
        BValue arg = null;
        if (targetAction.getParameterType() != null) {
            arg = (BValue)this.getConverter().convert(this.getSourceComponent().get(this.getSourceSlot().asProperty()), targetSlot.asAction().getParameterDefault());
        }
        this.getTargetComponent().invoke(targetAction, arg);
    }

    @Override
    public void propagatePropertyToProperty() {
        BComponent t = this.getTargetComponent();
        BComponent s = this.getSourceComponent();
        Property sProp = this.getSourceSlot().asProperty();
        Property tProp = this.getTargetSlot().asProperty();
        BValue value = (BValue)this.getConverter().convert(s.get(sProp), t.get(tProp));
        switch (tProp.getTypeAccess()) {
            case 0: {
                t.setBoolean(tProp, ((BBoolean)value).getBoolean(), null);
                break;
            }
            case 2: {
                t.setInt(tProp, ((BInteger)value).getInt(), null);
                break;
            }
            case 3: {
                t.setLong(tProp, ((BLong)value).getLong(), null);
                break;
            }
            case 4: {
                t.setFloat(tProp, ((BFloat)value).getFloat(), null);
                break;
            }
            case 5: {
                t.setDouble(tProp, ((BDouble)value).getDouble(), null);
                break;
            }
            case 6: {
                t.setString(tProp, ((BString)value).getString(), null);
                break;
            }
            case 7: {
                if (value.isSimple()) {
                    t.set(tProp, value, null);
                    break;
                }
                t.get(tProp).asComplex().copyFrom(value.asComplex());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected link source type: " + sProp.getType() + " (" + sProp.getTypeAccess() + ")");
            }
        }
    }
}

