/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import com.tridium.sys.engine.NKnob;
import com.tridium.sys.engine.NRelationKnob;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.io.ValueDocEncoder;
import javax.baja.security.BPermissions;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;

public class SyncEncoder
extends ValueDocEncoder {
    boolean encodeForLoad;

    public SyncEncoder(ValueDocEncoder.IEncoderPlugin plugin, Context cx) throws Exception {
        super(plugin, cx);
        this.setEncodeComments(false);
        this.setEncodeTransients(true);
    }

    public SyncEncoder(OutputStream out, Context cx) throws Exception {
        super(out, cx);
        this.setEncodeComments(false);
        this.setEncodeTransients(true);
    }

    @Override
    public boolean isSyncEncoder() {
        return true;
    }

    @Override
    protected void encodingComponent(BComponent c) throws IOException {
        if (this.encodeForLoad) {
            NRelationKnob[] rknobs;
            this.encodeLoadInfo(c);
            NKnob[] knobs = (NKnob[])c.getKnobs();
            if (knobs.length > 0) {
                this.startArray("nk");
                for (int i = 0; i < knobs.length; ++i) {
                    this.encodeKnob(knobs[i]);
                }
                this.endArray();
            }
            if ((rknobs = (NRelationKnob[])c.getRelationKnobs()).length > 0) {
                this.startArray("nrk");
                for (int i = 0; i < rknobs.length; ++i) {
                    if (rknobs[i] == null || rknobs[i].getRelationComponent() == null) continue;
                    this.encodeRelationKnob(rknobs[i]);
                }
                this.endArray();
            }
        }
    }

    @Override
    protected void encodingComponentStub(BComponent c) throws IOException {
        this.encodeLoadInfo(c);
        BValue value = c.get("icon");
        if (value instanceof BIcon) {
            this.newLine().incrementIndent().indent();
            this.startArray("s");
            this.encode("icon", value, 0);
            this.endArray();
            this.decrementIndent().indent();
        }
    }

    private void encodeLoadInfo(BComponent c) throws IOException {
        BPermissions perm = this.getPermissionsFor(c);
        this.key("l").start("load").attr("p", perm.encodeToString()).end();
    }

    protected void encodingSyncOp(SyncOp op) throws IOException {
    }

    void encodeKnob(NKnob knob) throws IOException {
        this.indent();
        this.start("nknob");
        this.attr("id", String.valueOf(knob.id));
        this.attr("ss", knob.getSourceSlotName());
        this.attr("to", knob.getTargetOrd().toString());
        this.attr("ts", knob.getTargetSlotName()).end().newLine();
    }

    void encodeRelationKnob(NRelationKnob knob) throws IOException {
        this.indent();
        this.start("nrknob");
        this.attr("id", String.valueOf(knob.id));
        this.attr("ri", knob.getRelationId());
        this.attr("rt", knob.getRelationTags().encodeToString());
        this.attr("ro", knob.getRelationOrd().toString()).end().newLine();
    }
}

